/**
 * The MediaList interface provides the abstraction of an ordered collection of media, without defining or constraining how this collection is implemented. An empty list is the same as a list that contains the medium "all".The items in the MediaList are accessible via an integral index, starting from 0.
 */
var MediaList = {
}
/**
 * Adds the medium newMedium to the end of the list. If the newMedium is already used, it is first removed.
 * @syntax mediaList.appendMedium(newMedium)
 * @param {String} newMedium The new medium to add.
 * @returns {undefined} 
 */
MediaList.prototype.appendMedium = function(newMedium) {};

/**
 * Returns the indexth in the list. If index is greater than or equal to the number of media in the list, this returns null.
 * @syntax mediaList.item(index)
 * @param {Number} index Index into the collection.
 * @returns {String} The medium at the indexth position in the MediaList, or null if that is not a valid index.
 */
MediaList.prototype.item = function(index) {};

/**
 * The number of media in the list. The range of valid media is 0 to length-1 inclusive.
 * @syntax mediaList.length
 * @returns {Number} 
 */
MediaList.prototype.length = new Number();

/**
 * Deletes the medium indicated by oldMedium from the list.
 * @syntax mediaList.deleteMedium(oldMedium)
 * @param {String} oldMedium The medium to delete in the media list.
 * @returns {undefined} 
 */
MediaList.prototype.deleteMedium = function(oldMedium) {};

/**
 * The parsable textual representation of the media list. This is a comma-separated list of media. Exceptions on setting DOMException SYNTAX_ERR: Raised if the specified string value has a syntax error and is unparsable. NO_MODIFICATION_ALLOWED_ERR: Raised if this media list is readonly.
 * @syntax mediaList.mediaText
 * @returns {String} 
 */
MediaList.prototype.mediaText = new String();

/**
 * Represents the MediaList prototype object.
 * @syntax MediaList.prototype
 * @static
 */
MediaList.prototype;

