/**
 * The DOMImplementationList interface provides the abstraction of an ordered collection of DOM implementations, without defining or constraining how this collection is implemented. The items in the DOMImplementationList are accessible via an integral index, starting from 0.
 */
var DOMImplementationList = {
}
/**
 * Returns the indexth item in the collection. If index is greater than or equal to the number of DOMImplementations in the list, this returns null.
 * @syntax dOMImplementationList.item(index)
 * @param {Number} index Index into the collection.
 * @returns {DOMImplementation} The DOMImplementation at the indexth position in the DOMImplementationList, or null if that is not a valid index.
 */
DOMImplementationList.prototype.item = function(index) {};

/**
 * The number of DOMImplementations in the list. The range of valid child node indices is 0 to length-1 inclusive.
 * @syntax dOMImplementationList.length
 * @returns {Number} 
 */
DOMImplementationList.prototype.length = new Number();

/**
 * Represents the DOMImplementationList prototype object.
 * @syntax DOMImplementationList.prototype
 * @static
 */
DOMImplementationList.prototype;

