/**
 * The CharacterData interface extends Node with a set of attributes and methods for accessing character data in the DOM. For clarity this set is defined here rather than on each object that uses these attributes and methods. No DOM objects correspond directly to CharacterData, though Text and others do inherit the interface from it. All offsets in this interface start from 0.As explained in the DOMString interface, text strings in the DOM are represented in UTF-16, i.e. as a sequence of 16-bit units. In the following, the term 16-bit units is used whenever necessary to indicate that indexing on CharacterData is done in 16-bit units.
 */
var CharacterData = {
}
/**
 * Replace the characters starting at the specified 16-bit unit offset with the specified string
 * @syntax characterData.replaceData(offset, count, arg)
 * @param {Number} offset The offset from which to start replacing.
 * @param {Number} count The number of 16-bit units to replace. If the sum of offset and count exceeds length, then all 16-bit units to the end of the data are replaced; (i.e., the effect is the same as a remove method call with the same range, followed by an append method invocation).
 * @param {String} arg The DOMString with which the range must be replaced.
 * @returns {undefined} 
 */
CharacterData.prototype.replaceData = function(offset,  count,  arg) {};

/**
 * The character data of the node that implements this interface. The DOM implementation may not put arbitrary limits on the amount of data that may be stored in a CharacterData node. However, implementation limits may mean that the entirety of a node's data may not fit into a single DOMString. In such cases, the user may call substringData to retrieve the data in appropriately sized pieces. Exceptions on setting DOMException NO_MODIFICATION_ALLOWED_ERR: Raised when the node is readonly. Exceptions on retrieval DOMException DOMSTRING_SIZE_ERR: Raised when it would return more characters than fit in a DOMString variable on the implementation platform.
 * @syntax characterData.data
 * @returns {String} 
 */
CharacterData.prototype.data = new String();

/**
 * The number of 16-bit units that are available through data and the substringData method below. This may have the value zero, i.e., CharacterData nodes may be empty.
 * @syntax characterData.length
 * @returns {Number} 
 */
CharacterData.prototype.length = new Number();

/**
 * Remove a range of 16-bit units from the node. Upon success, data and length reflect the change
 * @syntax characterData.deleteData(offset, count)
 * @param {Number} offset The offset from which to start removing.
 * @param {Number} count The number of 16-bit units to delete. If the sum of offset and count exceeds length then all 16-bit units from offset to the end of the data are deleted.
 * @returns {undefined} 
 */
CharacterData.prototype.deleteData = function(offset,  count) {};

/**
 * Append the string to the end of the character data of the node. Upon success, data provides access to the concatenation of data and the DOMString specified.
 * @syntax characterData.appendData(arg)
 * @param {String} arg The DOMString to append.
 * @returns {undefined} 
 */
CharacterData.prototype.appendData = function(arg) {};

/**
 * Insert a string at the specified 16-bit unit offset.
 * @syntax characterData.insertData(offset, arg)
 * @param {Number} offset The character offset at which to insert.
 * @param {String} arg The DOMString to insert.
 * @returns {undefined} 
 */
CharacterData.prototype.insertData = function(offset,  arg) {};

/**
 * Extracts a range of data from the node
 * @syntax characterData.substringData(offset, count)
 * @param {Number} offset Start offset of substring to extract.
 * @param {Number} count The number of 16-bit units to extract.
 * @returns {String} The specified substring. If the sum of offset and count exceeds the length, then all 16-bit units to the end of the data are returned.
 */
CharacterData.prototype.substringData = function(offset,  count) {};

/**
 * Represents the CharacterData prototype object.
 * @syntax CharacterData.prototype
 * @static
 */
CharacterData.prototype;

