/**
 * The CSSValueList interface provides the abstraction of an ordered collection of CSS values.Some properties allow an empty list into their syntax. In that case, these properties take the none identifier. So, an empty list means that the property has the value none.The items in the CSSValueList are accessible via an integral index, starting from 0.
 */
var CSSValueList = {
}
/**
 * Used to retrieve a CSSValue by ordinal index. The order in this collection represents the order of the values in the CSS style property. If index is greater than or equal to the number of values in the list, this returns null.
 * @syntax cSSValueList.item(index)
 * @param {Number} index Index into the collection.
 * @returns {CSSValue} The CSSValue at the index position in the CSSValueList, or null if that is not a valid index.
 */
CSSValueList.prototype.item = function(index) {};

/**
 * The number of CSSValues in the list. The range of valid values of the indices is 0 to length-1 inclusive.
 * @syntax cSSValueList.length
 * @returns {Number} 
 */
CSSValueList.prototype.length = new Number();

/**
 * Represents the CSSValueList prototype object.
 * @syntax CSSValueList.prototype
 * @static
 */
CSSValueList.prototype;

