/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.api.network;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import org.netbeans.api.annotations.common.CheckReturnValue;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.web.clientproject.api.network.Bundle;
import org.netbeans.modules.web.clientproject.api.network.NetworkException;
import org.netbeans.modules.web.clientproject.api.network.ui.NetworkErrorPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Cancellable;
import org.openide.util.Pair;
import org.openide.util.Parameters;

public final class NetworkSupport {
    private static final Logger LOGGER = Logger.getLogger(NetworkSupport.class.getName());

    private NetworkSupport() {
    }

    @CheckReturnValue
    public static boolean showNetworkErrorDialog(String failedRequest) {
        Parameters.notNull((CharSequence)"failedRequest", (Object)failedRequest);
        return NetworkSupport.showNetworkErrorDialog(Collections.singletonList(failedRequest));
    }

    @CheckReturnValue
    public static boolean showNetworkErrorDialog(List<String> failedRequests) {
        Parameters.notNull((CharSequence)"failedRequests", failedRequests);
        if (failedRequests.isEmpty()) {
            throw new IllegalArgumentException("Failed requests must be provided.");
        }
        DialogDescriptor descriptor = new DialogDescriptor((Object)new NetworkErrorPanel(failedRequests), Bundle.NetworkSupport_errorDialog_title(), true, 0, DialogDescriptor.YES_OPTION, null);
        JButton configureProxyButton = new JButton(Bundle.NetworkSupport_errorDialog_configureProxy());
        configureProxyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionsDisplayer.getDefault().open("General");
            }
        });
        descriptor.setAdditionalOptions(new Object[]{configureProxyButton});
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor) == NotifyDescriptor.YES_OPTION;
    }

    public static void download(@NonNull String url, @NonNull File target) throws NetworkException, IOException, InterruptedException {
        NetworkSupport.downloadInternal(url, target, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadWithProgress(@NonNull String url, @NonNull File target, @NonNull String displayName) throws NetworkException, IOException, InterruptedException {
        Parameters.notNull((CharSequence)"displayName", (Object)displayName);
        final Thread downloadThread = Thread.currentThread();
        ProgressHandle progressHandle = ProgressHandle.createHandle((String)displayName, (Cancellable)new Cancellable(){

            public boolean cancel() {
                downloadThread.interrupt();
                return true;
            }
        });
        progressHandle.start();
        try {
            NetworkSupport.downloadInternal(url, target, progressHandle);
        }
        finally {
            progressHandle.finish();
        }
    }

    public static void downloadWithProgress(@NonNull String url, @NonNull File target, @NonNull ProgressHandle progressHandle) throws NetworkException, IOException, InterruptedException {
        Parameters.notNull((CharSequence)"progressHandle", (Object)progressHandle);
        NetworkSupport.downloadInternal(url, target, progressHandle);
    }

    private static void downloadInternal(@NonNull String url, @NonNull File target, @NullAllowed ProgressHandle progressHandle) throws NetworkException, IOException, InterruptedException {
        Parameters.notNull((CharSequence)"url", (Object)url);
        Parameters.notNull((CharSequence)"target", (Object)target);
        if (EventQueue.isDispatchThread()) {
            throw new IllegalStateException("Cannot run in UI thread");
        }
        Pair<InputStream, Integer> downloadSetup = NetworkSupport.prepareDownload(url, progressHandle);
        NetworkSupport.checkInterrupted();
        NetworkSupport.doDownload(url, target, downloadSetup, progressHandle);
    }

    private static Pair<InputStream, Integer> prepareDownload(String url, @NullAllowed ProgressHandle progressHandle) throws NetworkException, InterruptedException {
        try {
            int contentLength = -1;
            URL resource = new URL(url);
            if (progressHandle != null) {
                progressHandle.switchToIndeterminate();
                progressHandle.progress(Bundle.NetworkSupport_progress_prepare());
                contentLength = NetworkSupport.getContentLength(resource);
                if (contentLength != -1) {
                    progressHandle.switchToDeterminate(contentLength);
                }
            }
            NetworkSupport.checkInterrupted();
            HttpURLConnection connection = (HttpURLConnection)resource.openConnection();
            connection.setRequestProperty("User-Agent", "Mozilla/5.0");
            return Pair.of((Object)connection.getInputStream(), (Object)contentLength);
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, null, ex);
            throw new NetworkException(url, (Throwable)ex);
        }
    }

    private static int getContentLength(URL url) throws IOException, InterruptedException {
        NetworkSupport.checkInterrupted();
        URLConnection urlConnection = url.openConnection();
        int length = urlConnection.getContentLength();
        if (length != -1) {
            return length;
        }
        if (urlConnection instanceof HttpURLConnection) {
            NetworkSupport.checkInterrupted();
            HttpURLConnection httpUrlConnection = (HttpURLConnection)url.openConnection();
            httpUrlConnection.setRequestMethod("HEAD");
            try (InputStream inputStream = httpUrlConnection.getInputStream();){
                int n = httpUrlConnection.getContentLength();
                return n;
            }
        }
        return -1;
    }

    private static void doDownload(String url, File target, Pair<InputStream, Integer> downloadSetup, @NullAllowed ProgressHandle progressHandle) throws IOException, InterruptedException {
        if (progressHandle != null) {
            progressHandle.progress(Bundle.NetworkSupport_progress_download(url));
        }
        try (InputStream is = (InputStream)downloadSetup.first();){
            NetworkSupport.copyToFile(is, target, progressHandle, (Integer)downloadSetup.second());
        }
        catch (IOException ex) {
            if (!target.delete()) {
                // empty if block
            }
            throw ex;
        }
    }

    private static File copyToFile(InputStream is, File target, @NullAllowed ProgressHandle progressHandle, int contentLength) throws IOException, InterruptedException {
        try (FileOutputStream os = new FileOutputStream(target);){
            byte[] buffer = new byte[65536];
            int read = 0;
            while (true) {
                NetworkSupport.checkInterrupted();
                int len = is.read(buffer);
                if (len == -1) {
                    break;
                }
                ((OutputStream)os).write(buffer, 0, len);
                if (contentLength == -1) continue;
                assert (progressHandle != null);
                progressHandle.progress(read += len);
            }
        }
        return target;
    }

    private static void checkInterrupted() throws InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
    }
}

