/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.debugger;

import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.apache.tools.ant.module.spi.AntEvent;
import org.apache.tools.ant.module.spi.AntLogger;
import org.apache.tools.ant.module.spi.AntSession;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerInfo;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.ant.debugger.AntDebugger;
import org.netbeans.spi.debugger.SessionProvider;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Lookup;

public class DebuggerAntLogger
extends AntLogger {
    private Map<AntSession, AntDebugger> runningDebuggers = new HashMap<AntSession, AntDebugger>();
    private Map<AntDebugger, AntSession> runningDebuggers2 = new HashMap<AntDebugger, AntSession>();
    private Set<File> filesToDebug = new HashSet<File>();
    private Map<File, WeakReference> fileExecutors = new HashMap<File, WeakReference>();

    static DebuggerAntLogger getDefault() {
        for (AntLogger al : Lookup.getDefault().lookupAll(AntLogger.class)) {
            if (!(al instanceof DebuggerAntLogger)) continue;
            return (DebuggerAntLogger)al;
        }
        throw new InternalError();
    }

    public void buildInitializationFailed(AntEvent event) {
    }

    public void buildStarted(AntEvent event) {
    }

    public void buildFinished(AntEvent event) {
        AntDebugger d = this.getDebugger(event.getSession(), event);
        if (d == null) {
            return;
        }
        d.buildFinished(event);
        this.finishDebugging(d);
    }

    public void targetStarted(AntEvent event) {
        AntDebugger d = this.getDebugger(event.getSession(), event);
        if (d == null) {
            return;
        }
        d.targetStarted(event);
    }

    public void targetFinished(AntEvent event) {
        AntDebugger d = this.getDebugger(event.getSession(), event);
        if (d == null) {
            return;
        }
        d.targetFinished(event);
    }

    public void taskStarted(AntEvent event) {
        AntDebugger d = this.getDebugger(event.getSession(), event);
        if (d == null) {
            return;
        }
        d.taskStarted(event);
    }

    public void taskFinished(AntEvent event) {
        AntDebugger d = this.getDebugger(event.getSession(), event);
        if (d == null) {
            return;
        }
        d.taskFinished(event);
    }

    public void messageLogged(AntEvent event) {
    }

    public boolean interestedInSession(AntSession session) {
        return true;
    }

    public boolean interestedInAllScripts(AntSession session) {
        return true;
    }

    public boolean interestedInScript(File script, AntSession session) {
        return true;
    }

    public String[] interestedInTargets(AntSession session) {
        return ALL_TARGETS;
    }

    public String[] interestedInTasks(AntSession session) {
        return ALL_TASKS;
    }

    public int[] interestedInLogLevels(AntSession session) {
        return new int[]{2, 4, 0, 3, 1};
    }

    void debugFile(File f) {
        this.filesToDebug.add(f);
    }

    void fileExecutor(File f, ExecutorTask execTask) {
        this.fileExecutors.put(f, new WeakReference<ExecutorTask>(execTask));
    }

    private void finishDebugging(AntDebugger debugger) {
        AntSession session = this.runningDebuggers2.remove((Object)debugger);
        this.runningDebuggers.remove(session);
    }

    private AntDebugger getDebugger(AntSession s, AntEvent antEvent) {
        DataObject dob;
        AntDebugger d = this.runningDebuggers.get(s);
        if (d != null) {
            return d;
        }
        if (!this.filesToDebug.contains(s.getOriginatingScript())) {
            return null;
        }
        this.filesToDebug.remove(s.getOriginatingScript());
        Reference execRef = this.fileExecutors.remove(s.getOriginatingScript());
        ExecutorTask execTask = null;
        if (execRef != null) {
            execTask = (ExecutorTask)execRef.get();
        }
        FileObject fo = FileUtil.toFileObject((File)s.getOriginatingScript());
        try {
            dob = DataObject.find((FileObject)fo);
        }
        catch (DataObjectNotFoundException ex) {
            Logger.getLogger(DebuggerAntLogger.class.getName()).log(Level.CONFIG, "No DataObject from " + fo, ex);
            return null;
        }
        AntProjectCookie antCookie = (AntProjectCookie)dob.getLookup().lookup(AntProjectCookie.class);
        if (antCookie == null) {
            throw new NullPointerException("No AntProjectCookie provided by " + dob);
        }
        d = DebuggerAntLogger.startDebugging(antCookie, antEvent, execTask);
        this.runningDebuggers.put(s, d);
        this.runningDebuggers2.put(d, s);
        return d;
    }

    private static AntDebugger startDebugging(AntProjectCookie antCookie, final AntEvent antEvent, ExecutorTask execTask) {
        DebuggerInfo di = DebuggerInfo.create((String)"AntDebuggerInfo", (Object[])new Object[]{new SessionProvider(){

            public String getSessionName() {
                return antEvent.getSession().getDisplayName();
            }

            public String getLocationName() {
                return "localhost";
            }

            public String getTypeID() {
                return "AntSession";
            }

            public Object[] getServices() {
                return new Object[0];
            }
        }, antCookie});
        DebuggerEngine[] es = DebuggerManager.getDebuggerManager().startDebugging(di);
        AntDebugger debugger = (AntDebugger)((Object)es[0].lookupFirst(null, AntDebugger.class));
        debugger.setExecutor(execTask);
        return debugger;
    }
}

