/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.infrastructure;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.LineMap;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.lang.model.element.Element;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.lsp.CodeAction;
import org.netbeans.api.lsp.Command;
import org.netbeans.api.lsp.Diagnostic;
import org.netbeans.api.lsp.ResourceOperation;
import org.netbeans.api.lsp.TextDocumentEdit;
import org.netbeans.api.lsp.TextEdit;
import org.netbeans.api.lsp.WorkspaceEdit;
import org.netbeans.modules.java.hints.errors.CreateFixBase;
import org.netbeans.modules.java.hints.errors.ImportClass;
import org.netbeans.modules.java.hints.infrastructure.CreatorBasedLazyFixList;
import org.netbeans.modules.java.hints.infrastructure.ErrorHintsProvider;
import org.netbeans.modules.java.hints.project.IncompleteClassPath;
import org.netbeans.modules.java.hints.spiimpl.JavaFixImpl;
import org.netbeans.modules.java.hints.spiimpl.Utilities;
import org.netbeans.modules.java.hints.spiimpl.hints.HintsInvoker;
import org.netbeans.modules.java.hints.spiimpl.options.HintsSettings;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.spi.editor.hints.EnhancedFix;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.LazyFixList;
import org.netbeans.spi.editor.hints.Severity;
import org.netbeans.spi.java.hints.JavaFix;
import org.netbeans.spi.lsp.ErrorProvider;
import org.openide.filesystems.FileObject;
import org.openide.text.PositionBounds;
import org.openide.util.Exceptions;
import org.openide.util.Union2;

public class JavaErrorProvider
implements ErrorProvider {
    public static Consumer<ErrorProvider.Kind> computeDiagsCallback;
    private static final String DEFAULT_SORT_TEXT = "\uffff";

    public List<? extends Diagnostic> computeErrors(final ErrorProvider.Context context) {
        final ArrayList result = new ArrayList();
        try {
            ParserManager.parse(Collections.singletonList(Source.create((FileObject)context.file())), (UserTask)new UserTask(){

                public void run(ResultIterator it) throws Exception {
                    CompilationController cc = CompilationController.get((Parser.Result)it.getParserResult());
                    if (cc != null) {
                        if (computeDiagsCallback != null) {
                            computeDiagsCallback.accept(context.errorKind());
                        }
                        cc.toPhase(JavaSource.Phase.RESOLVED);
                        switch (context.errorKind()) {
                            case ERRORS: {
                                ErrorHintsProvider ehp = new ErrorHintsProvider();
                                context.registerCancelCallback(() -> ehp.cancel());
                                result.addAll(JavaErrorProvider.convert2Diagnostic(context.errorKind(), ehp.computeErrors((CompilationInfo)cc, cc.getSnapshot().getSource().getDocument(true), "text/x-java"), err -> true));
                                break;
                            }
                            case HINTS: {
                                Set disabled = Utilities.disableErrors((FileObject)cc.getFileObject());
                                if (disabled.size() == Severity.values().length) break;
                                AtomicBoolean cancel = new AtomicBoolean();
                                context.registerCancelCallback(() -> cancel.set(true));
                                result.addAll(JavaErrorProvider.convert2Diagnostic(context.errorKind(), new HintsInvoker(HintsSettings.getGlobalSettings(), context.getOffset(), cancel).computeHints((CompilationInfo)cc), ed -> !disabled.contains(ed.getSeverity())));
                            }
                        }
                    }
                }
            });
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return result;
    }

    public static List<Diagnostic> convert2Diagnostic(ErrorProvider.Kind errorKind, List<ErrorDescription> errors, Predicate<ErrorDescription> filter) {
        if (errors == null) {
            return Collections.emptyList();
        }
        int idx = 0;
        ArrayList<Diagnostic> result = new ArrayList<Diagnostic>();
        for (ErrorDescription err : errors) {
            if (!filter.test(err)) continue;
            PositionBounds range = err.getRange();
            Diagnostic.Builder diagBuilder = Diagnostic.Builder.create(() -> range.getBegin().getOffset(), () -> range.getEnd().getOffset(), (String)err.getDescription());
            switch (err.getSeverity()) {
                case ERROR: {
                    diagBuilder.setSeverity(Diagnostic.Severity.Error);
                    break;
                }
                case VERIFIER: 
                case WARNING: {
                    diagBuilder.setSeverity(Diagnostic.Severity.Warning);
                    break;
                }
                case HINT: {
                    diagBuilder.setSeverity(Diagnostic.Severity.Hint);
                    break;
                }
                default: {
                    diagBuilder.setSeverity(Diagnostic.Severity.Information);
                }
            }
            String id = JavaErrorProvider.key(errorKind) + ":" + idx++ + "-" + err.getId();
            diagBuilder.setCode(id);
            diagBuilder.addActions(errorReporter -> JavaErrorProvider.convertFixes(err, errorReporter));
            result.add(diagBuilder.build());
        }
        return result;
    }

    private static String key(ErrorProvider.Kind errorKind) {
        return errorKind.name().toLowerCase(Locale.ROOT);
    }

    private static List<CodeAction> convertFixes(ErrorDescription err, Consumer<Exception> errorReporter) {
        FileObject file = err.getFile();
        JavaSource js = JavaSource.forFileObject((FileObject)file);
        TreePathHandle[] topLevelHandle = new TreePathHandle[1];
        LazyFixList lfl = err.getFixes();
        if (lfl instanceof CreatorBasedLazyFixList) {
            try {
                js.runUserActionTask(cc -> {
                    cc.toPhase(JavaSource.Phase.RESOLVED);
                    ((CreatorBasedLazyFixList)lfl).compute((CompilationInfo)cc, new AtomicBoolean());
                    topLevelHandle[0] = TreePathHandle.create((TreePath)new TreePath(cc.getCompilationUnit()), (CompilationInfo)cc);
                }, true);
            }
            catch (IOException ex) {
                errorReporter.accept(ex);
            }
        }
        List<Fix> fixes = JavaErrorProvider.sortFixes(lfl.getFixes());
        ArrayList<CodeAction> result = new ArrayList<CodeAction>();
        for (Fix f : fixes) {
            if (f instanceof IncompleteClassPath.ResolveFix) {
                CodeAction action = new CodeAction(f.getText(), new Command(f.getText(), "XXX"));
                result.add(action);
            }
            if (f instanceof ImportClass.FixImport) {
                final String text = f.getText();
                CharSequence sortText = ((ImportClass.FixImport)f).getSortText();
                final ElementHandle<Element> toImport = ((ImportClass.FixImport)f).getToImport();
                f = new JavaFix(topLevelHandle[0], sortText != null ? sortText.toString() : null){

                    protected String getText() {
                        return text;
                    }

                    protected void performRewrite(JavaFix.TransformationContext ctx) throws Exception {
                        Element resolved = toImport.resolve((CompilationInfo)ctx.getWorkingCopy());
                        if (resolved == null) {
                            return;
                        }
                        WorkingCopy copy = ctx.getWorkingCopy();
                        CompilationUnitTree cut = GeneratorUtilities.get((WorkingCopy)copy).addImports(copy.getCompilationUnit(), Collections.singleton(resolved));
                        copy.rewrite((Tree)copy.getCompilationUnit(), (Tree)cut);
                    }
                }.toEditorFix();
            }
            if (f instanceof JavaFixImpl) {
                try {
                    JavaFix jf = ((JavaFixImpl)f).jf;
                    List<TextEdit> edits = JavaErrorProvider.modify2TextEdits(js, (Task<WorkingCopy>)((Task)wc -> {
                        wc.toPhase(JavaSource.Phase.RESOLVED);
                        HashMap resourceContentChanges = new HashMap();
                        JavaFixImpl.Accessor.INSTANCE.process(jf, wc, true, resourceContentChanges, new ArrayList());
                    }));
                    TextDocumentEdit te = new TextDocumentEdit(file.toURI().toString(), edits);
                    CodeAction action = new CodeAction(f.getText(), new WorkspaceEdit(Collections.singletonList(Union2.createFirst((Object)te))));
                    result.add(action);
                }
                catch (IOException ex) {
                    errorReporter.accept(ex);
                }
            }
            if (!(f instanceof CreateFixBase)) continue;
            try {
                CreateFixBase cf = (CreateFixBase)f;
                ModificationResult changes = cf.getModificationResult();
                ArrayList<Union2> documentChanges = new ArrayList<Union2>();
                Set newFiles = changes.getNewFiles();
                if (newFiles.size() > 1) {
                    throw new IllegalStateException();
                }
                String newFilePath = null;
                for (File newFile : newFiles) {
                    newFilePath = newFile.toURI().toString();
                    documentChanges.add(Union2.createSecond((Object)new ResourceOperation.CreateFile(newFilePath)));
                }
                block8: for (FileObject fileObject : changes.getModifiedFileObjects()) {
                    List diffs = changes.getDifferences(fileObject);
                    if (diffs == null) continue;
                    ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
                    for (ModificationResult.Difference diff : diffs) {
                        String newText = diff.getNewText();
                        if (diff.getKind() == ModificationResult.Difference.Kind.CREATE) {
                            if (newFilePath == null) continue block8;
                            documentChanges.add(Union2.createFirst((Object)new TextDocumentEdit(newFilePath, Collections.singletonList(new TextEdit(0, 0, newText != null ? newText : "")))));
                            continue block8;
                        }
                        edits.add(new TextEdit(diff.getStartPosition().getOffset(), diff.getEndPosition().getOffset(), newText != null ? newText : ""));
                    }
                    documentChanges.add(Union2.createFirst((Object)new TextDocumentEdit(fileObject.toURI().toString(), edits)));
                }
                if (documentChanges.isEmpty()) continue;
                CodeAction codeAction = new CodeAction(f.getText(), new WorkspaceEdit(documentChanges));
                result.add(codeAction);
            }
            catch (IOException ex) {
                errorReporter.accept(ex);
            }
        }
        return result;
    }

    private static List<Fix> sortFixes(Collection<Fix> fixes) {
        ArrayList<Fix> result = new ArrayList<Fix>(fixes);
        Collections.sort(result, new FixComparator());
        return result;
    }

    private static CharSequence getSortText(Fix f) {
        if (f instanceof EnhancedFix) {
            return ((EnhancedFix)f).getSortText();
        }
        return DEFAULT_SORT_TEXT;
    }

    private static int compareText(CharSequence text1, CharSequence text2) {
        int len = Math.min(text1.length(), text2.length());
        for (int i = 0; i < len; ++i) {
            char ch2;
            char ch1 = text1.charAt(i);
            if (ch1 == (ch2 = text2.charAt(i))) continue;
            return ch1 - ch2;
        }
        return text1.length() - text2.length();
    }

    private static List<TextEdit> modify2TextEdits(JavaSource js, Task<WorkingCopy> task) throws IOException {
        FileObject[] file = new FileObject[1];
        LineMap[] lm = new LineMap[1];
        ModificationResult changes = js.runModificationTask(wc -> {
            task.run(wc);
            file[0] = wc.getFileObject();
            lm[0] = wc.getCompilationUnit().getLineMap();
        });
        return JavaErrorProvider.fileModifications(changes, file[0], lm[0]);
    }

    private static List<TextEdit> fileModifications(ModificationResult changes, FileObject file, LineMap lm) {
        List diffs = changes.getDifferences(file);
        if (diffs == null) {
            return Collections.emptyList();
        }
        ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
        for (ModificationResult.Difference diff : diffs) {
            String newText = diff.getNewText();
            edits.add(new TextEdit(diff.getStartPosition().getOffset(), diff.getEndPosition().getOffset(), newText != null ? newText : ""));
        }
        return edits;
    }

    private static final class FixComparator
    implements Comparator<Fix> {
        private FixComparator() {
        }

        @Override
        public int compare(Fix o1, Fix o2) {
            return JavaErrorProvider.compareText(JavaErrorProvider.getSortText(o1), JavaErrorProvider.getSortText(o2));
        }
    }
}

