/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.execute;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.execute.ActionToGoalUtils;
import org.netbeans.modules.maven.execute.BeanRunConfig;
import org.netbeans.modules.maven.execute.model.NetbeansActionMapping;
import org.netbeans.modules.maven.runjar.MavenExecuteUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public final class ModelRunConfig
extends BeanRunConfig {
    private static final Logger LOG = Logger.getLogger(ModelRunConfig.class.getName());
    private final NetbeansActionMapping model;
    private final boolean fallback;
    public static final String EXEC_MERGED = "exec.args.merged";
    private static final String CP_PLACEHOLDER = "___CP___";
    private static final String EXEC_ARGS = "exec.args";

    public ModelRunConfig(Project proj, NetbeansActionMapping mod, String actionName, FileObject selectedFile, Lookup lookup, boolean fallback) {
        String react;
        this.model = mod;
        this.fallback = fallback;
        NbMavenProjectImpl nbprj = (NbMavenProjectImpl)proj.getLookup().lookup(NbMavenProjectImpl.class);
        this.setProject(nbprj);
        String label = ProjectUtils.getInformation((Project)proj).getDisplayName();
        this.setExecutionName(label);
        this.setTaskDisplayName(label);
        for (Map.Entry<String, String> entry : this.model.getProperties().entrySet()) {
            String execArgsByPom;
            String defaultArgsTemplate;
            String key = entry.getKey();
            String value = entry.getValue();
            if (EXEC_ARGS.equals(key) && (defaultArgsTemplate = MavenExecuteUtils.doesNotSpecifyCustomExecArgs(this.model)) != null && (execArgsByPom = ModelRunConfig.getExecArgsByPom(this.model, proj)) != null) {
                value = execArgsByPom.contains(CP_PLACEHOLDER) ? execArgsByPom.replace(CP_PLACEHOLDER, defaultArgsTemplate) : execArgsByPom;
                this.setProperty(EXEC_MERGED, "true");
            }
            this.setProperty(key, value);
        }
        this.setGoals(this.model.getGoals());
        this.setExecutionDirectory(ActionToGoalUtils.resolveProjectExecutionBasedir(mod, proj));
        this.setRecursive(mod.isRecursive());
        this.setActivatedProfiles(mod.getActivatedProfiles());
        this.setActionName(actionName);
        this.setFileObject(selectedFile);
        this.setActionContext(lookup);
        if (mod.getPreAction() != null) {
            this.setPreExecution(ActionToGoalUtils.createRunConfig(mod.getPreAction(), nbprj, lookup));
        }
        if ((react = mod.getReactor()) != null) {
            if ("am".equals(react) || "also-make".equals(react)) {
                this.setReactorStyle(RunConfig.ReactorStyle.ALSO_MAKE);
            } else if ("amd".equals(react) || "also-make-dependents".equals(react)) {
                this.setReactorStyle(RunConfig.ReactorStyle.ALSO_MAKE_DEPENDENTS);
            }
        }
    }

    public boolean isFallback() {
        return this.fallback;
    }

    static String getExecArgsByPom(NetbeansActionMapping model, Project proj) {
        if (Boolean.getBoolean("maven.doNotMergePomExecArgs")) {
            return null;
        }
        List<String> goals = model.getGoals();
        for (String goal : goals) {
            NbMavenProjectImpl projectImpl;
            if (!goal.matches("org\\.codehaus\\.mojo\\:exec-maven-plugin\\:(.)+\\:exec")) continue;
            NbMavenProjectImpl nbMavenProjectImpl = projectImpl = proj instanceof NbMavenProjectImpl ? (NbMavenProjectImpl)proj : (NbMavenProjectImpl)proj.getLookup().lookup(NbMavenProjectImpl.class);
            assert (projectImpl != null) : "Requires a maven project instance";
            return PluginPropertyUtils.getPluginPropertyBuildable(projectImpl, "org.codehaus.mojo", "exec-maven-plugin", "exec", new ExecPluginConfigBuilder());
        }
        return null;
    }

    private static class ExecPluginConfigBuilder
    implements PluginPropertyUtils.ConfigurationBuilder<String> {
        private ExecPluginConfigBuilder() {
        }

        @Override
        public String build(Xpp3Dom configRoot, ExpressionEvaluator eval) {
            Xpp3Dom domArgs;
            if (configRoot != null && (domArgs = configRoot.getChild("arguments")) != null) {
                Xpp3Dom[] children = domArgs.getChildren();
                if (children == null || children.length == 0) {
                    return null;
                }
                Iterator<Xpp3Dom> it = Arrays.asList(children).iterator();
                StringBuilder sb = new StringBuilder();
                try {
                    while (it.hasNext()) {
                        Xpp3Dom xpp3Dom = it.next();
                        String val = null;
                        if ("argument".equals(xpp3Dom.getName())) {
                            val = xpp3Dom.getValue();
                            if (val == null || val.trim().isEmpty()) continue;
                            if ((val = val.trim()).contains("${")) {
                                LOG.log(Level.FINE, "skipping not evaluated property: {0}", val);
                                val = null;
                            }
                            if ("-cp".equals(val) || "-classpath".equals(val)) {
                                val = null;
                                Xpp3Dom dom = it.next();
                                if (dom != null && "classpath".equals(dom.getName())) {
                                    Xpp3Dom[] deps = dom.getChildren("dependency");
                                    if (deps == null || deps.length == 0) {
                                        val = ModelRunConfig.CP_PLACEHOLDER;
                                    } else {
                                        for (Xpp3Dom dep : deps) {
                                            String d;
                                            if (dep == null || (d = dep.getValue()) == null || d.trim().isEmpty()) continue;
                                            LOG.log(Level.FINE, "skipping whole args evaluation due to explicitely declared deps");
                                            return null;
                                        }
                                    }
                                }
                            }
                        }
                        if (val == null || val.isEmpty()) continue;
                        if (sb.length() > 0) {
                            sb.append(" ");
                        }
                        sb.append(val);
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
                return sb.length() > 0 ? sb.toString() : null;
            }
            return null;
        }
    }
}

