/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.completion.inference;

import groovy.lang.Range;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.RangeExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.SourceUnit;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.groovy.editor.api.ASTUtils;
import org.netbeans.modules.groovy.editor.api.AstPath;
import org.netbeans.modules.groovy.editor.completion.inference.MethodInference;
import org.netbeans.modules.groovy.editor.occurrences.TypeVisitor;

public class TypeInferenceVisitor
extends TypeVisitor {
    private ClassNode guessedType;
    private boolean leafReached = false;
    private ASTNode leafStatement;

    public TypeInferenceVisitor(SourceUnit sourceUnit, AstPath path, BaseDocument doc, int cursorOffset) {
        super(sourceUnit, path, doc, cursorOffset, false);
    }

    public ClassNode getGuessedType() {
        return this.guessedType;
    }

    @Override
    public void collect() {
        this.guessedType = null;
        this.leafReached = false;
        super.collect();
    }

    @Override
    protected void visitParameters(Parameter[] parameters, Variable variable) {
        if (!this.leafReached) {
            for (Parameter param : parameters) {
                if (!TypeInferenceVisitor.sameVariableName(param, variable)) continue;
                this.guessedType = param.getType();
                break;
            }
        }
    }

    public void visitField(FieldNode node) {
        if (TypeInferenceVisitor.sameVariableName(this.leaf, node) && node.hasInitialExpression()) {
            Expression expression = node.getInitialExpression();
            if (expression instanceof ConstantExpression && !expression.getText().equals("null")) {
                this.guessedType = ((ConstantExpression)expression).getType();
            } else if (expression instanceof ConstructorCallExpression) {
                this.guessedType = ((ConstructorCallExpression)expression).getType();
            } else if (expression instanceof MethodCallExpression) {
                int newOffset = ASTUtils.getOffset(this.doc, expression.getLineNumber(), expression.getColumnNumber());
                AstPath newPath = new AstPath(this.path.root(), newOffset, this.doc);
                this.guessedType = MethodInference.findCallerType((ASTNode)expression, newPath, this.doc, newOffset);
            }
        }
    }

    public void visitDeclarationExpression(DeclarationExpression expression) {
        ClassNode fromExpression;
        if (TypeInferenceVisitor.sameVariableName(this.leaf, (ASTNode)expression.getLeftExpression()) && (fromExpression = this.deriveExpressonType(expression.getRightExpression())) != null) {
            this.guessedType = fromExpression;
        }
    }

    protected void visitStatement(Statement statement) {
        super.visitStatement(statement);
        if (statement == this.leafStatement) {
            this.leafReached = true;
        }
    }

    public void visitBlockStatement(BlockStatement statement) {
        ASTNode prev = null;
        for (ASTNode n : this.path) {
            if (n == statement) {
                this.leafStatement = prev;
                break;
            }
            prev = n;
        }
        super.visitBlockStatement(statement);
    }

    public void visitVariableExpression(VariableExpression expression) {
        boolean guessed = true;
        if (this.leaf instanceof VariableExpression && !TypeInferenceVisitor.sameVariableName(this.leaf, (ASTNode)expression)) {
            return;
        }
        if (expression.isSuperExpression()) {
            this.guessedType = expression.getType().getSuperClass();
        }
        if (null != expression.getAccessedVariable()) {
            Variable accessedVariable = expression.getAccessedVariable();
            if (accessedVariable.hasInitialExpression()) {
                Expression initialExpression = expression.getAccessedVariable().getInitialExpression();
                if (initialExpression instanceof ConstantExpression && !initialExpression.getText().equals("null")) {
                    this.guessedType = ((ConstantExpression)initialExpression).getType();
                } else if (initialExpression instanceof ConstructorCallExpression) {
                    this.guessedType = ClassHelper.make((String)((ConstructorCallExpression)initialExpression).getType().getName());
                } else if (initialExpression instanceof MethodCallExpression) {
                    int newOffset = ASTUtils.getOffset(this.doc, initialExpression.getLineNumber(), initialExpression.getColumnNumber());
                    AstPath newPath = new AstPath(this.path.root(), newOffset, this.doc);
                    this.guessedType = MethodInference.findCallerType((ASTNode)initialExpression, newPath, this.doc, newOffset);
                } else if (initialExpression instanceof ListExpression) {
                    this.guessedType = ((ListExpression)initialExpression).getType();
                } else if (initialExpression instanceof MapExpression) {
                    this.guessedType = ((MapExpression)initialExpression).getType();
                } else if (initialExpression instanceof RangeExpression) {
                    this.guessedType = ClassHelper.makeWithoutCaching(Range.class, (boolean)true);
                } else {
                    guessed = false;
                }
            } else if (accessedVariable instanceof Parameter) {
                Parameter param = (Parameter)accessedVariable;
                this.guessedType = param.getType();
            } else {
                guessed = false;
            }
        }
        if (!guessed && !expression.getType().getName().equals("java.lang.Object")) {
            this.guessedType = expression.getType();
        }
        super.visitVariableExpression(expression);
    }

    public void visitBinaryExpression(BinaryExpression expression) {
        Expression leftExpression;
        if (!this.leafReached && (leftExpression = expression.getLeftExpression()) instanceof VariableExpression && expression.getOperation().isA(100) && TypeInferenceVisitor.sameVariableName(this.leaf, (ASTNode)leftExpression)) {
            Expression rightExpression = expression.getRightExpression();
            if (rightExpression instanceof ConstantExpression && !rightExpression.getText().equals("null")) {
                this.guessedType = ((ConstantExpression)rightExpression).getType();
            } else if (rightExpression instanceof ConstructorCallExpression) {
                this.guessedType = ClassHelper.make((String)((ConstructorCallExpression)rightExpression).getType().getName());
            } else if (rightExpression instanceof MethodCallExpression) {
                this.guessedType = MethodInference.findCallerType((ASTNode)rightExpression, this.path, this.doc, this.cursorOffset);
            } else if (rightExpression instanceof StaticMethodCallExpression) {
                this.guessedType = MethodInference.findCallerType((ASTNode)rightExpression, this.path, this.doc, this.cursorOffset);
            } else {
                ClassNode cn = expression.getRightExpression().getType();
                if (!cn.equals((Object)"java.lang.Object")) {
                    this.guessedType = cn;
                }
            }
        }
        super.visitBinaryExpression(expression);
    }

    private static boolean sameVariableName(Parameter param, Variable variable) {
        return param.getName().equals(variable.getName());
    }

    private static boolean sameVariableName(ASTNode node1, ASTNode node2) {
        return node1 instanceof VariableExpression && node2 instanceof VariableExpression && ((VariableExpression)node1).getName().equals(((VariableExpression)node2).getName());
    }

    private static boolean sameVariableName(ASTNode node1, FieldNode node2) {
        return node1 instanceof VariableExpression && ((VariableExpression)node1).getName().equals(node2.getName());
    }

    private ClassNode deriveExpressonType(Expression expression) {
        ClassNode derivedExpressionType = null;
        if (expression instanceof ConstantExpression && !expression.getText().equals("null")) {
            derivedExpressionType = ((ConstantExpression)expression).getType();
        } else if (expression instanceof ConstructorCallExpression) {
            derivedExpressionType = ((ConstructorCallExpression)expression).getType();
        } else if (expression instanceof MethodCallExpression) {
            int newOffset = ASTUtils.getOffset(this.doc, expression.getLineNumber(), expression.getColumnNumber());
            AstPath newPath = new AstPath(this.path.root(), newOffset, this.doc);
            derivedExpressionType = MethodInference.findCallerType((ASTNode)expression, newPath, this.doc, newOffset);
        } else if (expression instanceof StaticMethodCallExpression) {
            derivedExpressionType = MethodInference.findCallerType((ASTNode)expression, this.path, this.doc, this.cursorOffset);
        } else if (expression instanceof ListExpression) {
            derivedExpressionType = ((ListExpression)expression).getType();
        } else if (expression instanceof MapExpression) {
            derivedExpressionType = ((MapExpression)expression).getType();
        } else if (expression instanceof RangeExpression) {
            derivedExpressionType = ClassHelper.makeWithoutCaching(Range.class, (boolean)true);
        }
        return derivedExpressionType;
    }
}

