/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.platform;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.api.java.queries.JavadocForBinaryQuery;
import org.netbeans.modules.javafx2.platform.Utils;
import org.netbeans.modules.javafx2.platform.api.JavaFxRuntimeInclusion;
import org.netbeans.spi.java.queries.JavadocForBinaryQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.Parameters;
import org.openide.util.WeakListeners;

public class JavaFXPlatformJavadoc
implements JavadocForBinaryQueryImplementation {
    private static final Logger LOG = Logger.getLogger(JavaFXPlatformJavadoc.class.getName());
    private final ResultCache cache = new ResultCache();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public JavadocForBinaryQuery.Result findJavadoc(@NonNull URL binaryRoot) {
        JavadocForBinaryQuery.Result result;
        File archiveFile;
        long st;
        block9: {
            URL archiveURL;
            block8: {
                block7: {
                    st = System.currentTimeMillis();
                    Parameters.notNull((CharSequence)"binaryRoot", (Object)binaryRoot);
                    archiveURL = FileUtil.getArchiveFile((URL)binaryRoot);
                    if (archiveURL != null) break block7;
                    LOG.log(Level.FINE, "Ignoring {0}, not an archvive.", binaryRoot);
                    JavadocForBinaryQuery.Result result2 = null;
                    {
                        catch (Throwable throwable) {
                            long et = System.currentTimeMillis();
                            LOG.log(Level.FINER, "findJavadoc({0}) took {1}ms.", new Object[]{binaryRoot, et - st});
                            throw throwable;
                        }
                    }
                    long et = System.currentTimeMillis();
                    LOG.log(Level.FINER, "findJavadoc({0}) took {1}ms.", new Object[]{binaryRoot, et - st});
                    return result2;
                }
                if ("file".equals(archiveURL.getProtocol())) break block8;
                LOG.log(Level.FINE, "Ignoring {0}, not a local file.", binaryRoot);
                JavadocForBinaryQuery.Result result3 = null;
                long et = System.currentTimeMillis();
                LOG.log(Level.FINER, "findJavadoc({0}) took {1}ms.", new Object[]{binaryRoot, et - st});
                return result3;
            }
            archiveFile = new File(archiveURL.toURI());
            if (Utils.getJavaFxRuntimeArchiveName().equals(archiveFile.getName())) break block9;
            LOG.log(Level.FINE, "Ignoring {0}, not an JavaFX runtime.", binaryRoot);
            JavadocForBinaryQuery.Result result4 = null;
            long et = System.currentTimeMillis();
            LOG.log(Level.FINER, "findJavadoc({0}) took {1}ms.", new Object[]{binaryRoot, et - st});
            return result4;
        }
        try {
            result = this.cache.getResult(archiveFile);
        }
        catch (URISyntaxException e) {
            Exceptions.printStackTrace((Throwable)e);
            JavadocForBinaryQuery.Result result5 = null;
            long et = System.currentTimeMillis();
            LOG.log(Level.FINER, "findJavadoc({0}) took {1}ms.", new Object[]{binaryRoot, et - st});
            return result5;
        }
        long et = System.currentTimeMillis();
        LOG.log(Level.FINER, "findJavadoc({0}) took {1}ms.", new Object[]{binaryRoot, et - st});
        return result;
    }

    private static final class ResultImpl
    implements JavadocForBinaryQuery.Result,
    PropertyChangeListener {
        private final Collection<? extends JavaPlatform> plaforms;
        private final ChangeSupport support;

        ResultImpl(@NonNull Collection<? extends JavaPlatform> platforms) {
            Parameters.notNull((CharSequence)"platforms", platforms);
            this.plaforms = platforms;
            for (JavaPlatform javaPlatform : this.plaforms) {
                javaPlatform.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)javaPlatform));
            }
            this.support = new ChangeSupport((Object)this);
        }

        public URL[] getRoots() {
            try {
                long st = System.currentTimeMillis();
                LinkedHashSet<URI> collector = new LinkedHashSet<URI>();
                for (JavaPlatform javaPlatform : this.plaforms) {
                    for (URL jdoc : javaPlatform.getJavadocFolders()) {
                        collector.add(jdoc.toURI());
                    }
                }
                URL[] res = new URL[collector.size()];
                boolean bl = false;
                for (URI uri : collector) {
                    res[++var5_8] = uri.toURL();
                }
                long et = System.currentTimeMillis();
                LOG.log(Level.FINER, "getRoots() -> {0} took: {1}ms", new Object[]{collector, et - st});
                return res;
            }
            catch (URISyntaxException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
            catch (MalformedURLException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
            return new URL[0];
        }

        public void addChangeListener(@NonNull ChangeListener l) {
            Parameters.notNull((CharSequence)"l", (Object)l);
            this.support.addChangeListener(l);
        }

        public void removeChangeListener(@NonNull ChangeListener l) {
            Parameters.notNull((CharSequence)"l", (Object)l);
            this.support.removeChangeListener(l);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("javadocFolders".equals(evt.getPropertyName())) {
                this.support.fireChange();
            }
        }
    }

    private static final class ResultCache
    implements PropertyChangeListener {
        private static final JavadocForBinaryQuery.Result UNKNOWN = new JavadocForBinaryQuery.Result(){

            public URL[] getRoots() {
                return new URL[0];
            }

            public void addChangeListener(ChangeListener l) {
            }

            public void removeChangeListener(ChangeListener l) {
            }
        };
        private final Map<File, JavadocForBinaryQuery.Result> results = Collections.synchronizedMap(new HashMap());

        ResultCache() {
            JavaPlatformManager jpm = JavaPlatformManager.getDefault();
            jpm.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)jpm));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CheckForNull
        JavadocForBinaryQuery.Result getResult(@NonNull File file) {
            Parameters.notNull((CharSequence)"file", (Object)file);
            JavadocForBinaryQuery.Result res = this.results.get(file);
            if (res == null) {
                Collection<? extends JavaPlatform> jps = this.findJavaPlatforms(file);
                res = !jps.isEmpty() && !JavaFxRuntimeInclusion.forPlatform(jps.iterator().next()).isIncludedOnClassPath() ? new ResultImpl(jps) : UNKNOWN;
                Map<File, JavadocForBinaryQuery.Result> map = this.results;
                synchronized (map) {
                    JavadocForBinaryQuery.Result tmp = this.results.get(file);
                    if (tmp == null) {
                        this.results.put(file, res);
                    } else {
                        res = tmp;
                    }
                }
            }
            return res == UNKNOWN ? null : res;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("installedPlatforms".equals(evt.getPropertyName())) {
                this.results.clear();
            }
        }

        @NonNull
        private Collection<? extends JavaPlatform> findJavaPlatforms(@NonNull File jfxrt) {
            JavaPlatform[] jps = JavaPlatformManager.getDefault().getPlatforms(null, new Specification("j2se", null));
            ArrayList<JavaPlatform> res = new ArrayList<JavaPlatform>(jps.length);
            FileObject jfxrfFo = FileUtil.toFileObject((File)jfxrt);
            if (jfxrfFo != null) {
                for (JavaPlatform jp : jps) {
                    for (FileObject installFolder : jp.getInstallFolders()) {
                        if (!FileUtil.isParentOf((FileObject)installFolder, (FileObject)jfxrfFo)) continue;
                        res.add(jp);
                    }
                }
            }
            return res;
        }
    }
}

