/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.openjdk.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.java.openjdk.project.JDKProject;
import org.netbeans.modules.java.openjdk.project.ModuleDescription;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.FilteringPathResourceImplementation;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.modules.Places;
import org.openide.util.Exceptions;

public class ClassPathProviderImpl
implements ClassPathProvider {
    private static final Logger LOG = Logger.getLogger(ClassPathProviderImpl.class.getName());
    private static final String[] JDK_CLASSPATH = new String[]{"${outputRoot}/jaxp/dist/lib/classes.jar", "${outputRoot}/corba/dist/lib/classes.jar"};
    private final AtomicBoolean initialScanDone = new AtomicBoolean();
    private final ClassPath bootCP = ClassPath.EMPTY;
    private final ClassPath moduleBootCP = ClassPath.EMPTY;
    private final ClassPath compileCP;
    private final ClassPath moduleCompileCP;
    private final ClassPath sourceCP;
    private final ClassPath testsCompileCP;
    private final ClassPath testsRegCP;
    private final ModuleDescription.ModuleRepository repository;
    private static final String[] TEST_LIBRARIES = new String[]{"testng", "junit_4"};
    private static final boolean REGISTER_TESTS_AS_JAVA = Boolean.getBoolean("jdk.project.ClassPathProviderImpl");
    private static final String TEST_SOURCE = "jdk-project-test-source";

    public ClassPathProviderImpl(JDKProject project, ModuleDescription.ModuleRepository repository) {
        ArrayList<Object> compileElements;
        File fakeJdk = InstalledFileLocator.getDefault().locate("modules/ext/fakeJdkClasses.zip", "org.netbeans.modules.java.openjdk.project", false);
        URL fakeJdkURL = null;
        if (fakeJdk != null) {
            fakeJdkURL = FileUtil.urlForArchiveOrDir((File)fakeJdk);
        }
        if (project.currentModule != null) {
            compileElements = new ArrayList<Object>();
            Collection<String> dependencies = project.moduleRepository.allDependencies(project.currentModule);
            Iterator iterator = dependencies.iterator();
            while (iterator.hasNext()) {
                String dep = (String)iterator.next();
                FileObject depFO = project.moduleRepository.findModuleRoot(dep);
                if (depFO == null) continue;
                try {
                    compileElements.add(ClassPathProviderImpl.projectDir2FakeTarget(depFO));
                }
                catch (MalformedURLException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            if (fakeJdkURL != null) {
                compileElements.add(fakeJdkURL);
            }
            this.compileCP = ClassPathSupport.createClassPath((URL[])compileElements.toArray(new URL[0]));
            ArrayList<FileObject> mp = new ArrayList<FileObject>();
            File fakeMPJars = Places.getCacheSubdirectory((String)"org-netbeans-modules-jdk-project-JDKProject-module-path");
            for (ModuleDescription mod : project.moduleRepository.modules) {
                if (dependencies.contains(mod.name)) continue;
                File fakeJar = new File(fakeMPJars, mod.name + ".jar");
                if (!fakeJar.exists()) {
                    try (JarOutputStream jos = new JarOutputStream(new FileOutputStream(fakeJar));){
                        jos.putNextEntry(new JarEntry("empty"));
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                        continue;
                    }
                }
                mp.add(FileUtil.getArchiveRoot((FileObject)FileUtil.toFileObject((File)fakeJar)));
            }
            this.moduleCompileCP = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{this.compileCP, ClassPathSupport.createClassPath((FileObject[])mp.toArray(new FileObject[0]))});
        } else {
            compileElements = new ArrayList();
            for (String cp : JDK_CLASSPATH) {
                compileElements.add(new JarBaseResourceImpl(cp, project.evaluator()));
            }
            this.compileCP = ClassPathSupport.createClassPath(compileElements);
            this.moduleCompileCP = ClassPath.EMPTY;
        }
        ArrayList<PathResourceImpl> sourceRoots = new ArrayList<PathResourceImpl>();
        ArrayList<PathResourceImpl> testsRegRoots = new ArrayList<PathResourceImpl>();
        for (JDKProject.Root root : project.getRoots()) {
            if (root.kind == JDKProject.RootKind.MAIN_SOURCES) {
                sourceRoots.add(new PathResourceImpl(root));
                continue;
            }
            if (root.kind != JDKProject.RootKind.TEST_SOURCES) continue;
            testsRegRoots.add(new PathResourceImpl(root));
        }
        this.sourceCP = ClassPathSupport.createClassPath(sourceRoots);
        ArrayList<URL> testCompileRoots = new ArrayList<URL>();
        if (project.currentModule != null) {
            for (ModuleDescription mod : project.moduleRepository.modules) {
                FileObject depFO = project.moduleRepository.findModuleRoot(mod.name);
                if (depFO == null) continue;
                try {
                    testCompileRoots.add(ClassPathProviderImpl.projectDir2FakeTarget(depFO));
                }
                catch (MalformedURLException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        } else {
            try {
                testCompileRoots.add(project.getFakeOutput().toURL());
            }
            catch (MalformedURLException ex) {
                LOG.log(Level.FINE, null, ex);
            }
        }
        for (String libraryName : TEST_LIBRARIES) {
            Library library = LibraryManager.getDefault().getLibrary(libraryName);
            if (library == null) continue;
            testCompileRoots.addAll(library.getContent("classpath"));
        }
        if (fakeJdkURL != null) {
            testCompileRoots.add(fakeJdkURL);
        }
        this.testsCompileCP = ClassPathSupport.createClassPath((URL[])testCompileRoots.toArray(new URL[0]));
        this.testsRegCP = ClassPathSupport.createClassPath(testsRegRoots);
        this.repository = repository;
    }

    private static URL projectDir2FakeTarget(FileObject projectDir) throws MalformedURLException {
        return FileUtil.getArchiveRoot((URL)projectDir.toURI().resolve("fake-target.jar").toURL());
    }

    public ClassPath findClassPath(FileObject file, String type) {
        if (this.sourceCP.findOwnerRoot(file) != null) {
            if (!this.repository.isAnyProjectOpened()) {
                return null;
            }
            if ("classpath/boot".equals(type)) {
                return this.bootCP;
            }
            if ("modules/boot".equals(type)) {
                return this.bootCP;
            }
            if ("classpath/compile".equals(type)) {
                return this.compileCP;
            }
            if ("classpath/source".equals(type)) {
                return this.sourceCP;
            }
            if ("modules/compile".equals(type)) {
                return this.moduleCompileCP;
            }
        } else {
            if (file.isFolder()) {
                return null;
            }
            if ("classpath/boot".equals(type) || "modules/boot".equals(type)) {
                if (this.initialScanDone.get()) {
                    return ClassPath.EMPTY;
                }
                return null;
            }
            if ("classpath/compile".equals(type) || "modules/compile".equals(type) || "modules/classpath".equals(type)) {
                return this.testsCompileCP;
            }
        }
        return null;
    }

    public ClassPath getSourceCP() {
        return this.sourceCP;
    }

    public void registerClassPaths() {
        GlobalPathRegistry.getDefault().register("classpath/boot", new ClassPath[]{this.bootCP});
        GlobalPathRegistry.getDefault().register("classpath/compile", new ClassPath[]{this.compileCP});
        GlobalPathRegistry.getDefault().register("classpath/source", new ClassPath[]{this.sourceCP});
        if (REGISTER_TESTS_AS_JAVA) {
            GlobalPathRegistry.getDefault().register("classpath/source", new ClassPath[]{this.testsRegCP});
        }
        GlobalPathRegistry.getDefault().register(TEST_SOURCE, new ClassPath[]{this.testsRegCP});
        try {
            JavaSource js = JavaSource.create((ClasspathInfo)ClasspathInfo.create((ClassPath)ClassPath.EMPTY, (ClassPath)this.testsCompileCP, (ClassPath)ClassPath.EMPTY), (FileObject[])new FileObject[0]);
            if (js != null) {
                js.runWhenScanFinished(cc -> this.initialScanDone.set(true), true);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(ClassPathProviderImpl.class.getName()).log(Level.FINE, null, ex);
        }
    }

    public void unregisterClassPaths() {
        GlobalPathRegistry.getDefault().unregister("classpath/boot", new ClassPath[]{this.bootCP});
        GlobalPathRegistry.getDefault().unregister("classpath/compile", new ClassPath[]{this.compileCP});
        GlobalPathRegistry.getDefault().unregister("classpath/source", new ClassPath[]{this.sourceCP});
        if (REGISTER_TESTS_AS_JAVA) {
            GlobalPathRegistry.getDefault().unregister("classpath/source", new ClassPath[]{this.testsRegCP});
        }
        GlobalPathRegistry.getDefault().unregister(TEST_SOURCE, new ClassPath[]{this.testsRegCP});
    }

    private static final class JarBaseResourceImpl
    implements PathResourceImplementation,
    PropertyChangeListener {
        private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
        private final String jar;
        private final PropertyEvaluator evaluator;
        private URL location;

        public JarBaseResourceImpl(String jar, PropertyEvaluator evaluator) {
            this.jar = jar;
            this.evaluator = evaluator;
        }

        public synchronized URL[] getRoots() {
            if (this.location == null) {
                this.location = FileUtil.urlForArchiveOrDir((File)new File(this.evaluator.evaluate(this.jar)));
            }
            return new URL[]{this.location};
        }

        public ClassPathImplementation getContent() {
            return null;
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.removePropertyChangeListener(listener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            JarBaseResourceImpl jarBaseResourceImpl = this;
            synchronized (jarBaseResourceImpl) {
                this.location = null;
            }
            this.pcs.firePropertyChange("roots", null, null);
        }
    }

    private static final class PathResourceImpl
    implements FilteringPathResourceImplementation,
    ChangeListener {
        private final JDKProject.Root root;
        private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

        public PathResourceImpl(JDKProject.Root root) {
            this.root = root;
            this.root.addChangeListener(this);
        }

        public boolean includes(URL rootURL, String resource) {
            return this.root.excludes == null || !this.root.excludes.matcher(resource).matches();
        }

        public URL[] getRoots() {
            return new URL[]{this.root.getLocation()};
        }

        public ClassPathImplementation getContent() {
            return null;
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.removePropertyChangeListener(listener);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.pcs.firePropertyChange("roots", null, null);
        }
    }
}

