/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.openjdk.jtreg;

import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.openjdk.jtreg.Bundle;
import org.netbeans.modules.java.openjdk.jtreg.Tag;
import org.netbeans.modules.java.openjdk.jtreg.TagParser;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.LazyFixList;
import org.netbeans.spi.editor.hints.Severity;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;
import org.openide.filesystems.FileObject;

public class MissingRefOutputHint {
    public static List<ErrorDescription> computeWarning(HintContext ctx) {
        TagParser.Result tags = TagParser.parseTags(ctx.getInfo());
        ArrayList<ErrorDescription> result = new ArrayList<ErrorDescription>();
        for (Tag tag : tags.getTags()) {
            if (!"compile".equals(tag.getName()) || !tag.getValue().startsWith("/")) continue;
            String firstParam = tag.getValue().split("[\\s]+", 2)[0];
            boolean hasFail = false;
            boolean hasRef = false;
            int pos = tag.getTagEnd();
            for (String opt : firstParam.split("/")) {
                if ("fail".equals(opt)) {
                    hasFail = true;
                } else if (opt.startsWith("ref=")) {
                    hasRef = true;
                    String fileName = opt.substring(4);
                    if (ctx.getInfo().getFileObject().getParent().getFileObject(fileName) == null) {
                        ErrorDescription idealED = org.netbeans.spi.java.hints.ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ctx.getPath(), (String)Bundle.ERR_RefFileMissing(), (Fix[])new Fix[]{new CreateRefFileFixImpl(ctx.getInfo(), ctx.getPath(), fileName).toEditorFix()});
                        result.add(ErrorDescriptionFactory.createErrorDescription((Severity)idealED.getSeverity(), (String)idealED.getDescription(), (LazyFixList)idealED.getFixes(), (FileObject)ctx.getInfo().getFileObject(), (int)(pos + 4), (int)(pos + fileName.length() + 4)));
                    }
                }
                pos += opt.length() + 1;
            }
            if (!hasFail || hasRef) continue;
            ErrorDescription idealED = org.netbeans.spi.java.hints.ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ctx.getPath(), (String)Bundle.ERR_NoRef(), (Fix[])new Fix[]{new AddRefFixImpl(ctx.getInfo(), ctx.getPath(), tag.getTagEnd() + firstParam.length()).toEditorFix()});
            result.add(ErrorDescriptionFactory.createErrorDescription((Severity)idealED.getSeverity(), (String)idealED.getDescription(), (LazyFixList)idealED.getFixes(), (FileObject)ctx.getInfo().getFileObject(), (int)tag.getTagStart(), (int)tag.getTagEnd()));
        }
        return result;
    }

    private static final class CreateRefFileFixImpl
    extends JavaFix {
        private final String fileName;

        public CreateRefFileFixImpl(CompilationInfo info, TreePath tp, String fileName) {
            super(info, tp);
            this.fileName = fileName;
        }

        protected String getText() {
            return Bundle.FIX_CreateRefOutput();
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) throws IOException {
            ctx.getWorkingCopy().getFileObject().getParent().createData(this.fileName);
        }
    }

    private static final class AddRefFixImpl
    extends JavaFix {
        private final int pos;

        public AddRefFixImpl(CompilationInfo info, TreePath tp, int pos) {
            super(info, tp);
            this.pos = pos;
        }

        protected String getText() {
            return Bundle.FIX_AddRefOutput();
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) throws IOException {
            String fileName = ctx.getWorkingCopy().getFileObject().getName() + ".out";
            ctx.getWorkingCopy().rewriteInComment(this.pos, 0, "/ref=" + fileName);
            if (ctx.getWorkingCopy().getFileObject().getParent().getFileObject(fileName) == null) {
                ctx.getWorkingCopy().getFileObject().getParent().createData(fileName);
            }
        }
    }
}

