/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.instrumentation;

import org.netbeans.lib.profiler.classfile.ClassInfo;
import org.netbeans.lib.profiler.instrumentation.ClassRewriter;
import org.netbeans.lib.profiler.instrumentation.JavaClassConstants;

public class SingleMethodScaner
implements JavaClassConstants {
    private static byte[] reusableBytecodes = new byte[100];
    protected ClassInfo clazz;
    protected byte[] bytecodes;
    protected byte[] origMethodInfo;
    protected int bytecodesLength;
    protected int bytecodesStartIdx;
    protected int methodIdx;

    public SingleMethodScaner() {
    }

    public SingleMethodScaner(ClassInfo clazz, int methodIdx) {
        this.setClassAndMethod(clazz, methodIdx);
    }

    public void setClassAndMethod(ClassInfo clazz, int methodIdx) {
        this.clazz = clazz;
        this.methodIdx = methodIdx;
        this.origMethodInfo = clazz.getMethodInfo(methodIdx);
        this.bytecodesStartIdx = clazz.getMethodBytecodeOffsetInMethodInfo(methodIdx);
        this.bytecodesLength = clazz.getMethodBytecodesLength(methodIdx);
        this.initBytecodesArray();
    }

    protected static int getU2(byte[] buf, int pos) {
        return ((buf[pos] & 0xFF) << 8) + (buf[pos + 1] & 0xFF);
    }

    protected static int getU4(byte[] buf, int pos) {
        return ((buf[pos] & 0xFF) << 24) + ((buf[pos + 1] & 0xFF) << 16) + ((buf[pos + 2] & 0xFF) << 8) + (buf[pos + 3] & 0xFF);
    }

    protected static int align(int n) {
        return n + 3 & 0xFFFFFFFC;
    }

    protected int opcodeLength(int bci) {
        int ret;
        int opcode = this.bytecodes[bci] & 0xFF;
        try {
            ret = opc_length[opcode];
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            System.err.println("*** JFluid warning: unknown opcode: " + opcode + " detected at offset " + bci + "in class/method " + this.clazz.getName() + "." + this.clazz.getMethodName(this.methodIdx) + this.clazz.getMethodSignature(this.methodIdx));
            ClassRewriter.saveToDisk(this.clazz.getName(), this.bytecodes);
            return 1;
        }
        if (ret != 0) {
            return ret;
        }
        if (opcode == 196) {
            opcode = this.bytecodes[bci + 1] & 0xFF;
            if (opcode >= 21 && opcode <= 25 || opcode >= 54 && opcode <= 58 || opcode == 169) {
                return 4;
            }
            if (opcode == 132) {
                return 6;
            }
            return 2;
        }
        int pad = SingleMethodScaner.align(bci + 1) - (bci + 1);
        switch (opcode) {
            case 170: {
                int lo = this.getInt(bci + 1 + pad + 4);
                int hi = this.getInt(bci + 1 + pad + 8);
                int n = hi - lo + 1;
                return 1 + pad + 4 * (3 + n);
            }
            case 171: {
                int npairs = this.getInt(bci + 1 + pad + 4);
                return 1 + pad + 4 * (2 + 2 * npairs);
            }
        }
        System.err.println("*** Profiler Engine: error - should not reach here in opcodeLength()");
        return 0;
    }

    protected static void putByte(byte[] buf, int pos, int value) {
        buf[pos] = (byte)(value & 0xFF);
    }

    protected static void putU2(byte[] buf, int pos, int value) {
        buf[pos] = (byte)(value >> 8 & 0xFF);
        buf[pos + 1] = (byte)(value & 0xFF);
    }

    protected static void putU4(byte[] buf, int pos, int value) {
        buf[pos] = (byte)(value >> 24 & 0xFF);
        buf[pos + 1] = (byte)(value >> 16 & 0xFF);
        buf[pos + 2] = (byte)(value >> 8 & 0xFF);
        buf[pos + 3] = (byte)(value & 0xFF);
    }

    protected int getByte(int pos) {
        return this.bytecodes[pos] & 0xFF;
    }

    protected int getInt(int pos) {
        return this.getU4(pos);
    }

    protected short getShort(int pos) {
        return (short)(((this.bytecodes[pos] & 0xFF) << 8) + (this.bytecodes[pos + 1] & 0xFF));
    }

    protected int getU2(int pos) {
        return ((this.bytecodes[pos] & 0xFF) << 8) + (this.bytecodes[pos + 1] & 0xFF);
    }

    protected int getU4(int pos) {
        return ((this.bytecodes[pos] & 0xFF) << 24) + ((this.bytecodes[pos + 1] & 0xFF) << 16) + ((this.bytecodes[pos + 2] & 0xFF) << 8) + (this.bytecodes[pos + 3] & 0xFF);
    }

    protected void initBytecodesArray() {
        if (reusableBytecodes.length < this.bytecodesLength * 8) {
            reusableBytecodes = new byte[this.bytecodesLength * 8];
        }
        System.arraycopy(this.origMethodInfo, this.bytecodesStartIdx, reusableBytecodes, 0, this.bytecodesLength);
        this.bytecodes = reusableBytecodes;
    }

    protected void putInt(int pos, int value) {
        this.putU4(pos, value);
    }

    protected void putShort(int pos, short value) {
        this.bytecodes[pos] = (byte)(value >> 8 & 0xFF);
        this.bytecodes[pos + 1] = (byte)(value & 0xFF);
    }

    protected void putU4(int pos, int value) {
        this.bytecodes[pos] = (byte)(value >> 24 & 0xFF);
        this.bytecodes[pos + 1] = (byte)(value >> 16 & 0xFF);
        this.bytecodes[pos + 2] = (byte)(value >> 8 & 0xFF);
        this.bytecodes[pos + 3] = (byte)(value & 0xFF);
    }
}

