/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.netbeans.lib.profiler.heap.CacheDirectory;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.HprofHeap;

public class HeapFactory {
    public static Heap createHeap(File heapDump) throws FileNotFoundException, IOException {
        return HeapFactory.createHeap(heapDump, 0);
    }

    public static Heap createHeap(File heapDump, int segment) throws FileNotFoundException, IOException {
        File savedDump;
        CacheDirectory cacheDir = CacheDirectory.getHeapDumpCacheDirectory(heapDump);
        if (!cacheDir.isTemporary() && (savedDump = cacheDir.getHeapDumpAuxFile()).exists() && savedDump.isFile() && savedDump.canRead()) {
            try {
                return HeapFactory.loadHeap(cacheDir);
            }
            catch (IOException ex) {
                System.err.println("Loading heap dump " + heapDump + " from cache failed.");
                ex.printStackTrace(System.err);
            }
        }
        return new HprofHeap(heapDump, segment, cacheDir);
    }

    static Heap loadHeap(CacheDirectory cacheDir) throws FileNotFoundException, IOException {
        File savedDump = cacheDir.getHeapDumpAuxFile();
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(savedDump), 65536);
        DataInputStream dis = new DataInputStream(is);
        HprofHeap heap = new HprofHeap(dis, cacheDir);
        dis.close();
        return heap;
    }
}

