/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.completion;

import javax.swing.ImageIcon;
import javax.swing.text.JTextComponent;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.xml.lexer.XMLTokenId;
import org.netbeans.modules.xml.axi.AXIComponent;
import org.netbeans.modules.xml.schema.completion.CompletionPaintComponent;
import org.netbeans.modules.xml.schema.completion.CompletionResultItem;
import org.netbeans.modules.xml.schema.completion.spi.CompletionContext;

public class ValueResultItem
extends CompletionResultItem {
    public ValueResultItem(AXIComponent forComponent, String value, CompletionContext context) {
        super(forComponent, context);
        this.itemText = value;
        this.icon = new ImageIcon(CompletionResultItem.class.getResource("/org/netbeans/modules/xml/schema/completion/resources/value.png"));
    }

    @Override
    protected int removeTextLength(JTextComponent component, int offset, int removeLength) {
        TokenSequence s = this.createTokenSequence(component);
        s.move(offset);
        if (!s.moveNext()) {
            return super.removeTextLength(component, offset, removeLength);
        }
        TokenId id = s.token().id();
        if (id == XMLTokenId.VALUE) {
            XMLTokenId tid;
            int off = s.offset();
            String t = s.token().text().toString();
            char c = t.charAt(t.length() - 1);
            int len = t.length();
            boolean error = false;
            if (s.moveNext() && (tid = (XMLTokenId)s.token().id()) != XMLTokenId.ARGUMENT && tid != XMLTokenId.TAG) {
                error = true;
                for (int i = 0; i < len; ++i) {
                    if (!Character.isWhitespace(t.charAt(i))) continue;
                    len = i;
                    break;
                }
            }
            int l = off + t.length() - offset;
            if (t.isEmpty()) {
                return 0;
            }
            if (c == '\'' || c == '\"') {
                return t.length() == -1 ? 0 : l - 1;
            }
            return 0;
        }
        return super.removeTextLength(component, offset, removeLength);
    }

    @Override
    public String getReplacementText() {
        return this.itemText;
    }

    @Override
    public String getDisplayText() {
        return this.getItemText();
    }

    @Override
    public CompletionPaintComponent getPaintComponent() {
        if (this.component == null) {
            this.component = new CompletionPaintComponent.ValuePaintComponent(this);
        }
        return this.component;
    }

    @Override
    public int getCaretPosition() {
        return this.getReplacementText().length();
    }
}

