/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.composer.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.modules.php.composer.output.model.ComposerPackage;
import org.netbeans.modules.php.composer.ui.Bundle;
import org.netbeans.modules.php.composer.ui.DependenciesPanel;
import org.netbeans.modules.php.composer.ui.options.ComposerOptionsPanelController;
import org.openide.awt.Mnemonics;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public class PhpModuleExtenderPanel
extends JPanel {
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private final List<ComposerPackage> selectedPackages = Collections.synchronizedList(new ArrayList());
    private final DependenciesPanel dependenciesPanel;
    private final SelectedPackagesModel selectedPackagesModel;
    private JButton deselectButton;
    private JPanel holderPanel1;
    private JPanel holderPanel2;
    private JLabel optionsLabel;
    private JPanel searchPanel;
    private JButton selectButton;
    private JLabel selectedLabel;
    private JList<ComposerPackage> selectedPackagesList;
    private JScrollPane selectedPackagesScrollPane;

    public PhpModuleExtenderPanel() {
        assert (EventQueue.isDispatchThread());
        this.dependenciesPanel = DependenciesPanel.create();
        this.selectedPackagesModel = new SelectedPackagesModel(this.selectedPackages);
        this.initComponents();
        this.init();
    }

    private void init() {
        this.searchPanel.add((Component)this.dependenciesPanel, "Center");
        this.selectedPackagesList.setModel(this.selectedPackagesModel);
        this.selectedPackagesList.setCellRenderer(new ComposerPackageListCellRenderer());
        this.enableSelectButton();
        this.enableDeselectButton();
        this.dependenciesPanel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PhpModuleExtenderPanel.this.enableSelectButton();
            }
        });
        this.selectedPackagesModel.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                this.processChange();
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                this.processChange();
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                this.processChange();
            }

            private void processChange() {
                PhpModuleExtenderPanel.this.enableSelectButton();
                PhpModuleExtenderPanel.this.fireChange();
            }
        });
        this.selectedPackagesList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                PhpModuleExtenderPanel.this.enableDeselectButton();
            }
        });
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    public List<ComposerPackage> getSelectedPackages() {
        return new ArrayList<ComposerPackage>(this.selectedPackages);
    }

    void enableSelectButton() {
        this.selectButton.setEnabled(this.dependenciesPanel.getComposerPackage() != null);
    }

    void enableDeselectButton() {
        this.deselectButton.setEnabled(!this.selectedPackagesList.getSelectedValuesList().isEmpty());
    }

    void fireChange() {
        this.changeSupport.fireChange();
    }

    private void initComponents() {
        this.searchPanel = new JPanel();
        this.selectButton = new JButton();
        this.deselectButton = new JButton();
        this.selectedLabel = new JLabel();
        this.optionsLabel = new JLabel();
        this.selectedPackagesScrollPane = new JScrollPane();
        this.selectedPackagesList = new JList();
        this.holderPanel1 = new JPanel();
        this.holderPanel2 = new JPanel();
        this.searchPanel.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.selectButton, (String)">");
        this.selectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PhpModuleExtenderPanel.this.selectButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.deselectButton, (String)"<");
        this.deselectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PhpModuleExtenderPanel.this.deselectButtonActionPerformed(evt);
            }
        });
        this.selectedLabel.setLabelFor(this.selectedPackagesList);
        Mnemonics.setLocalizedText((JLabel)this.selectedLabel, (String)NbBundle.getMessage(PhpModuleExtenderPanel.class, (String)"PhpModuleExtenderPanel.selectedLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.optionsLabel, (String)NbBundle.getMessage(PhpModuleExtenderPanel.class, (String)"PhpModuleExtenderPanel.optionsLabel.text"));
        this.optionsLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                PhpModuleExtenderPanel.this.optionsLabelMouseEntered(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                PhpModuleExtenderPanel.this.optionsLabelMousePressed(evt);
            }
        });
        this.selectedPackagesScrollPane.setViewportView(this.selectedPackagesList);
        GroupLayout holderPanel1Layout = new GroupLayout(this.holderPanel1);
        this.holderPanel1.setLayout(holderPanel1Layout);
        holderPanel1Layout.setHorizontalGroup(holderPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 44, Short.MAX_VALUE));
        holderPanel1Layout.setVerticalGroup(holderPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        GroupLayout holderPanel2Layout = new GroupLayout(this.holderPanel2);
        this.holderPanel2.setLayout(holderPanel2Layout);
        holderPanel2Layout.setHorizontalGroup(holderPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 44, Short.MAX_VALUE));
        holderPanel2Layout.setVerticalGroup(holderPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.searchPanel, -1, 245, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.holderPanel1, -2, -1, -2).addComponent(this.selectButton).addComponent(this.holderPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.deselectButton, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.selectedPackagesScrollPane, -1, 245, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.selectedLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.optionsLabel, -2, -1, -2)))));
        layout.linkSize(0, this.deselectButton, this.holderPanel1, this.holderPanel2, this.selectButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.searchPanel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.holderPanel1, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.selectButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.deselectButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.holderPanel2, -1, -1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.optionsLabel, -2, -1, -2).addComponent(this.selectedLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.selectedPackagesScrollPane, -1, 303, Short.MAX_VALUE)));
    }

    private void optionsLabelMouseEntered(MouseEvent evt) {
        evt.getComponent().setCursor(Cursor.getPredefinedCursor(12));
    }

    private void optionsLabelMousePressed(MouseEvent evt) {
        OptionsDisplayer.getDefault().open(ComposerOptionsPanelController.getOptionsPath());
    }

    private void selectButtonActionPerformed(ActionEvent evt) {
        ComposerPackage composerPackage = this.dependenciesPanel.getComposerPackage();
        assert (composerPackage != null);
        if (new HashSet<ComposerPackage>(this.selectedPackages).add(composerPackage)) {
            this.selectedPackages.add(composerPackage);
            this.selectedPackagesModel.fireContentsChanged();
        }
    }

    private void deselectButtonActionPerformed(ActionEvent evt) {
        List<ComposerPackage> packages = this.selectedPackagesList.getSelectedValuesList();
        assert (!packages.isEmpty());
        this.selectedPackages.removeAll(packages);
        this.selectedPackagesModel.fireContentsChanged();
    }

    private static final class ComposerPackageListCellRenderer
    implements ListCellRenderer<ComposerPackage> {
        private final ListCellRenderer<Object> defaultRenderer = new DefaultListCellRenderer();

        private ComposerPackageListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends ComposerPackage> list, ComposerPackage value, int index, boolean isSelected, boolean cellHasFocus) {
            String label = Bundle.ComposerPackageListCellRenderer_label(value.getName(), value.getVersion());
            return this.defaultRenderer.getListCellRendererComponent(list, label, index, isSelected, cellHasFocus);
        }
    }

    private static final class SelectedPackagesModel
    extends AbstractListModel<ComposerPackage> {
        private final List<ComposerPackage> selectedPackages;

        public SelectedPackagesModel(List<ComposerPackage> selectedPackages) {
            assert (EventQueue.isDispatchThread());
            this.selectedPackages = selectedPackages;
        }

        @Override
        public int getSize() {
            assert (EventQueue.isDispatchThread());
            return this.selectedPackages.size();
        }

        @Override
        public ComposerPackage getElementAt(int index) {
            assert (EventQueue.isDispatchThread());
            try {
                return this.selectedPackages.get(index);
            }
            catch (IndexOutOfBoundsException ex) {
                return null;
            }
        }

        void fireContentsChanged() {
            assert (EventQueue.isDispatchThread());
            this.fireContentsChanged(0, 0, this.selectedPackages.size());
        }
    }
}

