/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.tooling.admin;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.netbeans.modules.payara.tooling.PayaraIdeException;
import org.netbeans.modules.payara.tooling.admin.Command;
import org.netbeans.modules.payara.tooling.admin.ResultString;
import org.netbeans.modules.payara.tooling.admin.RunnerHttpClass;
import org.netbeans.modules.payara.tooling.admin.RunnerHttpRestartDAS;
import org.netbeans.modules.payara.tooling.admin.RunnerRestClass;
import org.netbeans.modules.payara.tooling.admin.ServerAdmin;
import org.netbeans.modules.payara.tooling.data.PayaraServer;

@RunnerHttpClass(runner=RunnerHttpRestartDAS.class)
@RunnerRestClass(command="restart")
public class CommandRestartDAS
extends Command {
    private static final String COMMAND = "restart-domain";
    private static final String ERROR_MESSAGE = "DAS restart failed.";
    final boolean debug;

    public static ResultString restartDAS(PayaraServer server, boolean debug) throws PayaraIdeException {
        CommandRestartDAS command = new CommandRestartDAS(debug);
        Future future = ServerAdmin.exec(server, command);
        try {
            return (ResultString)future.get();
        }
        catch (InterruptedException | CancellationException | ExecutionException ie) {
            throw new PayaraIdeException(ERROR_MESSAGE, ie);
        }
    }

    public CommandRestartDAS(boolean debug) {
        super(COMMAND);
        this.debug = debug;
    }
}

