/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee.ui.customizer;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import org.netbeans.modules.maven.j2ee.ui.customizer.Bundle;

public final class CheckBoxUpdater
implements ItemListener {
    private final Store store;
    private final Verify verifier;
    private final JCheckBox checkBox;
    private final boolean defaultValue;

    public static CheckBoxUpdater create(JCheckBox checkBox, boolean defaultValue, Store store) {
        return CheckBoxUpdater.create(checkBox, defaultValue, store, null);
    }

    public static CheckBoxUpdater create(JCheckBox checkBox, boolean defaultValue, Store store, Verify verifier) {
        CheckBoxUpdater instance = new CheckBoxUpdater(checkBox, defaultValue, store, verifier);
        instance.checkBox.addItemListener(instance);
        return instance;
    }

    private CheckBoxUpdater(JCheckBox checkBox, boolean defaultValue, Store store, Verify verifier) {
        assert (checkBox != null);
        assert (store != null);
        this.checkBox = checkBox;
        this.checkBox.setSelected(defaultValue);
        this.defaultValue = defaultValue;
        this.store = store;
        this.verifier = verifier;
        this.setValue(defaultValue);
    }

    public void storeValue() {
        boolean currentValue = this.checkBox.isSelected();
        if (currentValue != this.defaultValue) {
            this.store.storeValue(currentValue);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (1 == e.getStateChange() || 2 == e.getStateChange()) {
            boolean isSelected = this.checkBox.isSelected();
            if (this.verifier != null) {
                if (this.verifier.verifyValue(isSelected)) {
                    this.setValue(isSelected);
                }
            } else {
                this.setValue(isSelected);
            }
        }
    }

    private void setValue(boolean value) {
        ItemListener[] itemListeners;
        for (ItemListener listener : itemListeners = this.checkBox.getItemListeners()) {
            this.checkBox.removeItemListener(listener);
        }
        if (this.defaultValue == value) {
            this.checkBox.setFont(this.checkBox.getFont().deriveFont(0));
            this.checkBox.setToolTipText(null);
        } else {
            this.checkBox.setFont(this.checkBox.getFont().deriveFont(1));
            this.checkBox.setToolTipText(Bundle.MSG_CheckBox_Value_Changed());
        }
        this.checkBox.setSelected(value);
        for (ItemListener listener : itemListeners) {
            this.checkBox.addItemListener(listener);
        }
    }

    public static interface Verify {
        public boolean verifyValue(boolean var1);
    }

    public static interface Store {
        public void storeValue(boolean var1);
    }
}

