/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ddloaders.multiview.webservice;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.glassfish.eecommon.api.config.GlassfishConfiguration;
import org.netbeans.modules.j2ee.dd.api.common.CommonDDBean;
import org.netbeans.modules.j2ee.dd.api.webservices.PortComponent;
import org.netbeans.modules.j2ee.dd.api.webservices.ServiceImplBean;
import org.netbeans.modules.j2ee.dd.api.webservices.WebserviceDescription;
import org.netbeans.modules.j2ee.dd.api.webservices.Webservices;
import org.netbeans.modules.j2ee.dd.api.webservices.WebservicesMetadata;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelException;
import org.netbeans.modules.j2ee.sun.ddloaders.Utils;
import org.netbeans.modules.j2ee.sun.ddloaders.multiview.common.CommonBeanReader;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;

public class PortComponentMetadataReader
extends CommonBeanReader {
    private String parentName;

    public PortComponentMetadataReader(String parentName) {
        super("PortComponent");
        this.parentName = parentName != null && parentName.startsWith("WSServlet_") ? parentName.substring(10) : parentName;
    }

    @Override
    protected CommonDDBean normalizeParent(CommonDDBean parent) {
        if (this.parentName != null && parent instanceof Webservices) {
            parent = this.findWebServiceDescByName((Webservices)parent, this.parentName);
        }
        return parent;
    }

    private CommonDDBean findWebServiceDescByName(Webservices webservices, String parentName) {
        return this.findWebServiceDescByName(webservices.getWebserviceDescription(), parentName);
    }

    private CommonDDBean findWebServiceDescByName(WebserviceDescription[] descs, String wsDescName) {
        WebserviceDescription match = null;
        if (descs != null) {
            for (WebserviceDescription ws : descs) {
                if (!wsDescName.equals(ws.getWebserviceDescriptionName())) continue;
                match = ws;
                break;
            }
        }
        return match;
    }

    @Override
    public Map<String, Object> readAnnotations(DataObject dObj) {
        Map<String, Object> result = null;
        try {
            J2eeModule module;
            File key = FileUtil.toFile((FileObject)dObj.getPrimaryFile());
            GlassfishConfiguration dc = GlassfishConfiguration.getConfiguration((File)key);
            if (dc != null && (module = dc.getJ2eeModule()) != null && (J2eeModule.Type.WAR.equals(module.getType()) || J2eeModule.Type.EJB.equals(module.getType()))) {
                result = this.readWebservicesMetadata((MetadataModel<WebservicesMetadata>)module.getMetadataModel(WebservicesMetadata.class));
            }
        }
        catch (MetadataModelException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        return result;
    }

    @Override
    public Map<String, Object> genProperties(CommonDDBean[] beans) {
        HashMap<String, HashMap<String, Object>> result = null;
        if (beans instanceof PortComponent[]) {
            PortComponent[] ports;
            for (PortComponent port : ports = (PortComponent[])beans) {
                String portName = port.getPortComponentName();
                if (!Utils.notEmpty(portName)) continue;
                if (result == null) {
                    result = new HashMap<String, HashMap<String, Object>>();
                }
                HashMap<String, Object> portMap = new HashMap<String, Object>();
                result.put(portName, portMap);
                portMap.put("Name", portName);
                this.addMapString(portMap, "EndpointInterface", port.getServiceEndpointInterface());
                ServiceImplBean serviceBean = port.getServiceImplBean();
                if (serviceBean == null) continue;
                this.addMapString(portMap, "ServletLink", serviceBean.getServletLink());
                this.addMapString(portMap, "EjbLink", serviceBean.getEjbLink());
            }
        }
        return result;
    }
}

