/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.html2md.converter;

import com.vladsch.flexmark.html2md.converter.HtmlNodeConverterContext;
import com.vladsch.flexmark.util.format.MarkdownWriterBase;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;

public class HtmlMarkdownWriter
extends MarkdownWriterBase<HtmlMarkdownWriter, Node, HtmlNodeConverterContext> {
    public HtmlMarkdownWriter() {
        this(0);
    }

    public HtmlMarkdownWriter(int formatOptions) {
        super(formatOptions);
    }

    public boolean isLastBlockQuoteChild() {
        Node node = ((HtmlNodeConverterContext)this.context).getCurrentNode();
        if (node instanceof Element) {
            Element parent;
            Element element = (Element)node;
            while (element.nextElementSibling() == null && (parent = element.parent()) != null) {
                if (parent.nodeName().toLowerCase().equals("blockquote")) {
                    return true;
                }
                element = parent;
            }
        }
        return false;
    }

    public HtmlMarkdownWriter tailBlankLine(int count) {
        if (this.isLastBlockQuoteChild()) {
            CharSequence prefix = this.getPrefix();
            int pos = prefix.toString().lastIndexOf(62);
            if (pos != -1) {
                this.setPrefix(prefix.subSequence(0, pos));
            } else {
                this.setPrefix("");
            }
            this.blankLine(count);
            this.setPrefix(prefix, false);
        } else {
            this.blankLine(count);
        }
        return this;
    }
}

