/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.modules.java.source.parsing.ClasspathInfoProvider;
import org.netbeans.modules.javafx2.editor.completion.impl.Completer;
import org.netbeans.modules.javafx2.editor.completion.impl.CompletionContext;
import org.netbeans.modules.javafx2.editor.completion.model.FxmlParserResult;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.openide.util.Exceptions;

public class FXMLCompletion2
implements CompletionProvider {
    public CompletionTask createTask(int queryType, JTextComponent component) {
        if (component == null) {
            return null;
        }
        return new AsyncCompletionTask((AsyncCompletionQuery)new Q(component, queryType), component);
    }

    public int getAutoQueryTypes(JTextComponent component, String typedText) {
        return 0;
    }

    public static List<CompletionItem> testQuery(Source s, Document doc, int queryType, int caretOffset) throws ParseException {
        Q q = new Q(null, queryType);
        ClasspathInfo cpInfo = ClasspathInfo.create((Document)doc);
        Q.Task t = q.createTask(cpInfo, null, null, doc, caretOffset, queryType);
        ParserManager.parse(Collections.singleton(s), (UserTask)t);
        return q.items;
    }

    public static class Q
    extends AsyncCompletionQuery {
        private JTextComponent component;
        private int queryType;
        private List<CompletionItem> items = Collections.emptyList();
        private boolean additionalItems;

        public Q(JTextComponent component, int queryType) {
            this.component = component;
            this.queryType = queryType;
        }

        private Task createTask(ClasspathInfo cpInfo, JTextComponent component, CompletionResultSet rs, Document doc, int caretOffset, int qT) {
            return new Task(cpInfo, component, rs, doc, caretOffset, qT);
        }

        public void query(CompletionResultSet resultSet, Document doc, int caretOffset) {
            try {
                ClasspathInfo cpInfo = ClasspathInfo.create((Document)doc);
                ParserManager.parse(Collections.singleton(Source.create((Document)doc)), (UserTask)this.createTask(cpInfo, this.component, resultSet, doc, caretOffset, this.queryType));
                resultSet.setHasAdditionalItems(this.additionalItems);
                resultSet.addAllItems(this.items);
                resultSet.finish();
            }
            catch (ParseException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        public List<CompletionItem> getItems() {
            return this.items;
        }

        private class Task
        extends UserTask
        implements ClasspathInfoProvider {
            private CompletionResultSet resultSet;
            private Document doc;
            private int caretOffset;
            private JTextComponent component;
            private ClasspathInfo cpInfo;
            private int queryType;
            private boolean fxmlParsing = true;
            private CompletionContext ctx;
            private CompilationController cc;
            private FxmlParserResult fxmlResult;

            public Task(ClasspathInfo cpInfo, JTextComponent component, CompletionResultSet resultSet, Document doc, int caretOffset, int queryType) {
                this.resultSet = resultSet;
                this.doc = doc;
                this.caretOffset = caretOffset;
                this.component = component;
                this.cpInfo = cpInfo;
                this.queryType = queryType;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(ResultIterator resultIterator) throws Exception {
                if (this.fxmlParsing) {
                    Parser.Result result = resultIterator.getParserResult(this.caretOffset);
                    this.fxmlResult = FxmlParserResult.get(result);
                    if (this.fxmlResult == null) {
                        return;
                    }
                    this.fxmlParsing = false;
                    ParserManager.parse((String)"text/x-java", (UserTask)this);
                    return;
                }
                Parser.Result result = resultIterator.getParserResult();
                this.cc = CompilationController.get((Parser.Result)result);
                this.cc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                this.ctx = new CompletionContext(this.doc, this.caretOffset, this.queryType);
                if (this.doc instanceof AbstractDocument) {
                    ((AbstractDocument)this.doc).readLock();
                }
                try {
                    TokenHierarchy th = TokenHierarchy.get((Document)this.doc);
                    this.ctx.init(th, (CompilationInfo)this.cc, this.fxmlResult);
                }
                finally {
                    if (this.doc instanceof AbstractDocument) {
                        ((AbstractDocument)this.doc).readUnlock();
                    }
                }
                Q.this.items = new ArrayList();
                Collection completers = MimeLookup.getLookup((String)"text/x-fxml+xml").lookupAll(Completer.Factory.class);
                for (Completer.Factory f : completers) {
                    List<? extends CompletionItem> newItems;
                    Completer c = f.createCompleter(this.ctx);
                    if (c == null || (newItems = c.complete()) == null) continue;
                    Q.this.items.addAll(newItems);
                    Q.this.additionalItems = Q.this.additionalItems | c.hasMoreItems();
                }
            }

            public ClasspathInfo getClasspathInfo() {
                return this.cpInfo;
            }
        }
    }
}

