/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.actions;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.netbeans.modules.html.editor.lib.api.elements.Attribute;
import org.netbeans.modules.web.jsfapi.api.Library;

public class ImportData {
    public volatile boolean shouldShowNamespacesPanel;
    public volatile boolean isJsf22;
    private final List<DataItem> dataItems = new ArrayList<DataItem>();
    private final List<DataItem> dataItemsToReplace = new ArrayList<DataItem>();
    private final List<Attribute> dataToRemove = new ArrayList<Attribute>();

    public void add(DataItem item) {
        this.dataItems.add(item);
    }

    public void addToReplace(DataItem item) {
        this.dataItemsToReplace.add(item);
    }

    public void addToRemove(Attribute item) {
        this.dataToRemove.add(item);
    }

    public List<DataItem> getItems() {
        return new ArrayList<DataItem>(this.dataItems);
    }

    public List<DataItem> getItemsToReplace() {
        return new ArrayList<DataItem>(this.dataItemsToReplace);
    }

    public List<Attribute> getItemsToRemove() {
        return new ArrayList<Attribute>(this.dataToRemove);
    }

    public List<VariantItem> getDefaultVariants() {
        ArrayList<VariantItem> result = new ArrayList<VariantItem>();
        for (DataItem dataItem : this.dataItems) {
            result.add(dataItem.getDefaultVariant());
        }
        return result;
    }

    public static class VariantItem {
        private final String prefix;
        private final String namespace;
        private final Library library;

        public VariantItem(String prefix, String namespace, Library library) {
            this.prefix = prefix;
            this.namespace = namespace;
            this.library = library;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public Library getLibrary() {
            return this.library;
        }

        public String toString() {
            return this.getNamespace();
        }

        public int hashCode() {
            int hash = 5;
            hash = 67 * hash + Objects.hashCode(this.prefix);
            hash = 67 * hash + Objects.hashCode(this.namespace);
            hash = 67 * hash + Objects.hashCode(this.library);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            VariantItem other = (VariantItem)obj;
            if (!Objects.equals(this.prefix, other.prefix)) {
                return false;
            }
            if (!Objects.equals(this.namespace, other.namespace)) {
                return false;
            }
            return Objects.equals(this.library, other.library);
        }
    }

    public static class DataItem {
        private final String prefix;
        private final List<VariantItem> variants;
        private final VariantItem defaultVariant;

        public DataItem(String prefix, List<VariantItem> variants, VariantItem defaultVariant) {
            this.prefix = prefix;
            this.variants = variants;
            this.defaultVariant = defaultVariant;
        }

        public String getTypeName() {
            return this.prefix;
        }

        public List<VariantItem> getVariants() {
            return new ArrayList<VariantItem>(this.variants);
        }

        public VariantItem getDefaultVariant() {
            return this.defaultVariant;
        }

        public int hashCode() {
            int hash = 5;
            hash = 97 * hash + Objects.hashCode(this.prefix);
            hash = 97 * hash + Objects.hashCode(this.variants);
            hash = 97 * hash + Objects.hashCode(this.defaultVariant);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DataItem other = (DataItem)obj;
            if (!Objects.equals(this.prefix, other.prefix)) {
                return false;
            }
            if (!Objects.equals(this.variants, other.variants)) {
                return false;
            }
            return Objects.equals(this.defaultVariant, other.defaultVariant);
        }
    }
}

