/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.client;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.VariableTree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.Comment;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.websvc.rest.client.ClientGenerationStrategy;
import org.netbeans.modules.websvc.rest.client.ClientJavaSourceHelper;
import org.netbeans.modules.websvc.rest.client.HttpParams;
import org.netbeans.modules.websvc.rest.client.Security;
import org.netbeans.modules.websvc.rest.client.Wadl2JavaHelper;
import org.netbeans.modules.websvc.rest.model.api.HttpMethod;
import org.netbeans.modules.websvc.rest.support.JavaSourceHelper;
import org.netbeans.modules.websvc.saas.model.WadlSaasMethod;
import org.netbeans.modules.websvc.saas.model.oauth.Metadata;
import org.openide.nodes.Node;

class JaxRsGenerationStrategy
extends ClientGenerationStrategy {
    JaxRsGenerationStrategy() {
    }

    @Override
    protected void buildQueryFormParams(StringBuilder queryString) {
        queryString.append(";\n javax.ws.rs.core.Form form =");
        queryString.append("getQueryOrFormParams(queryParamNames, queryParamValues);\n");
        queryString.append("javax.ws.rs.core.MultivaluedMap<String,String> map = form.asMap();\n");
        queryString.append("for(java.util.Map.Entry<String,java.util.List<String>> entry: ");
        queryString.append("map.entrySet()){\n");
        queryString.append("java.util.List<String> list = entry.getValue();\n");
        queryString.append("String[] values = list.toArray(new String[list.size()]);\n");
        queryString.append("webTarget = webTarget.queryParam(entry.getKey(),(Object[])values);\n");
        queryString.append("}");
    }

    @Override
    protected void buildQParams(StringBuilder queryString) {
        queryString.append("javax.ws.rs.core.MultivaluedMap<String,String> mapOptionalParams = ");
        queryString.append("getQParams(optionalQueryParams);\n");
        queryString.append("for(java.util.Map.Entry<String,java.util.List<String>> entry: ");
        queryString.append("mapOptionalParams.entrySet()){\n");
        queryString.append("java.util.List<String> list = entry.getValue();\n");
        queryString.append("String[] values = list.toArray(new String[list.size()]);\n");
        queryString.append("webTarget = webTarget.queryParam(entry.getKey(),(Object[])values);\n");
        queryString.append("}");
    }

    @Override
    ClassTree generateFields(TreeMaker maker, WorkingCopy copy, ClassTree classTree, String resourceURI, Security security) {
        ModifiersTree fieldModif = maker.Modifiers(Collections.singleton(Modifier.PRIVATE));
        ExpressionTree typeTree = JavaSourceHelper.createTypeTree(copy, "javax.ws.rs.client.WebTarget");
        VariableTree fieldTree = maker.Variable(fieldModif, (CharSequence)"webTarget", (Tree)typeTree, null);
        ClassTree modifiedClass = maker.addClassMember(classTree, (Tree)fieldTree);
        fieldModif = maker.Modifiers(Collections.singleton(Modifier.PRIVATE));
        typeTree = JavaSourceHelper.createTypeTree(copy, "javax.ws.rs.client.Client");
        fieldTree = maker.Variable(fieldModif, (CharSequence)"client", (Tree)typeTree, null);
        modifiedClass = maker.addClassMember(modifiedClass, (Tree)fieldTree);
        HashSet<Modifier> modifiersSet = new HashSet<Modifier>();
        modifiersSet.add(Modifier.PRIVATE);
        modifiersSet.add(Modifier.STATIC);
        modifiersSet.add(Modifier.FINAL);
        fieldModif = maker.Modifiers(modifiersSet);
        typeTree = maker.Identifier((CharSequence)"String");
        String baseUri = resourceURI;
        if (security.isSSL() && resourceURI.startsWith("http:")) {
            baseUri = "https:" + resourceURI.substring(5);
        }
        fieldTree = maker.Variable(fieldModif, (CharSequence)"BASE_URI", (Tree)typeTree, (ExpressionTree)maker.Literal((Object)baseUri));
        modifiedClass = maker.addClassMember(modifiedClass, (Tree)fieldTree);
        return modifiedClass;
    }

    @Override
    boolean requiresJersey(Node context, Security security) {
        return security.isSSL() || Security.Authentication.BASIC.equals((Object)security.getAuthentication());
    }

    @Override
    MethodTree generateConstructor(TreeMaker maker, WorkingCopy copy, ClassTree classTree, ClientJavaSourceHelper.PathFormat pf, Security security) {
        ModifiersTree methodModifier = maker.Modifiers(Collections.singleton(Modifier.PUBLIC));
        boolean isSubresource = pf.getArguments().length > 0;
        ArrayList<VariableTree> paramList = new ArrayList<VariableTree>();
        if (isSubresource) {
            for (String arg : pf.getArguments()) {
                IdentifierTree argTypeTree = maker.Identifier((CharSequence)"String");
                ModifiersTree fieldModifier = maker.Modifiers(Collections.emptySet());
                VariableTree argFieldTree = maker.Variable(fieldModifier, (CharSequence)arg, (Tree)argTypeTree, null);
                paramList.add(argFieldTree);
            }
        }
        String resURI = null;
        String subresourceExpr = "";
        if (isSubresource) {
            subresourceExpr = "    String resourcePath = " + this.getPathExpression(pf) + ";";
            resURI = "resourcePath";
        } else {
            resURI = this.getPathExpression(pf);
        }
        String clientCreation = "   client = javax.ws.rs.client.ClientBuilder.newClient();";
        if (security.isSSL()) {
            clientCreation = "client = javax.ws.rs.client.ClientBuilder.newBuilder().sslContext(getSSLContext()).build();";
        }
        String body = "{" + clientCreation + subresourceExpr + ("\"\"".equals(resURI) ? "   webTarget = client.target(BASE_URI);" : "   webTarget = client.target(BASE_URI).path(" + resURI + ");") + "}";
        return maker.Constructor(methodModifier, Collections.emptyList(), paramList, Collections.emptyList(), body);
    }

    @Override
    MethodTree generateSubresourceMethod(TreeMaker maker, WorkingCopy copy, ClassTree classTree, ClientJavaSourceHelper.PathFormat pf) {
        String body = "{   String resourcePath = " + this.getPathExpression(pf) + ";   webTarget = client.target(BASE_URI).path(resourcePath);}";
        ModifiersTree methodModifier = maker.Modifiers(Collections.singleton(Modifier.PUBLIC));
        ArrayList<VariableTree> paramList = new ArrayList<VariableTree>();
        for (String arg : pf.getArguments()) {
            IdentifierTree argTypeTree = maker.Identifier((CharSequence)"String");
            ModifiersTree fieldModifier = maker.Modifiers(Collections.emptySet());
            VariableTree argFieldTree = maker.Variable(fieldModifier, (CharSequence)arg, (Tree)argTypeTree, null);
            paramList.add(argFieldTree);
        }
        return maker.Method(methodModifier, (CharSequence)"setResourcePath", (Tree)JavaSourceHelper.createTypeTree(copy, "void"), Collections.emptyList(), paramList, Collections.emptyList(), body, null);
    }

    @Override
    MethodTree generateClose(TreeMaker maker, WorkingCopy copy) {
        ModifiersTree methodModifier = maker.Modifiers(Collections.singleton(Modifier.PUBLIC));
        return maker.Method(methodModifier, (CharSequence)"close", (Tree)JavaSourceHelper.createTypeTree(copy, "void"), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), "{   client.close();}", null);
    }

    @Override
    MethodTree generateBasicAuth(TreeMaker maker, WorkingCopy copy, List<VariableTree> authParams) {
        ModifiersTree methodModifier = maker.Modifiers(EnumSet.of(Modifier.PUBLIC, Modifier.FINAL));
        String body = "{   webTarget.register(new org.glassfish.jersey.client.filter.HttpBasicAuthFilter(username, password));}";
        return maker.Method(methodModifier, (CharSequence)"setUsernamePassword", (Tree)JavaSourceHelper.createTypeTree(copy, "void"), Collections.emptyList(), authParams, Collections.emptyList(), body, null);
    }

    @Override
    MethodTree generateHttpPOSTMethod(WorkingCopy copy, HttpMethod httpMethod, ClientJavaSourceHelper.HttpMimeType requestMimeType, boolean multipleMimeTypes) {
        String methodPrefix = httpMethod.getType().toLowerCase();
        String responseType = httpMethod.getReturnType();
        String path = httpMethod.getPath();
        String methodName = httpMethod.getName() + (multipleMimeTypes ? "_" + requestMimeType.name() : "");
        TreeMaker maker = copy.getTreeMaker();
        ModifiersTree methodModifier = maker.Modifiers(Collections.singleton(Modifier.PUBLIC));
        ModifiersTree paramModifier = maker.Modifiers(Collections.emptySet());
        VariableTree classParam = null;
        IdentifierTree responseTree = null;
        String bodyParam1 = "";
        String ret = "";
        List<Object> typeParams = Collections.emptyList();
        ArrayList<VariableTree> paramList = new ArrayList<VariableTree>();
        String bodyParam = "null";
        if (methodPrefix.equals("delete")) {
            bodyParam = "";
        }
        if (requestMimeType != null && requestMimeType != ClientJavaSourceHelper.HttpMimeType.FORM) {
            VariableTree objectParam = maker.Variable(paramModifier, (CharSequence)"requestEntity", (Tree)maker.Identifier((CharSequence)"Object"), null);
            paramList.add(objectParam);
            bodyParam = "javax.ws.rs.client.Entity.entity(requestEntity," + requestMimeType.getMediaType() + ")";
        }
        if ("javax.ws.rs.core.Response".equals(responseType)) {
            TypeElement clientResponseEl = copy.getElements().getTypeElement("javax.ws.rs.core.Response");
            ret = "return ";
            responseTree = clientResponseEl == null ? copy.getTreeMaker().Identifier((CharSequence)"javax.ws.rs.core.Response") : copy.getTreeMaker().QualIdent((Element)clientResponseEl);
            bodyParam1 = clientResponseEl == null ? "javax.ws.rs.core.Response.class" : "Response.class";
        } else if ("void".equals(responseType)) {
            responseTree = maker.Identifier((CharSequence)"void");
        } else if (String.class.getName().equals(responseType)) {
            responseTree = maker.Identifier((CharSequence)"String");
            ret = "return ";
            bodyParam1 = "String.class";
        } else {
            responseTree = maker.Identifier((CharSequence)"T");
            ret = "return ";
            bodyParam1 = "responseType";
            classParam = maker.Variable(paramModifier, (CharSequence)"responseType", (Tree)maker.Identifier((CharSequence)"Class<T>"), null);
            typeParams = Collections.singletonList(maker.TypeParameter((CharSequence)"T", Collections.emptyList()));
        }
        if (classParam != null) {
            paramList.add(classParam);
        }
        if (bodyParam.length() > 0 && bodyParam1.length() > 0) {
            bodyParam = bodyParam + ",";
        }
        ExpressionTree throwsTree = JavaSourceHelper.createTypeTree(copy, "javax.ws.rs.ClientErrorException");
        if (path.length() == 0) {
            String body = "{" + (requestMimeType == null ? "   " + ret + "webTarget.request()." + methodPrefix + "(" + bodyParam + bodyParam1 + ");" : "   " + ret + "webTarget.request(" + requestMimeType.getMediaType() + ")." + methodPrefix + "(" + bodyParam + bodyParam1 + ");") + "}";
            return maker.Method(methodModifier, (CharSequence)methodName, (Tree)responseTree, typeParams, paramList, Collections.singletonList(throwsTree), body, null);
        }
        ClientJavaSourceHelper.PathFormat pf = JaxRsGenerationStrategy.getPathFormat(path);
        for (String arg : pf.getArguments()) {
            IdentifierTree typeTree = maker.Identifier((CharSequence)"String");
            ModifiersTree fieldModifier = maker.Modifiers(Collections.emptySet());
            VariableTree fieldTree = maker.Variable(fieldModifier, (CharSequence)arg, (Tree)typeTree, null);
            paramList.add(fieldTree);
        }
        String body = "{" + (requestMimeType == null ? "   " + ret + "webTarget.path(" + this.getPathExpression(pf) + ").request()." + methodPrefix + "(" + bodyParam + bodyParam1 + ");" : "   " + ret + "webTarget.path(" + this.getPathExpression(pf) + ").request(" + requestMimeType.getMediaType() + ")." + methodPrefix + "(" + bodyParam + bodyParam1 + ");") + "}";
        return maker.Method(methodModifier, (CharSequence)methodName, (Tree)responseTree, typeParams, paramList, Collections.singletonList(throwsTree), body, null);
    }

    @Override
    Collection<? extends MethodTree> generateHttpGETMethod(WorkingCopy copy, HttpMethod httpMethod, ClientJavaSourceHelper.HttpMimeType mimeType, boolean multipleMimeTypes) {
        ArrayList<MethodTree> result = new ArrayList<MethodTree>(2);
        String responseType = httpMethod.getReturnType();
        String path = httpMethod.getPath();
        String methodName = httpMethod.getName() + (multipleMimeTypes ? "_" + mimeType.name() : "");
        TreeMaker maker = copy.getTreeMaker();
        ModifiersTree methodModifier = maker.Modifiers(Collections.singleton(Modifier.PUBLIC));
        ModifiersTree paramModifier = maker.Modifiers(Collections.emptySet());
        VariableTree classParam = null;
        IdentifierTree responseTree = null;
        String bodyParam = "";
        List<Object> typeParams = null;
        if (String.class.getName().equals(responseType)) {
            responseTree = maker.Identifier((CharSequence)"String");
            bodyParam = "String.class";
            typeParams = Collections.emptyList();
        } else {
            responseTree = maker.Identifier((CharSequence)"T");
            bodyParam = "responseType";
            classParam = maker.Variable(paramModifier, (CharSequence)"responseType", (Tree)maker.Identifier((CharSequence)"Class<T>"), null);
            typeParams = Collections.singletonList(maker.TypeParameter((CharSequence)"T", Collections.emptyList()));
        }
        ArrayList<VariableTree> paramList = new ArrayList<VariableTree>();
        if (classParam != null) {
            paramList.add(classParam);
        }
        ExpressionTree throwsTree = JavaSourceHelper.createTypeTree(copy, "javax.ws.rs.ClientErrorException");
        StringBuilder body = new StringBuilder("{ WebTarget resource = webTarget;");
        StringBuilder resourceBuilder = new StringBuilder();
        if (path.length() == 0) {
            if (mimeType != null) {
                resourceBuilder.append(".request(");
                resourceBuilder.append(mimeType.getMediaType());
                resourceBuilder.append(')');
            }
            this.buildQueryParams(body, httpMethod, paramList, maker);
        } else {
            ClientJavaSourceHelper.PathFormat pf = JaxRsGenerationStrategy.getPathFormat(path);
            for (String arg : pf.getArguments()) {
                IdentifierTree typeTree = maker.Identifier((CharSequence)"String");
                ModifiersTree fieldModifier = maker.Modifiers(Collections.emptySet());
                VariableTree fieldTree = maker.Variable(fieldModifier, (CharSequence)arg, (Tree)typeTree, null);
                paramList.add(fieldTree);
            }
            this.buildQueryParams(body, httpMethod, paramList, maker);
            body.append("resource=resource.path(");
            body.append(this.getPathExpression(pf));
            body.append(')');
            if (mimeType != null) {
                resourceBuilder.append(".request(");
                resourceBuilder.append(mimeType.getMediaType());
                resourceBuilder.append(')');
            }
        }
        body.append("return resource");
        body.append((CharSequence)resourceBuilder);
        body.append(".get(");
        body.append(bodyParam);
        body.append(");");
        body.append('}');
        MethodTree method = maker.Method(methodModifier, (CharSequence)methodName, (Tree)responseTree, typeParams, paramList, Collections.singletonList(throwsTree), body.toString(), null);
        result.add(method);
        return result;
    }

    @Override
    MethodTree generateHttpGETMethod(WorkingCopy copy, WadlSaasMethod saasMethod, ClientJavaSourceHelper.HttpMimeType mimeType, boolean multipleMimeTypes, HttpParams httpParams, Security security) {
        MethodTree method;
        String methodName = Wadl2JavaHelper.makeJavaIdentifier(saasMethod.getName()) + (multipleMimeTypes ? "_" + mimeType.name() : "");
        TreeMaker maker = copy.getTreeMaker();
        ModifiersTree methodModifier = maker.Modifiers(Collections.singleton(Modifier.PUBLIC));
        ModifiersTree paramModifier = maker.Modifiers(Collections.emptySet());
        VariableTree classParam = maker.Variable(paramModifier, (CharSequence)"responseType", (Tree)maker.Identifier((CharSequence)"Class<T>"), null);
        IdentifierTree responseTree = maker.Identifier((CharSequence)"T");
        String bodyParam = "responseType";
        List<TypeParameterTree> typeParams = Collections.singletonList(maker.TypeParameter((CharSequence)"T", Collections.emptyList()));
        ArrayList<VariableTree> paramList = new ArrayList<VariableTree>();
        if (classParam != null) {
            paramList.add(classParam);
        }
        StringBuilder queryP = new StringBuilder();
        StringBuilder queryParamPart = new StringBuilder();
        StringBuilder commentBuffer = new StringBuilder("@param responseType Class representing the response\n");
        if (httpParams.hasQueryParams()) {
            this.addQueryParams(maker, httpParams, security, paramList, queryP, queryParamPart, commentBuffer);
            if (queryP.length() > 0 && queryP.charAt(0) == '.') {
                queryP.insert(0, "webTarget = webTarget");
            }
        }
        queryP.append("return webTarget");
        commentBuffer.append("@return response object (instance of responseType class)");
        if (mimeType == null) {
            queryP.append(".request()");
        } else {
            queryP.append(".request(");
            queryP.append(mimeType.getMediaType());
            queryP.append(')');
        }
        if (httpParams.hasHeaderParams()) {
            this.addHeaderParams(maker, httpParams, paramList, queryP, commentBuffer);
        }
        String body = "{" + queryParamPart + queryP + ".get(" + bodyParam + ");}";
        ArrayList<ExpressionTree> throwsList = new ArrayList<ExpressionTree>();
        ExpressionTree throwsTree = JavaSourceHelper.createTypeTree(copy, "javax.ws.rs.ClientErrorException");
        throwsList.add(throwsTree);
        if (Security.Authentication.SESSION_KEY == security.getAuthentication()) {
            ExpressionTree ioExceptionTree = JavaSourceHelper.createTypeTree(copy, "java.io.IOException");
            throwsList.add(ioExceptionTree);
        }
        if ((method = maker.Method(methodModifier, (CharSequence)methodName, (Tree)responseTree, typeParams, paramList, throwsList, body, null)) != null) {
            Comment comment = Comment.create((Comment.Style)Comment.Style.JAVADOC, (String)commentBuffer.toString());
            maker.addComment((Tree)method, comment, true);
        }
        return method;
    }

    @Override
    MethodTree generateHttpPOSTMethod(WorkingCopy copy, WadlSaasMethod saasMethod, ClientJavaSourceHelper.HttpMimeType requestMimeType, boolean multipleMimeTypes, HttpParams httpParams, Security security) {
        String body;
        MethodTree method;
        String methodName = saasMethod.getName() + (multipleMimeTypes ? "_" + requestMimeType.name() : "");
        String methodPrefix = saasMethod.getWadlMethod().getName().toLowerCase();
        TreeMaker maker = copy.getTreeMaker();
        ModifiersTree methodModifier = maker.Modifiers(Collections.singleton(Modifier.PUBLIC));
        ModifiersTree paramModifier = maker.Modifiers(Collections.emptySet());
        List response = saasMethod.getWadlMethod().getResponse();
        ArrayList<VariableTree> paramList = new ArrayList<VariableTree>();
        IdentifierTree responseTree = null;
        List<Object> typeParams = null;
        String bodyParam1 = "";
        String bodyParam = "null";
        if (methodPrefix.equals("delete")) {
            bodyParam = "";
        }
        String ret = "";
        StringBuilder commentBuffer = new StringBuilder();
        if (response != null && !response.isEmpty()) {
            VariableTree classParam = maker.Variable(paramModifier, (CharSequence)"responseType", (Tree)maker.Identifier((CharSequence)"Class<T>"), null);
            responseTree = maker.Identifier((CharSequence)"T");
            bodyParam1 = ", responseType";
            typeParams = Collections.singletonList(maker.TypeParameter((CharSequence)"T", Collections.emptyList()));
            if (classParam != null) {
                paramList.add(classParam);
                commentBuffer.append("@param responseType Class representing the response\n");
            }
            ret = "return ";
        } else {
            responseTree = maker.Identifier((CharSequence)"void");
            typeParams = Collections.emptyList();
        }
        StringBuilder queryP = new StringBuilder();
        StringBuilder queryParamPart = new StringBuilder();
        if (httpParams.hasFormParams() || httpParams.hasQueryParams()) {
            this.addQueryParams(maker, httpParams, security, paramList, queryP, queryParamPart, commentBuffer);
            if (queryP.length() > 0 && queryP.charAt(0) == '.') {
                queryP.insert(0, "webTarget = webTarget");
            }
        }
        queryP.append(ret);
        queryP.append(" webTarget");
        if (requestMimeType != null) {
            if (requestMimeType == ClientJavaSourceHelper.HttpMimeType.FORM && httpParams.hasFormParams()) {
                bodyParam = "javax.ws.rs.client.Entity.form(getQueryOrFormParams(formParamNames, formParamValues))";
            } else {
                VariableTree objectParam = maker.Variable(paramModifier, (CharSequence)"requestEntity", (Tree)maker.Identifier((CharSequence)"Object"), null);
                paramList.add(0, objectParam);
                bodyParam = "javax.ws.rs.client.Entity.entity(requestEntity, " + requestMimeType.getMediaType() + ")";
                commentBuffer.append("@param requestEntity request data");
            }
        }
        commentBuffer.append("@return response object (instance of responseType class)");
        ArrayList<ExpressionTree> throwsList = new ArrayList<ExpressionTree>();
        ExpressionTree throwsTree = JavaSourceHelper.createTypeTree(copy, "javax.ws.rs.ClientErrorException");
        throwsList.add(throwsTree);
        if (Security.Authentication.SESSION_KEY == security.getAuthentication()) {
            ExpressionTree ioExceptionTree = JavaSourceHelper.createTypeTree(copy, "java.io.IOException");
            throwsList.add(ioExceptionTree);
        }
        if (requestMimeType == null) {
            queryP.append(".request()");
        } else {
            queryP.append(".request(");
            queryP.append(requestMimeType.getMediaType());
            queryP.append(')');
        }
        if (httpParams.hasHeaderParams()) {
            this.addHeaderParams(maker, httpParams, paramList, queryP, commentBuffer);
        }
        if ((method = maker.Method(methodModifier, (CharSequence)methodName, (Tree)responseTree, typeParams, paramList, throwsList, body = "{" + queryParamPart + queryP + "." + methodPrefix + "(" + bodyParam + bodyParam1 + ");}", null)) != null) {
            Comment comment = Comment.create((Comment.Style)Comment.Style.JAVADOC, (String)commentBuffer.toString());
            maker.addComment((Tree)method, comment, true);
        }
        return method;
    }

    @Override
    MethodTree generateFormMethod(TreeMaker maker, WorkingCopy copy) {
        String form = "javax.ws.rs.core.Form";
        TypeElement mvMapEl = copy.getElements().getTypeElement(form);
        String mvType = mvMapEl == null ? "javax.ws.rs.core.Form" : "Form";
        String body = "{" + mvType + " form = new javax.ws.rs.core.Form();for (int i=0;i< paramNames.length;i++) {    if (paramValues[i] != null) {        form = form.param(paramNames[i], paramValues[i]);    }}return form;}";
        ModifiersTree methodModifier = maker.Modifiers(Collections.singleton(Modifier.PRIVATE));
        ExpressionTree returnTree = mvMapEl == null ? copy.getTreeMaker().Identifier((CharSequence)"javax.ws.rs.core.Form") : copy.getTreeMaker().QualIdent((Element)mvMapEl);
        ArrayList<VariableTree> paramList = new ArrayList<VariableTree>();
        ModifiersTree paramModifier = maker.Modifiers(Collections.emptySet());
        paramList.add(maker.Variable(paramModifier, (CharSequence)"paramNames", (Tree)maker.Identifier((CharSequence)"String[]"), null));
        paramList.add(maker.Variable(paramModifier, (CharSequence)"paramValues", (Tree)maker.Identifier((CharSequence)"String[]"), null));
        return maker.Method(methodModifier, (CharSequence)"getQueryOrFormParams", (Tree)returnTree, Collections.emptyList(), paramList, Collections.emptyList(), body, null);
    }

    @Override
    MethodTree generateOptionalFormMethod(TreeMaker maker, WorkingCopy copy) {
        String mvMapClass = "javax.ws.rs.core.MultivaluedMap";
        TypeElement mvMapEl = copy.getElements().getTypeElement(mvMapClass);
        String mvType = mvMapEl == null ? mvMapClass : "MultivaluedMap";
        String body = "{" + mvType + "<String,String> qParams = new javax.ws.rs.core.MultivaluedHashMap<String,String>();for (String qParam : optionalParams) {    String[] qPar = qParam.split(\"=\");    if (qPar.length > 1) qParams.add(qPar[0], qPar[1])}return qParams;}";
        ModifiersTree methodModifier = maker.Modifiers(Collections.singleton(Modifier.PRIVATE));
        ExpressionTree returnTree = mvMapEl == null ? copy.getTreeMaker().Identifier((CharSequence)mvMapClass) : copy.getTreeMaker().QualIdent((Element)mvMapEl);
        ModifiersTree paramModifier = maker.Modifiers(Collections.emptySet());
        VariableTree param = maker.Variable(paramModifier, (CharSequence)"optionalParams", (Tree)maker.Identifier((CharSequence)"String..."), null);
        return maker.Method(methodModifier, (CharSequence)"getQParams", (Tree)returnTree, Collections.emptyList(), Collections.singletonList(param), Collections.emptyList(), body, null);
    }

    @Override
    ClassTree generateOAuthMethods(String projectType, WorkingCopy copy, ClassTree modifiedClass, Metadata oauthMetadata) {
        assert (false);
        return modifiedClass;
    }
}

