/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.java;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.java.api.ProjectSourcesClassPathProvider;
import org.netbeans.modules.gradle.java.execute.JavaRunUtils;
import org.netbeans.modules.gradle.java.spi.debug.GradleJavaDebugger;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.java.queries.SourceForBinaryQueryImplementation2;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public final class GradleJavaDebuggerImpl
implements GradleJavaDebugger {
    private final RequestProcessor RP = new RequestProcessor(GradleJavaDebuggerImpl.class);
    final Project project;

    public GradleJavaDebuggerImpl(Project project) {
        this.project = project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void attachDebugger(String name, String transport, String host, String address) throws Exception {
        Object[] lock = new Object[1];
        ClassPath sourcePath = this.getSources();
        ClassPath jdkSourcePath = this.getJdkSources();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("sourcepath", sourcePath);
        properties.put("name", name);
        properties.put("jdksources", jdkSourcePath);
        properties.put("baseDir", FileUtil.toFile((FileObject)this.project.getProjectDirectory()));
        if (JavaRunUtils.isCompileOnSaveEnabled(this.project)) {
            properties.put("listeningCP", "sourcepath");
        }
        Object[] objectArray = lock;
        synchronized (lock) {
            this.RP.post(() -> {
                Object[] objectArray = lock;
                synchronized (lock) {
                    block11: {
                        try {
                            if (transport.equals("dt_socket")) {
                                try {
                                    JPDADebugger.attach((String)host, (int)Integer.parseInt(address), (Object[])new Object[]{properties});
                                    break block11;
                                }
                                catch (NumberFormatException e) {
                                    throw new Exception("address attribute must specify port number for dt_socket connection");
                                }
                            }
                            JPDADebugger.attach((String)address, (Object[])new Object[]{properties});
                        }
                        catch (Throwable e) {
                            lock[0] = e;
                        }
                        finally {
                            lock.notify();
                        }
                    }
                    // ** MonitorExit[var5_5] (shouldn't be in output)
                    return;
                }
            });
            lock.wait();
            if (lock[0] != null) {
                throw new Exception("", (Throwable)lock[0]);
            }
            // ** MonitorExit[var9_9] (shouldn't be in output)
            return;
        }
    }

    private ClassPath getJdkSources() {
        JavaPlatform jdk = (JavaPlatform)JavaRunUtils.getActivePlatform(this.project).second();
        if (jdk != null) {
            return jdk.getSourceFolders();
        }
        return null;
    }

    private ClassPath getSources() {
        ProjectSourcesClassPathProvider pgcpp = (ProjectSourcesClassPathProvider)this.project.getLookup().lookup(ProjectSourcesClassPathProvider.class);
        ArrayList sourceQueryImpls = new ArrayList(2);
        sourceQueryImpls.addAll(this.project.getLookup().lookupAll(SourceForBinaryQueryImplementation2.class));
        sourceQueryImpls.addAll(Lookup.getDefault().lookupAll(SourceForBinaryQueryImplementation2.class));
        LinkedHashSet<FileObject> srcs = new LinkedHashSet<FileObject>();
        for (ClassPath projectSourcePath : pgcpp.getProjectClassPath("classpath/source")) {
            srcs.addAll(Arrays.asList(projectSourcePath.getRoots()));
        }
        for (ClassPath cp : pgcpp.getProjectClassPath("classpath/execute")) {
            block2: for (ClassPath.Entry entry : cp.entries()) {
                URL url = entry.getURL();
                for (SourceForBinaryQueryImplementation2 sourceQuery : sourceQueryImpls) {
                    List<FileObject> roots;
                    SourceForBinaryQueryImplementation2.Result ret = sourceQuery.findSourceRoots2(url);
                    if (ret == null || (roots = Arrays.asList(ret.getRoots())).isEmpty()) continue;
                    srcs.addAll(roots);
                    continue block2;
                }
            }
        }
        FileObject[] roots = srcs.toArray(new FileObject[srcs.size()]);
        return ClassPathSupport.createClassPath((FileObject[])roots);
    }
}

