/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.catalog;

import java.beans.Customizer;
import java.beans.IntrospectionException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.netbeans.modules.xml.catalog.lib.Util;
import org.openide.util.Utilities;

final class CatalogMounterModel {
    private Object catalog = null;
    private ComboBoxModel cxModel = null;
    private List<ChangeListener> changeListeners = new ArrayList<ChangeListener>(2);

    public CatalogMounterModel(Iterator providers) {
        Vector<Entry> providersList = new Vector<Entry>();
        while (providers.hasNext()) {
            providersList.add(new Entry((Class)providers.next()));
        }
        this.cxModel = new DefaultComboBoxModel(providersList);
        this.cxModel.addListDataListener(new Lis());
        this.initCatalog();
    }

    public Object getCatalog() {
        return this.catalog;
    }

    public Customizer getCatalogCustomizer() {
        if (this.catalog == null) {
            return null;
        }
        return Util.getProviderCustomizer(this.catalog.getClass());
    }

    public ComboBoxModel getCatalogComboBoxModel() {
        return this.cxModel;
    }

    public void addChangeListener(ChangeListener l) {
        this.changeListeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeListeners.remove(l);
    }

    private Entry getSelectedEntry() {
        return (Entry)this.cxModel.getSelectedItem();
    }

    private void initCatalog() {
        Entry entry = this.getSelectedEntry();
        this.catalog = entry == null ? null : Util.createProvider(entry.src);
        this.fireStateChanged();
    }

    private void fireStateChanged() {
        for (ChangeListener next : this.changeListeners) {
            next.stateChanged(new ChangeEvent(this));
        }
    }

    private class Lis
    implements ListDataListener {
        private Lis() {
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            CatalogMounterModel.this.initCatalog();
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            CatalogMounterModel.this.initCatalog();
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            CatalogMounterModel.this.initCatalog();
        }
    }

    private class Entry {
        String name = null;
        Class src;

        public Entry(Class src) {
            this.src = src;
            try {
                this.name = Utilities.getBeanInfo((Class)src).getBeanDescriptor().getDisplayName();
            }
            catch (IntrospectionException ex) {
                this.name = src.toString();
            }
        }

        public String toString() {
            return this.name;
        }
    }
}

