/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.refactoring.utils;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.control.SourceUnit;
import org.netbeans.modules.groovy.editor.api.ASTUtils;
import org.netbeans.modules.groovy.editor.api.parser.GroovyParserResult;
import org.netbeans.modules.groovy.refactoring.utils.GroovyProjectUtil;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.Parser;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public final class TypeFinder {
    private TypeFinder() {
    }

    public static Set<ClassNode> findTypes(FileObject fileInProject, String className) {
        HashSet<ClassNode> types = new HashSet<ClassNode>();
        for (FileObject fo : GroovyProjectUtil.getGroovyFilesInProject(fileInProject)) {
            try {
                FindPossibleTypesTask task = new FindPossibleTypesTask(className);
                ParserManager.parse(Collections.singleton(Source.create((FileObject)fo)), (UserTask)task);
                types.addAll(task.getResult());
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return types;
    }

    private static class TypesCollector
    extends ClassCodeVisitorSupport {
        private final ModuleNode moduleNode;
        private final String className;
        private final Set<ClassNode> types;

        public TypesCollector(ModuleNode moduleNode, String className) {
            this.moduleNode = moduleNode;
            this.className = className;
            this.types = new HashSet<ClassNode>();
        }

        protected SourceUnit getSourceUnit() {
            return this.moduleNode.getContext();
        }

        public Set<ClassNode> collectTypes() {
            for (ClassNode classNode : this.moduleNode.getClasses()) {
                this.visitClass(classNode);
            }
            return this.types;
        }

        public void visitClass(ClassNode classNode) {
            if (this.className.equals(classNode.getNameWithoutPackage())) {
                this.types.add(classNode);
            }
            super.visitClass(classNode);
        }
    }

    private static class FindPossibleTypesTask
    extends UserTask {
        private final String className;
        private final Set<ClassNode> types;

        public FindPossibleTypesTask(String className) {
            this.className = className;
            this.types = new HashSet<ClassNode>();
        }

        public void run(ResultIterator resultIterator) throws Exception {
            GroovyParserResult result = ASTUtils.getParseResult((Parser.Result)resultIterator.getParserResult());
            ModuleNode moduleNode = result.getRootElement().getModuleNode();
            this.types.addAll(new TypesCollector(moduleNode, this.className).collectTypes());
        }

        public Set<ClassNode> getResult() {
            return this.types;
        }
    }
}

