/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.proxy;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.SocketChannel;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.net.SocketFactory;
import org.netbeans.api.keyring.Keyring;
import org.netbeans.modules.proxy.ConnectivitySettings;
import org.netbeans.modules.proxy.InterruptibleInputStream;
import org.openide.util.NetworkSettings;

public class ProxySocketFactory
extends SocketFactory {
    private static final int CONNECT_TIMEOUT = 20000;
    private static final String AUTH_NONE = "<none>";
    private static final String AUTH_BASIC = "Basic";
    private static final Pattern sConnectionEstablishedPattern = Pattern.compile("HTTP\\/\\d+\\.\\d+\\s+200\\s+");
    private static final Pattern sProxyAuthRequiredPattern = Pattern.compile("HTTP\\/\\d+\\.\\d+\\s+407\\s+");
    private static final ProxySocketFactory instance = new ProxySocketFactory();
    private final Map<InetSocketAddress, ConnectivitySettings> lastKnownSettings = Collections.synchronizedMap(new HashMap(2));

    public static ProxySocketFactory getDefault() {
        return instance;
    }

    private ProxySocketFactory() {
    }

    @Override
    public Socket createSocket() throws IOException {
        return new Socket(){

            @Override
            public void connect(SocketAddress endpoint, int timeout) throws IOException {
                Socket s = ProxySocketFactory.this.createSocket((InetSocketAddress)endpoint, timeout);
                s.close();
            }

            @Override
            public void bind(SocketAddress bindpoint) {
                throw new UnsupportedOperationException();
            }

            protected Object clone() {
                throw new UnsupportedOperationException();
            }

            @Override
            public synchronized void close() {
            }

            @Override
            public void connect(SocketAddress endpoint) {
                throw new UnsupportedOperationException();
            }

            @Override
            public SocketChannel getChannel() {
                throw new UnsupportedOperationException();
            }

            @Override
            public InetAddress getInetAddress() {
                throw new UnsupportedOperationException();
            }

            @Override
            public InputStream getInputStream() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean getKeepAlive() {
                throw new UnsupportedOperationException();
            }

            @Override
            public InetAddress getLocalAddress() {
                throw new UnsupportedOperationException();
            }

            @Override
            public int getLocalPort() {
                throw new UnsupportedOperationException();
            }

            @Override
            public SocketAddress getLocalSocketAddress() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean getOOBInline() {
                throw new UnsupportedOperationException();
            }

            @Override
            public OutputStream getOutputStream() {
                throw new UnsupportedOperationException();
            }

            @Override
            public int getPort() {
                throw new UnsupportedOperationException();
            }

            @Override
            public synchronized int getReceiveBufferSize() {
                throw new UnsupportedOperationException();
            }

            @Override
            public SocketAddress getRemoteSocketAddress() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean getReuseAddress() {
                throw new UnsupportedOperationException();
            }

            @Override
            public synchronized int getSendBufferSize() {
                throw new UnsupportedOperationException();
            }

            @Override
            public int getSoLinger() {
                throw new UnsupportedOperationException();
            }

            @Override
            public synchronized int getSoTimeout() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean getTcpNoDelay() {
                throw new UnsupportedOperationException();
            }

            @Override
            public int getTrafficClass() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean isBound() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean isClosed() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean isConnected() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean isInputShutdown() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean isOutputShutdown() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void sendUrgentData(int data) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void setKeepAlive(boolean on) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void setOOBInline(boolean on) {
                throw new UnsupportedOperationException();
            }

            @Override
            public synchronized void setReceiveBufferSize(int size) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void setReuseAddress(boolean on) {
                throw new UnsupportedOperationException();
            }

            @Override
            public synchronized void setSendBufferSize(int size) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void setSoLinger(boolean on, int linger) {
                throw new UnsupportedOperationException();
            }

            @Override
            public synchronized void setSoTimeout(int timeout) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void setTcpNoDelay(boolean on) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void setTrafficClass(int tc) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void shutdownInput() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void shutdownOutput() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        return this.createSocket(new InetSocketAddress(host, port), 20000);
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int port) throws IOException {
        return this.createSocket(new InetSocketAddress(inetAddress, port), 20000);
    }

    @Override
    public Socket createSocket(String s, int i, InetAddress inetAddress, int i1) throws IOException {
        throw new IOException("Unsupported operation");
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int i, InetAddress inetAddress1, int i1) throws IOException {
        throw new IOException("Unsupported operation");
    }

    private Socket getHttpsTunnelSocket(InetSocketAddress address, ConnectivitySettings cs, int timeout) throws IOException {
        Socket proxy = new Socket();
        proxy.connect(new InetSocketAddress(cs.getProxyHost(), cs.getProxyPort()), timeout);
        BufferedReader r = new BufferedReader(new InputStreamReader(new InterruptibleInputStream(proxy.getInputStream())));
        DataOutputStream dos = new DataOutputStream(proxy.getOutputStream());
        dos.writeBytes("CONNECT ");
        dos.writeBytes(address.getHostName() + ":" + address.getPort());
        dos.writeBytes(" HTTP/1.0\r\n");
        dos.writeBytes("Connection: Keep-Alive\r\n\r\n");
        dos.flush();
        String line = r.readLine();
        if (sConnectionEstablishedPattern.matcher(line).find()) {
            while ((line = r.readLine()).length() != 0) {
            }
            return proxy;
        }
        if (sProxyAuthRequiredPattern.matcher(line).find()) {
            boolean authMethodSelected = false;
            String authMethod = AUTH_NONE;
            while ((line = r.readLine()).length() != 0) {
                if (!line.startsWith("Proxy-Authenticate:") || authMethodSelected || !(authMethod = line.substring(19).trim()).equals(AUTH_BASIC)) continue;
                authMethodSelected = true;
            }
            proxy.close();
            if (authMethod.startsWith(AUTH_BASIC)) {
                return this.authenticateBasic(address, cs);
            }
            throw new IOException("Unsupported authentication method: " + authMethod);
        }
        proxy.close();
        throw new IOException("HTTP proxy does not support CONNECT command. Received reply: " + line);
    }

    private Socket authenticateBasic(InetSocketAddress address, ConnectivitySettings cs) throws IOException {
        Socket proxy = new Socket(cs.getProxyHost(), cs.getProxyPort());
        BufferedReader r = new BufferedReader(new InputStreamReader(new InterruptibleInputStream(proxy.getInputStream())));
        DataOutputStream dos = new DataOutputStream(proxy.getOutputStream());
        String username = cs.getProxyUsername() == null ? "" : cs.getProxyUsername();
        String password = cs.getProxyPassword() == null ? "" : String.valueOf(cs.getProxyPassword());
        String credentials = username + ":" + password;
        String basicCookie = ProxySocketFactory.encodeCredentials(credentials);
        dos.writeBytes("CONNECT ");
        dos.writeBytes(address.getHostName() + ":" + address.getPort());
        dos.writeBytes(" HTTP/1.0\r\n");
        dos.writeBytes("Connection: Keep-Alive\r\n");
        dos.writeBytes("Proxy-Authorization: Basic " + basicCookie + "\r\n");
        dos.writeBytes("\r\n");
        dos.flush();
        String line = r.readLine();
        if (sConnectionEstablishedPattern.matcher(line).find()) {
            while ((line = r.readLine()).length() != 0) {
            }
            return proxy;
        }
        throw new IOException("Basic authentication failed: " + line);
    }

    static String encodeCredentials(String credentials) throws UnsupportedEncodingException {
        return Base64.getEncoder().encodeToString(credentials.getBytes("US-ASCII"));
    }

    /*
     * Exception decompiling
     */
    private Socket createSocket(InetSocketAddress address, int timeout) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private URI addressToURI(InetSocketAddress address, String schema) {
        URI uri;
        try {
            uri = address.isUnresolved() ? new URI(schema + "://" + address.getHostName() + ":" + address.getPort()) : new URI(schema + "://" + address.getAddress().getHostAddress() + ":" + address.getPort());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return uri;
    }

    private Socket createSocket(URI uri, InetSocketAddress address, int timeout) throws IOException {
        List<Proxy> proxies = ProxySelector.getDefault().select(uri);
        IOException lastFailure = null;
        for (Proxy proxy : proxies) {
            ConnectivitySettings cs = this.proxyToCs(proxy, uri);
            try {
                Socket s = this.createSocket(cs, address, timeout);
                this.lastKnownSettings.put(address, cs);
                return s;
            }
            catch (IOException e) {
                lastFailure = e;
            }
        }
        throw lastFailure;
    }

    private ConnectivitySettings proxyToCs(Proxy proxy, URI uri) {
        ConnectivitySettings cs = new ConnectivitySettings();
        InetSocketAddress isa = (InetSocketAddress)proxy.address();
        switch (proxy.type()) {
            case HTTP: {
                this.setupProxy(cs, 2, isa);
                break;
            }
            case SOCKS: {
                this.setupProxy(cs, 1, isa);
                break;
            }
        }
        String prosyUser = NetworkSettings.getAuthenticationUsername((URI)uri);
        if (prosyUser != null && !prosyUser.isEmpty()) {
            cs.setProxyUsername(prosyUser);
            cs.setProxyPassword(Keyring.read((String)NetworkSettings.getKeyForAuthenticationPassword((URI)uri)));
        }
        return cs;
    }

    private void setupProxy(ConnectivitySettings cs, int connectionType, InetSocketAddress inetSocketAddress) {
        cs.setConnectionType(connectionType);
        InetAddress address = inetSocketAddress.getAddress();
        cs.setProxyHost(address != null ? address.getHostAddress() : inetSocketAddress.getHostName());
        cs.setProxyPort(inetSocketAddress.getPort());
    }

    private Socket createSocket(ConnectivitySettings cs, InetSocketAddress address, int timeout) throws IOException {
        switch (cs.getConnectionType()) {
            case 0: 
            case 1: {
                Socket s = new Socket();
                s.connect(address, timeout);
                return s;
            }
            case 2: {
                return this.getHttpsTunnelSocket(address, cs, timeout);
            }
        }
        throw new IllegalArgumentException("Illegal connection type: " + cs.getConnectionType());
    }
}

