/*
 * Decompiled with CFR 0.152.
 */
package org.jvyamlb;

public class Position {
    public final int line;
    public final int column;
    public final int offset;

    public Position(int line, int column, int offset) {
        this.line = line;
        this.column = column;
        this.offset = offset;
    }

    public Position withLine(int line) {
        return new Position(line, this.column, this.offset);
    }

    public Position withColumn(int column) {
        return new Position(this.line, column, this.offset);
    }

    public Position withOffset(int offset) {
        return new Position(this.line, this.column, offset);
    }

    public boolean equals(Object other) {
        boolean res;
        boolean bl = res = this == other;
        if (!res && other instanceof Position) {
            Position o = (Position)other;
            res = this.line == o.line && this.column == o.column && this.offset == o.offset;
        }
        return res;
    }

    public String toString() {
        return "[" + this.line + ":" + this.column + "(" + this.offset + ")]";
    }

    public static class Range {
        public final Position start;
        public final Position end;

        public Range(Position start) {
            this(start, start);
        }

        public Range(Position start, Position end) {
            this.start = start;
            this.end = end;
        }

        public Range withStart(Position start) {
            return new Range(start, this.end);
        }

        public Range withEnd(Position end) {
            return new Range(this.start, end);
        }

        public boolean equals(Object other) {
            boolean res;
            boolean bl = res = this == other;
            if (!res && other instanceof Range) {
                Range o = (Range)other;
                res = this.start.equals(o.start) && this.end.equals(o.end);
            }
            return res;
        }

        public String toString() {
            return "#<Range " + this.start + ":" + this.end + ">";
        }
    }
}

