/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.webkit.debugging.api.network;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.netbeans.modules.web.webkit.debugging.LiveHTML;
import org.netbeans.modules.web.webkit.debugging.TransportHelper;
import org.netbeans.modules.web.webkit.debugging.api.WebKitDebugging;
import org.netbeans.modules.web.webkit.debugging.api.console.ConsoleMessage;
import org.netbeans.modules.web.webkit.debugging.spi.Command;
import org.netbeans.modules.web.webkit.debugging.spi.Response;
import org.netbeans.modules.web.webkit.debugging.spi.ResponseCallback;

public class Network {
    private final TransportHelper transport;
    private boolean enabled;
    private final Callback callback;
    private final WebKitDebugging webKit;
    private int numberOfClients = 0;
    private boolean inLiveHTMLMode = false;
    private final List<Listener> listeners = new CopyOnWriteArrayList<Listener>();
    private final Map<String, Request> activeRequests = new HashMap<String, Request>();
    private final Map<String, WebSocketRequest> activeWebSocketRequests = new HashMap<String, WebSocketRequest>();

    public Network(TransportHelper transport, WebKitDebugging webKit) {
        this.transport = transport;
        this.callback = new Callback();
        this.transport.addListener(this.callback);
        this.webKit = webKit;
    }

    public void enable() {
        ++this.numberOfClients;
        if (!this.enabled) {
            this.enabled = true;
            this.transport.sendBlockingCommand(new Command("Network.enable"));
        }
        this.inLiveHTMLMode = this.webKit.getDebugger().isInLiveHTMLMode();
    }

    public void disable() {
        assert (this.numberOfClients > 0);
        --this.numberOfClients;
        if (this.numberOfClients == 0) {
            this.transport.sendCommand(new Command("Network.disable"));
            this.enabled = false;
        }
    }

    private String getResponseBody(String requestId) {
        JSONObject result;
        JSONObject params = new JSONObject();
        params.put((Object)"requestId", (Object)requestId);
        Response response = this.transport.sendBlockingCommand(new Command("Network.getResponseBody", params));
        if (response != null && (result = response.getResult()) != null) {
            return String.valueOf(result.get((Object)"body"));
        }
        return null;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private void recordDataEvent(long timeStamp, String id, String request, String mime) {
        assert (this.inLiveHTMLMode);
        String response = this.getResponseBody(id);
        LiveHTML.getDefault().storeDataEvent(this.transport.getConnectionURL(), timeStamp, response, request, mime);
    }

    private void requestReceived(JSONObject params) {
        Request req = new Request(this, params);
        this.activeRequests.put(req.getRequestId(), req);
        this.fireNetworkRequest(req);
    }

    private void responseReceived(JSONObject params) {
        String requestId = String.valueOf(params.get((Object)"requestId"));
        assert (requestId != null);
        Request req = this.activeRequests.get(requestId);
        if (req == null) {
            return;
        }
        req.setResponse(params);
    }

    private void requestFailed(JSONObject params) {
        String requestId = String.valueOf(params.get((Object)"requestId"));
        assert (requestId != null);
        Request req = this.activeRequests.remove(requestId);
        if (req == null) {
            return;
        }
        req.setFailed(params);
    }

    private void dataReceived(JSONObject params) {
        String requestId = String.valueOf(params.get((Object)"requestId"));
        assert (requestId != null);
        Request req = this.activeRequests.get(requestId);
        if (req == null) {
            return;
        }
        req.dataLoadingStarted();
    }

    private void responseFinished(JSONObject params) {
        String requestId = String.valueOf(params.get((Object)"requestId"));
        assert (requestId != null);
        Request req = this.activeRequests.remove(requestId);
        if (req == null) {
            return;
        }
        req.requestCompleted();
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    private void fireNetworkRequest(Request req) {
        for (Listener l : this.listeners) {
            l.networkRequest(req);
        }
    }

    private void webSocketCreated(JSONObject params) {
        WebSocketRequest req = new WebSocketRequest(params);
        this.activeWebSocketRequests.put(req.getRequestId(), req);
        this.fireWebSocketNetworkRequest(req);
    }

    private void webSocketHandshakeRequest(JSONObject params) {
        String requestId = String.valueOf(params.get((Object)"requestId"));
        assert (requestId != null);
        WebSocketRequest req = this.activeWebSocketRequests.get(requestId);
        if (req == null) {
            return;
        }
        req.setHandshakeRequest(params);
    }

    private void webSocketHandshakeResponse(JSONObject params) {
        String requestId = String.valueOf(params.get((Object)"requestId"));
        assert (requestId != null);
        WebSocketRequest req = this.activeWebSocketRequests.get(requestId);
        if (req == null) {
            return;
        }
        req.setHandshakeResponse(params);
    }

    private void webSocketFrameSent(JSONObject params) {
        String requestId = String.valueOf(params.get((Object)"requestId"));
        assert (requestId != null);
        WebSocketRequest req = this.activeWebSocketRequests.get(requestId);
        if (req == null) {
            return;
        }
        req.addFrame(Direction.SEND, params);
    }

    private void webSocketFrameReceived(JSONObject params) {
        String requestId = String.valueOf(params.get((Object)"requestId"));
        assert (requestId != null);
        WebSocketRequest req = this.activeWebSocketRequests.get(requestId);
        if (req == null) {
            return;
        }
        req.addFrame(Direction.RECEIVED, params);
    }

    private void webSocketFrameError(JSONObject params) {
        String requestId = String.valueOf(params.get((Object)"requestId"));
        assert (requestId != null);
        WebSocketRequest req = this.activeWebSocketRequests.get(requestId);
        if (req == null) {
            return;
        }
        req.setFrameError(params);
    }

    private void webSocketClosed(JSONObject params) {
        String requestId = String.valueOf(params.get((Object)"requestId"));
        assert (requestId != null);
        WebSocketRequest req = this.activeWebSocketRequests.remove(requestId);
        if (req == null) {
            return;
        }
        req.close();
    }

    private void fireWebSocketNetworkRequest(WebSocketRequest req) {
        for (Listener l : this.listeners) {
            l.webSocketRequest(req);
        }
    }

    private class Callback
    implements ResponseCallback {
        private Callback() {
        }

        @Override
        public void handleResponse(Response response) {
            String method = response.getMethod();
            JSONObject params = response.getParams();
            if ("Network.requestWillBeSent".equals(method)) {
                Network.this.requestReceived(params);
            } else if ("Network.responseReceived".equals(method)) {
                Network.this.responseReceived(params);
                if (Network.this.inLiveHTMLMode && "XHR".equals(params.get((Object)"type"))) {
                    final long timeStamp = System.currentTimeMillis();
                    final String id = (String)params.get((Object)"requestId");
                    final String request = (String)((JSONObject)params.get((Object)"response")).get((Object)"url");
                    final String mime = (String)((JSONObject)params.get((Object)"response")).get((Object)"mimeType");
                    Network.this.transport.getRequestProcessor().post(new Runnable(){

                        @Override
                        public void run() {
                            Network.this.recordDataEvent(timeStamp, id, request, mime);
                        }
                    });
                }
            } else if ("Network.loadingFailed".equals(method)) {
                Network.this.requestFailed(params);
            } else if ("Network.dataReceived".equals(method)) {
                Network.this.dataReceived(params);
            } else if ("Network.loadingFinished".equals(method)) {
                Network.this.responseFinished(params);
            } else if ("Network.webSocketCreated".equals(method)) {
                Network.this.webSocketCreated(params);
            } else if ("Network.webSocketWillSendHandshakeRequest".equals(method)) {
                Network.this.webSocketHandshakeRequest(params);
            } else if ("Network.webSocketHandshakeResponseReceived".equals(method)) {
                Network.this.webSocketHandshakeResponse(params);
            } else if ("Network.webSocketFrameSent".equals(method)) {
                Network.this.webSocketFrameSent(params);
            } else if ("Network.webSocketFrameReceived".equals(method)) {
                Network.this.webSocketFrameReceived(params);
            } else if ("Network.webSocketFrameError".equals(method)) {
                Network.this.webSocketFrameError(params);
            } else if ("Network.webSocketClosed".equals(method)) {
                Network.this.webSocketClosed(params);
            }
        }
    }

    public static final class WebSocketFrame {
        private final Direction direction;
        private final JSONObject data;
        private final Date timestamp;
        private final int opcode;

        private WebSocketFrame(Date timestamp, Direction direction, JSONObject data, int opcode) {
            this.timestamp = timestamp;
            this.direction = direction;
            this.data = data;
            this.opcode = opcode;
        }

        public String getPayload() {
            return String.valueOf(this.data.get((Object)"payloadData"));
        }

        public Direction getDirection() {
            return this.direction;
        }

        public Date getTimestamp() {
            return this.timestamp;
        }

        public int getOpcode() {
            return this.opcode;
        }
    }

    public static enum Direction {
        SEND,
        RECEIVED;

    }

    public static final class WebSocketRequest {
        public static final String PROP_HANDSHAKE_REQUEST = "Network.WebSocketRequest.Handshake.Request";
        public static final String PROP_HANDSHAKE_RESPONSE = "Network.WebSocketRequest.Handshake.Response";
        public static final String PROP_FRAMES = "Network.WebSocketRequest.Frame";
        public static final String PROP_CLOSED = "Network.WebSocketRequest.Closed";
        private final String requestId;
        private final String url;
        private JSONObject handshakeRequest;
        private JSONObject handshakeResponse;
        private final PropertyChangeSupport support = new PropertyChangeSupport(this);
        private final List<WebSocketFrame> frames = new ArrayList<WebSocketFrame>();
        private boolean closed = false;
        private String errorMessage = null;

        private WebSocketRequest(JSONObject params) {
            this.requestId = String.valueOf(params.get((Object)"requestId"));
            this.url = String.valueOf(params.get((Object)"url"));
        }

        private String getRequestId() {
            return this.requestId;
        }

        public String getURL() {
            return this.url;
        }

        public JSONObject getHandshakeRequest() {
            return this.handshakeRequest;
        }

        private void setHandshakeRequest(JSONObject params) {
            this.handshakeRequest = (JSONObject)params.get((Object)"request");
            this.support.firePropertyChange(PROP_HANDSHAKE_REQUEST, null, null);
        }

        public JSONObject getHandshakeResponse() {
            return this.handshakeResponse;
        }

        private void setHandshakeResponse(JSONObject params) {
            this.handshakeResponse = (JSONObject)params.get((Object)"response");
            this.support.firePropertyChange(PROP_HANDSHAKE_RESPONSE, null, null);
        }

        private void setFrameError(JSONObject params) {
            this.errorMessage = (String)params.get((Object)"errorMessage");
            this.support.firePropertyChange(PROP_FRAMES, null, null);
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        private void addFrame(Direction direction, JSONObject params) {
            JSONObject response = (JSONObject)params.get((Object)"response");
            Number timestamp = (Number)params.get((Object)"timestamp");
            Number opcode = (Number)response.get((Object)"opcode");
            WebSocketFrame frame = new WebSocketFrame(new Date(timestamp.longValue()), direction, response, opcode.intValue());
            this.frames.add(frame);
            this.support.firePropertyChange(PROP_FRAMES, null, null);
        }

        public List<WebSocketFrame> getFrames() {
            return new ArrayList<WebSocketFrame>(this.frames);
        }

        public boolean isClosed() {
            return this.closed;
        }

        private void close() {
            this.closed = true;
            this.support.firePropertyChange(PROP_CLOSED, null, null);
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
            this.support.addPropertyChangeListener(l);
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
            this.support.addPropertyChangeListener(l);
        }
    }

    public static final class Request {
        public static final String PROP_RESPONSE = "Network.Request.Response";
        public static final String PROP_RESPONSE_DATA = "Network.Request.Response.Data";
        private final JSONObject request;
        private final JSONObject initiator;
        private final String requestId;
        private String responseType;
        private JSONObject response;
        private final PropertyChangeSupport support = new PropertyChangeSupport(this);
        private boolean hasData = false;
        private boolean dataReady = false;
        private final Network network;
        private boolean failed = false;
        private final String documentUrl;

        private Request(Network network, JSONObject params) {
            this.request = (JSONObject)params.get((Object)"request");
            this.initiator = (JSONObject)params.get((Object)"initiator");
            this.requestId = String.valueOf(params.get((Object)"requestId"));
            this.network = network;
            this.documentUrl = (String)params.get((Object)"documentURL");
        }

        public String getInitiatorType() {
            return (String)this.getInitiator().get((Object)"type");
        }

        public String getDocumentUrl() {
            return this.documentUrl;
        }

        public String getResponseType() {
            return this.responseType;
        }

        public JSONObject getInitiator() {
            return this.initiator;
        }

        public JSONObject getRequest() {
            return this.request;
        }

        private String getRequestId() {
            return this.requestId;
        }

        public JSONObject getResponse() {
            return this.response;
        }

        public int getResponseCode() {
            Number statusCode;
            if (this.response != null && (statusCode = (Number)this.response.get((Object)"status")) != null) {
                return statusCode.intValue();
            }
            return -1;
        }

        private void setResponse(JSONObject response) {
            this.response = (JSONObject)response.get((Object)"response");
            this.responseType = String.valueOf(response.get((Object)"type"));
            this.support.firePropertyChange(PROP_RESPONSE, null, null);
        }

        public String getResponseData() {
            if (!this.dataReady) {
                return null;
            }
            return this.network.getResponseBody(this.getRequestId());
        }

        private void dataLoadingStarted() {
            this.hasData = true;
        }

        private void requestCompleted() {
            if (this.hasData) {
                this.dataReady = true;
                this.support.firePropertyChange(PROP_RESPONSE_DATA, null, null);
            }
        }

        public boolean hasData() {
            return this.hasData;
        }

        public List<ConsoleMessage.StackFrame> getInitiatorCallStack() {
            JSONObject stackObj;
            JSONArray stack = (JSONArray)this.getInitiator().get((Object)"stackTrace");
            if (stack == null && (stackObj = (JSONObject)this.getInitiator().get((Object)"stack")) != null) {
                stack = (JSONArray)stackObj.get((Object)"callFrames");
            }
            if (stack != null && stack.size() > 0) {
                ArrayList<ConsoleMessage.StackFrame> stackTrace = new ArrayList<ConsoleMessage.StackFrame>();
                for (Object o : stack) {
                    JSONObject json = (JSONObject)o;
                    stackTrace.add(new ConsoleMessage.StackFrame(json));
                }
                return stackTrace;
            }
            return null;
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
            this.support.addPropertyChangeListener(l);
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
            this.support.removePropertyChangeListener(l);
        }

        private void setFailed(JSONObject params) {
            this.failed = true;
            this.support.firePropertyChange(PROP_RESPONSE, null, null);
        }

        public boolean isFailed() {
            return this.failed;
        }
    }

    public static interface Listener {
        public void networkRequest(Request var1);

        public void webSocketRequest(WebSocketRequest var1);
    }
}

