/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf;

import java.util.prefs.Preferences;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.web.jsf.wizards.JSFConfigurationPanel;

public final class JsfPreferences {
    private static final String PREFERRED_LANGUAGE = "jsf.language";
    private static final String JSF_PRESENT_PROPERTY = "jsf.present";
    private final Preferences preferences;

    private JsfPreferences(Preferences preferences) {
        this.preferences = preferences;
    }

    public static JsfPreferences forProject(Project project) {
        Preferences preferences = ProjectUtils.getPreferences((Project)project, ProjectUtils.class, (boolean)true);
        return new JsfPreferences(preferences);
    }

    public boolean isJsfPresent() {
        return this.preferences.get(JSF_PRESENT_PROPERTY, "").equals("true");
    }

    public void setJsfPresent(boolean value) {
        String valueToStore = value ? "true" : "false";
        this.preferences.put(JSF_PRESENT_PROPERTY, valueToStore);
    }

    public JSFConfigurationPanel.PreferredLanguage getPreferredLanguage() {
        String lang = this.preferences.get(PREFERRED_LANGUAGE, "");
        if (lang.isEmpty()) {
            return null;
        }
        for (JSFConfigurationPanel.PreferredLanguage preferredLanguage : JSFConfigurationPanel.PreferredLanguage.values()) {
            if (!preferredLanguage.getName().equals(lang)) continue;
            return preferredLanguage;
        }
        return null;
    }

    public void setPreferredLanguage(JSFConfigurationPanel.PreferredLanguage preferredLanguage) {
        if (preferredLanguage == null) {
            this.preferences.remove(PREFERRED_LANGUAGE);
        } else {
            this.preferences.put(PREFERRED_LANGUAGE, preferredLanguage.getName());
        }
    }
}

