/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.utils;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.tm4e.core.internal.grammar.parser.Raw;
import org.eclipse.tm4e.core.internal.types.IRawRepository;

public class CloneUtils {
    private CloneUtils() {
    }

    public static Object clone(Object value) {
        if (value instanceof Raw) {
            Raw rowToClone = (Raw)value;
            Raw raw = new Raw();
            for (Map.Entry entry : rowToClone.entrySet()) {
                raw.put((String)entry.getKey(), CloneUtils.clone(entry.getValue()));
            }
            return raw;
        }
        if (value instanceof List) {
            return ((List)value).stream().map(CloneUtils::clone).collect(Collectors.toList());
        }
        if (value instanceof String) {
            return value;
        }
        if (value instanceof Integer) {
            return value;
        }
        if (value instanceof Boolean) {
            return value;
        }
        return value;
    }

    public static IRawRepository mergeObjects(IRawRepository ... sources) {
        Raw target = new Raw();
        for (IRawRepository source : sources) {
            Set entries = ((Map)((Object)source)).entrySet();
            for (Map.Entry entry : entries) {
                target.put((String)entry.getKey(), entry.getValue());
            }
        }
        return target;
    }
}

