/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.api.support;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.apache.tools.ant.module.api.AntTargetExecutor;
import org.apache.tools.ant.module.api.support.AntScriptUtils;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.util.Parameters;

public final class ActionUtils {
    private ActionUtils() {
    }

    @NonNull
    public static ExecutorTask runTarget(@NonNull FileObject buildXml, @NullAllowed String[] targetNames, @NullAllowed Properties properties) throws IOException, IllegalArgumentException {
        return ActionUtils.runTarget(buildXml, targetNames, properties, null);
    }

    @NonNull
    public static ExecutorTask runTarget(@NonNull FileObject buildXml, @NullAllowed String[] targetNames, @NullAllowed Properties properties, @NullAllowed Set<String> concealedProperties) throws IOException, IllegalArgumentException {
        Parameters.notNull((CharSequence)"buildXml", (Object)buildXml);
        if (targetNames != null && targetNames.length == 0) {
            throw new IllegalArgumentException("No targets supplied");
        }
        AntProjectCookie apc = AntScriptUtils.antProjectCookieFor(buildXml);
        AntTargetExecutor.Env execenv = new AntTargetExecutor.Env();
        if (properties != null) {
            Properties p = execenv.getProperties();
            p.putAll((Map<?, ?>)properties);
            execenv.setProperties(p);
        }
        if (concealedProperties != null) {
            execenv.setConcealedProperties(concealedProperties);
        }
        return AntTargetExecutor.createTargetExecutor(execenv).execute(apc, targetNames);
    }

    public static FileObject[] findSelectedFiles(Lookup context, FileObject dir, String suffix, boolean strict) {
        if (dir != null && !dir.isFolder()) {
            throw new IllegalArgumentException("Not a folder: " + dir);
        }
        if (suffix != null && suffix.indexOf(47) != -1) {
            throw new IllegalArgumentException("Cannot includes slashes in suffix: " + suffix);
        }
        ArrayList<FileObject> candidates = context.lookupAll(FileObject.class);
        if (candidates.isEmpty()) {
            Collection compatibilityCandidates = context.lookupAll(DataObject.class);
            if (compatibilityCandidates.isEmpty()) {
                return null;
            }
            ArrayList<FileObject> _candidates = new ArrayList<FileObject>();
            for (DataObject d : compatibilityCandidates) {
                _candidates.add(d.getPrimaryFile());
            }
            candidates = _candidates;
        }
        LinkedHashSet<FileObject> files = new LinkedHashSet<FileObject>();
        for (FileObject f : candidates) {
            boolean matches;
            if (f.hasExt("form")) continue;
            boolean bl = matches = FileUtil.toFile((FileObject)f) != null;
            if (dir != null) {
                matches &= FileUtil.isParentOf((FileObject)dir, (FileObject)f) || dir == f;
            }
            if (suffix != null) {
                matches &= f.getNameExt().endsWith(suffix);
            }
            if (matches) {
                files.add(f);
                continue;
            }
            if (!strict) continue;
            return null;
        }
        if (files.isEmpty()) {
            return null;
        }
        return files.toArray(new FileObject[files.size()]);
    }

    public static FileObject[] regexpMapFiles(FileObject[] fromFiles, FileObject fromDir, Pattern fromRx, FileObject toDir, String toSubst, boolean strict) throws IllegalArgumentException {
        ArrayList<FileObject> files = new ArrayList<FileObject>();
        for (FileObject fromFile : fromFiles) {
            FileObject target;
            String toPath;
            String path = FileUtil.getRelativePath((FileObject)fromDir, (FileObject)fromFile);
            if (path == null) {
                throw new IllegalArgumentException("The file " + fromFile + " is not in " + fromDir);
            }
            if (fromRx != null) {
                Matcher m = fromRx.matcher(path);
                toPath = m.replaceFirst(toSubst);
                if (toPath.equals(path) && !m.find(0)) {
                    if (!strict) continue;
                    return null;
                }
            } else {
                toPath = path;
            }
            if ((target = toDir.getFileObject(toPath)) == null) {
                if (!strict) continue;
                return null;
            }
            files.add(target);
        }
        return files.toArray(new FileObject[files.size()]);
    }

    public static String antIncludesList(FileObject[] files, FileObject dir) throws IllegalArgumentException {
        return ActionUtils.antIncludesList(files, dir, true);
    }

    public static String antIncludesList(FileObject[] files, FileObject dir, boolean recursive) throws IllegalArgumentException {
        Parameters.notNull((CharSequence)"files", (Object)files);
        Parameters.notNull((CharSequence)"dir", (Object)dir);
        if (!dir.isFolder()) {
            throw new IllegalArgumentException("Not a folder: " + dir);
        }
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < files.length; ++i) {
            String path = FileUtil.getRelativePath((FileObject)dir, (FileObject)files[i]);
            if (path == null) {
                throw new IllegalArgumentException("The file " + files[i] + " is not in " + dir);
            }
            if (i > 0) {
                b.append(',');
            }
            b.append(path);
            if (!files[i].isFolder()) continue;
            if (path.length() > 0) {
                b.append('/');
            }
            b.append('*');
            if (!recursive) continue;
            b.append('*');
        }
        return b.toString();
    }
}

