/*
 * Decompiled with CFR 0.152.
 */
package io.foojay.api.discoclient.util;

import io.foojay.api.discoclient.pkg.SemVer;
import io.foojay.api.discoclient.pkg.VersionNumber;
import io.foojay.api.discoclient.util.Comparison;
import io.foojay.api.discoclient.util.Error;
import io.foojay.api.discoclient.util.Helper;
import io.foojay.api.discoclient.util.SemVerParsingResult;
import java.util.List;
import java.util.Scanner;
import java.util.function.Predicate;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class SemVerParser {
    private static final Pattern SEM_VER_PATTERN = Pattern.compile("^(<|<=|>|>=|=)?v?([0-9]+)(\\.[0-9]+)?(\\.[0-9]+)?(\\.[0-9]+)?(\\.[0-9]+)?(\\.[0-9]+)?(-([0-9A-Za-z\\-]+(\\.[0-9A-Za-z\\-]+)*))?(\\+([0-9A-Za-z\\-]+(\\.[0-9A-Za-z\\-]+)*))?((<|<=|>|>=|=)?v?([0-9]+)(\\.[0-9]+)?(\\.[0-9]+)?(\\.[0-9]+)?(\\.[0-9]+)?(\\.[0-9]+)?(-([0-9A-Za-z\\-]+(\\.[0-9A-Za-z\\-]+)*))?(\\+([0-9A-Za-z\\-]+(\\.[0-9A-Za-z\\-]+)*))?)?$");

    public static SemVerParsingResult fromText(String text) {
        Error err1;
        String pre1;
        List results;
        String versionText1;
        SemVerParsingResult parsingResult = new SemVerParsingResult();
        String string = versionText1 = text.startsWith("1.") ? text.replace("1.", "") : text;
        if (versionText1.contains("_")) {
            versionText1 = versionText1.replace("_", ".");
        }
        if (versionText1.matches("[0-9]+u[0-9]+.*")) {
            versionText1 = versionText1.replace("u", ".0.");
        }
        try (Scanner s = new Scanner(versionText1);){
            results = Helper.findAll(s, SEM_VER_PATTERN).collect(Collectors.toList());
        }
        if (results.isEmpty()) {
            parsingResult.setError1(new Error("Invalid semver: " + versionText1));
            return parsingResult;
        }
        MatchResult result = (MatchResult)results.get(0);
        String metadata1 = null != result.group(12) ? result.group(12) : "";
        String string2 = pre1 = null != result.group(9) ? result.group(9) : "";
        if (pre1.equals("ea.0")) {
            pre1 = "ea";
        }
        VersionNumber versionNumber1 = new VersionNumber();
        Comparison comparison1 = null == result.group(1) ? Comparison.EQUAL : Comparison.fromText(result.group(1));
        try {
            if (null == result.group(2)) {
                parsingResult.setError1(new Error("Feature version cannot be null"));
                return parsingResult;
            }
            versionNumber1.setFeature(Integer.parseInt(result.group(2)));
        }
        catch (NumberFormatException e) {
            parsingResult.setError1(new Error("Error when parsing feature version " + result.group(2) + ": " + e));
            return parsingResult;
        }
        try {
            if (null == result.group(3)) {
                versionNumber1.setInterim(0);
            } else {
                versionNumber1.setInterim(Integer.parseInt(Helper.trimPrefix(result.group(3), "\\.")));
            }
        }
        catch (NumberFormatException e) {
            parsingResult.setError1(new Error("Error when parsing interim version " + result.group(3) + ": " + e));
            return parsingResult;
        }
        try {
            if (null == result.group(4)) {
                versionNumber1.setUpdate(0);
            } else {
                versionNumber1.setUpdate(Integer.parseInt(Helper.trimPrefix(result.group(4), "\\.")));
            }
        }
        catch (NumberFormatException e) {
            parsingResult.setError1(new Error("Error when parsing update version " + result.group(4) + ": " + e));
            return parsingResult;
        }
        try {
            if (null == result.group(5)) {
                versionNumber1.setPatch(0);
            } else {
                versionNumber1.setPatch(Integer.parseInt(Helper.trimPrefix(result.group(5), "\\.")));
            }
        }
        catch (NumberFormatException e) {
            parsingResult.setError1(new Error("Error when parsing patch version " + result.group(5) + ": " + e));
            return parsingResult;
        }
        try {
            if (null == result.group(6)) {
                versionNumber1.setFifth(0);
            } else {
                versionNumber1.setFifth(Integer.parseInt(Helper.trimPrefix(result.group(6), "\\.")));
            }
        }
        catch (NumberFormatException e) {
            parsingResult.setError1(new Error("Error when parsing fifth number " + result.group(6) + ": " + e));
            return parsingResult;
        }
        try {
            if (null == result.group(7)) {
                versionNumber1.setSixth(0);
            } else {
                versionNumber1.setSixth(Integer.parseInt(Helper.trimPrefix(result.group(7), "\\.")));
            }
        }
        catch (NumberFormatException e) {
            parsingResult.setError1(new Error("Error when parsing sixth number " + result.group(7) + ": " + e));
            return parsingResult;
        }
        if (null != pre1 && !pre1.isEmpty() && null != (err1 = SemVerParser.validatePrerelease(pre1))) {
            parsingResult.setError1(err1);
            return parsingResult;
        }
        if (null != metadata1 && !metadata1.isEmpty() && null != (err1 = SemVerParser.validateMetadata(metadata1))) {
            parsingResult.setError1(err1);
            return parsingResult;
        }
        SemVer semVer1 = new SemVer(versionNumber1, pre1, metadata1);
        semVer1.setComparison(comparison1);
        parsingResult.setSemVer1(semVer1);
        Predicate<SemVer> filter = null;
        if (result.groupCount() == 27 && null != result.group(14)) {
            Error err2;
            boolean oldFormat;
            String pre2;
            String metadata2 = null != result.group(26) ? result.group(26) : "";
            String string3 = pre2 = null != result.group(23) ? result.group(23) : "";
            if (pre2.equals("ea.0")) {
                pre2 = "ea";
            }
            VersionNumber versionNumber2 = new VersionNumber();
            Comparison comparison2 = null == result.group(15) ? Comparison.EQUAL : Comparison.fromText(result.group(15));
            try {
                if (null == result.group(16)) {
                    parsingResult.setError2(new Error("Feature version cannot be null"));
                    return parsingResult;
                }
                oldFormat = Integer.parseInt(result.group(16)) == 1;
                versionNumber2.setFeature(Integer.parseInt(result.group(16)));
            }
            catch (NumberFormatException e) {
                parsingResult.setError2(new Error("Error when parsing feature version " + result.group(16) + ": " + e));
                return parsingResult;
            }
            try {
                if (null == result.group(17)) {
                    versionNumber2.setInterim(0);
                } else {
                    versionNumber2.setInterim(Integer.parseInt(Helper.trimPrefix(result.group(17), "\\.")));
                }
            }
            catch (NumberFormatException e) {
                parsingResult.setError2(new Error("Error when parsing interim version " + result.group(17) + ": " + e));
                return parsingResult;
            }
            try {
                if (null == result.group(18)) {
                    versionNumber2.setUpdate(0);
                } else {
                    versionNumber2.setUpdate(Integer.parseInt(Helper.trimPrefix(result.group(18), "\\.")));
                }
            }
            catch (NumberFormatException e) {
                parsingResult.setError2(new Error("Error when parsing update version " + result.group(18) + ": " + e));
                return parsingResult;
            }
            try {
                if (null == result.group(19)) {
                    versionNumber2.setPatch(0);
                } else {
                    versionNumber2.setPatch(Integer.parseInt(Helper.trimPrefix(result.group(19), "\\.")));
                }
            }
            catch (NumberFormatException e) {
                parsingResult.setError2(new Error("Error when parsing patch version " + result.group(19) + ": " + e));
                return parsingResult;
            }
            try {
                if (null == result.group(20)) {
                    versionNumber2.setFifth(0);
                } else {
                    versionNumber2.setFifth(Integer.parseInt(Helper.trimPrefix(result.group(20), "\\.")));
                }
            }
            catch (NumberFormatException e) {
                parsingResult.setError2(new Error("Error when parsing fifth number " + result.group(20) + ": " + e));
                return parsingResult;
            }
            try {
                if (null == result.group(21)) {
                    versionNumber2.setSixth(0);
                } else {
                    versionNumber2.setSixth(Integer.parseInt(Helper.trimPrefix(result.group(21), "\\.")));
                }
            }
            catch (NumberFormatException e) {
                parsingResult.setError2(new Error("Error when parsing sixth number " + result.group(21) + ": " + e));
                return parsingResult;
            }
            if (oldFormat) {
                versionNumber2.setFeature(versionNumber2.getInterim().getAsInt());
                versionNumber2.setInterim(versionNumber2.getUpdate().getAsInt());
                versionNumber2.setUpdate(versionNumber2.getPatch().getAsInt());
                versionNumber2.setPatch(0);
            }
            if (null != pre2 && !pre2.isEmpty() && null != (err2 = SemVerParser.validatePrerelease(pre2))) {
                parsingResult.setError2(err2);
                return parsingResult;
            }
            if (null != metadata2 && !metadata2.isEmpty() && null != (err2 = SemVerParser.validateMetadata(metadata2))) {
                parsingResult.setError2(err2);
                return parsingResult;
            }
            SemVer semVer2 = new SemVer(versionNumber2, pre2, metadata2);
            semVer2.setComparison(comparison2);
            block16 : switch (comparison1) {
                case LESS_THAN: {
                    filter = semVer -> semVer.lessThan(semVer1);
                    break;
                }
                case LESS_THAN_OR_EQUAL: {
                    filter = semVer -> semVer.lessThan(semVer1) || semVer.equalTo(semVer1);
                    break;
                }
                case GREATER_THAN: {
                    switch (comparison2) {
                        case LESS_THAN: {
                            filter = semVer -> semVer.greaterThan(semVer1) && semVer.lessThan(semVer2);
                            break block16;
                        }
                        case LESS_THAN_OR_EQUAL: {
                            filter = semVer -> semVer.greaterThan(semVer1) && (semVer.lessThan(semVer2) || semVer.equalTo(semVer2));
                            break block16;
                        }
                    }
                    filter = semVer -> semVer.greaterThan(semVer1);
                    break;
                }
                case GREATER_THAN_OR_EQUAL: {
                    switch (comparison2) {
                        case LESS_THAN: {
                            filter = semVer -> (semVer.equalTo(semVer1) || semVer.greaterThan(semVer1)) && semVer.lessThan(semVer2);
                            break block16;
                        }
                        case LESS_THAN_OR_EQUAL: {
                            filter = semVer -> !(!semVer.equalTo(semVer1) && !semVer.greaterThan(semVer1) || !semVer.lessThan(semVer2) && !semVer.equalTo(semVer2));
                            break block16;
                        }
                    }
                    filter = semVer -> semVer.equalTo(semVer1) || semVer.greaterThan(semVer1);
                }
            }
            parsingResult.setFilter(filter);
            parsingResult.setSemVer2(semVer2);
            return parsingResult;
        }
        switch (comparison1) {
            case LESS_THAN: {
                filter = semVer -> semVer.lessThan(semVer1);
                break;
            }
            case LESS_THAN_OR_EQUAL: {
                filter = semVer -> semVer.lessThan(semVer1) || semVer.equalTo(semVer1);
                break;
            }
            case GREATER_THAN: {
                filter = semVer -> semVer.greaterThan(semVer1);
                break;
            }
            case GREATER_THAN_OR_EQUAL: {
                filter = semVer -> semVer.equalTo(semVer1) || semVer.greaterThan(semVer1);
            }
        }
        parsingResult.setFilter(filter);
        return parsingResult;
    }

    private static Error validatePrerelease(String preRelease) {
        String[] eparts;
        for (String p : eparts = preRelease.split("\\.")) {
            if (p.matches("[0-9]+")) {
                if (p.length() <= 0 || !p.startsWith("0")) continue;
                return new Error("Segment starts with 0: " + p);
            }
            if (p.matches("[a-zA-Z-0-9]+")) continue;
            return new Error("Invalid preRelease: " + preRelease);
        }
        return null;
    }

    private static Error validateMetadata(String metadata) {
        String[] eparts;
        for (String p : eparts = metadata.split("\\.")) {
            if (p.matches("[a-zA-Z-0-9]+")) continue;
            return new Error("Invalid metadata: " + metadata);
        }
        return null;
    }
}

