/*
 * Decompiled with CFR 0.152.
 */
package io.foojay.api.discoclient.pkg;

import io.foojay.api.discoclient.pkg.ApiFeature;
import java.util.Arrays;
import java.util.List;

public enum TermOfSupport implements ApiFeature
{
    STS("short term stable", "sts"),
    MTS("mid term stable", "mts"),
    LTS("long term stable", "lts"),
    NONE("-", ""),
    NOT_FOUND("", "");

    private final String uiString;
    private final String apiString;

    private TermOfSupport(String uiString, String apiString) {
        this.uiString = uiString;
        this.apiString = apiString;
    }

    @Override
    public String getUiString() {
        return this.uiString;
    }

    @Override
    public String getApiString() {
        return this.apiString;
    }

    @Override
    public TermOfSupport getDefault() {
        return NONE;
    }

    @Override
    public TermOfSupport getNotFound() {
        return NOT_FOUND;
    }

    public TermOfSupport[] getAll() {
        return TermOfSupport.values();
    }

    public static TermOfSupport fromText(String text) {
        switch (text) {
            case "long_term_stable": 
            case "LongTermStable": 
            case "lts": 
            case "LTS": 
            case "Lts": {
                return LTS;
            }
            case "mid_term_stable": 
            case "MidTermStable": 
            case "mts": 
            case "MTS": 
            case "Mts": {
                return MTS;
            }
            case "short_term_stable": 
            case "ShortTermStable": 
            case "sts": 
            case "STS": 
            case "Sts": {
                return STS;
            }
        }
        return NOT_FOUND;
    }

    public static List<TermOfSupport> getAsList() {
        return Arrays.asList(TermOfSupport.values());
    }
}

