/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jshell.tool;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jdk.jshell.SourceCodeAnalysis;
import org.netbeans.modules.jshell.tool.JShellTool;

class ContinuousCompletionProvider
implements JShellTool.CompletionProvider {
    static final BiPredicate<String, String> STARTSWITH_MATCHER = (word, input) -> word.startsWith((String)input);
    static final BiPredicate<String, String> PERFECT_MATCHER = (word, input) -> word.equals(input);
    private final Supplier<Map<String, JShellTool.CompletionProvider>> wordCompletionProviderSupplier;
    private final BiPredicate<String, String> matcher;

    ContinuousCompletionProvider(Map<String, JShellTool.CompletionProvider> wordCompletionProvider, BiPredicate<String, String> matcher) {
        this(() -> wordCompletionProvider, matcher);
    }

    ContinuousCompletionProvider(Supplier<Map<String, JShellTool.CompletionProvider>> wordCompletionProviderSupplier, BiPredicate<String, String> matcher) {
        this.wordCompletionProviderSupplier = wordCompletionProviderSupplier;
        this.matcher = matcher;
    }

    @Override
    public List<SourceCodeAnalysis.Suggestion> completionSuggestions(String input, int cursor, int[] anchor) {
        Stream<SourceCodeAnalysis.Suggestion> result;
        String prefix = input.substring(0, cursor);
        int space = prefix.indexOf(32);
        Map<String, JShellTool.CompletionProvider> wordCompletionProvider = this.wordCompletionProviderSupplier.get();
        if (space == -1) {
            result = wordCompletionProvider.keySet().stream().distinct().filter(key -> key.startsWith(prefix)).map(key -> new JShellTool.ArgSuggestion(key + " "));
            anchor[0] = 0;
        } else {
            String rest = prefix.substring(space + 1);
            String word = prefix.substring(0, space);
            List candidates = wordCompletionProvider.entrySet().stream().filter(e -> this.matcher.test((String)e.getKey(), word)).map(Map.Entry::getValue).collect(Collectors.toList());
            result = candidates.size() == 1 ? ((JShellTool.CompletionProvider)candidates.get(0)).completionSuggestions(rest, cursor - space - 1, anchor).stream() : Stream.empty();
            anchor[0] = anchor[0] + (space + 1);
        }
        return result.sorted(Comparator.comparing(SourceCodeAnalysis.Suggestion::continuation)).collect(Collectors.toList());
    }
}

