/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.utils.system.launchers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.netbeans.installer.utils.FileUtils;
import org.netbeans.installer.utils.LogManager;
import org.netbeans.installer.utils.ResourceUtils;

public class LauncherResource {
    private Type type;
    private String path;
    private boolean resourceBased;

    public LauncherResource(File file) {
        this(true, file);
    }

    public LauncherResource(boolean bundled, File file) {
        this.type = bundled ? Type.BUNDLED : Type.ABSOLUTE;
        this.path = file.getPath();
    }

    public LauncherResource(Type type, String path) {
        this.type = type;
        this.path = path;
    }

    public LauncherResource(String resourceURI) {
        this.type = Type.BUNDLED;
        this.path = resourceURI;
        this.resourceBased = true;
    }

    public Type getPathType() {
        return this.type;
    }

    public boolean isBundled() {
        return this.type.equals((Object)Type.BUNDLED);
    }

    public String getPath() {
        return this.path;
    }

    public boolean isBasedOnResource() {
        return this.resourceBased;
    }

    public InputStream getInputStream() {
        if (this.isBundled()) {
            if (this.resourceBased) {
                return ResourceUtils.getResource(this.path);
            }
            File f = new File(this.getPath());
            if (FileUtils.exists(f)) {
                try {
                    return new FileInputStream(f);
                }
                catch (FileNotFoundException ex) {
                    LogManager.log(ex);
                }
            }
            return null;
        }
        return null;
    }

    public String getAbsolutePath() {
        return this.type.getPathString(this.path);
    }

    public long getSize() {
        if (this.isBundled()) {
            return this.isBasedOnResource() ? ResourceUtils.getResourceSize(this.path) : FileUtils.getSize(new File(this.path));
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMD5() {
        InputStream is = this.getInputStream();
        String md5 = null;
        if (is != null) {
            try {
                md5 = FileUtils.getMd5(is);
            }
            catch (IOException e) {
                LogManager.log(e);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException e) {
                    LogManager.log(e);
                }
            }
        }
        return md5;
    }

    public static enum Type {
        BUNDLED,
        ABSOLUTE,
        RELATIVE_JAVAHOME,
        RELATIVE_USERHOME,
        RELATIVE_LAUNCHER_PARENT,
        RELATIVE_LAUNCHER_TMPDIR;


        public long toLong() {
            switch (this) {
                case BUNDLED: {
                    return 0L;
                }
                case ABSOLUTE: {
                    return 1L;
                }
                case RELATIVE_JAVAHOME: {
                    return 2L;
                }
                case RELATIVE_USERHOME: {
                    return 3L;
                }
                case RELATIVE_LAUNCHER_PARENT: {
                    return 4L;
                }
                case RELATIVE_LAUNCHER_TMPDIR: {
                    return 5L;
                }
            }
            return 1L;
        }

        public String toString() {
            switch (this) {
                case BUNDLED: {
                    return "nbi.launcher.tmp.dir";
                }
                case ABSOLUTE: {
                    return "";
                }
                case RELATIVE_JAVAHOME: {
                    return "nbi.launcher.java.home";
                }
                case RELATIVE_USERHOME: {
                    return "nbi.launcher.user.home";
                }
                case RELATIVE_LAUNCHER_PARENT: {
                    return "nbi.launcher.parent.dir";
                }
                case RELATIVE_LAUNCHER_TMPDIR: {
                    return "nbi.launcher.tmp.dir";
                }
            }
            return null;
        }

        public String getPathString(String path) {
            if (this.equals((Object)ABSOLUTE)) {
                return path;
            }
            if (this.equals((Object)BUNDLED)) {
                return "$L{" + BUNDLED.toString() + "}/" + new File(path).getName();
            }
            return "$L{" + this.toString() + "}/" + path;
        }
    }
}

