/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.binary;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.binary.JSUnsignedRightShiftConstantNode;
import com.oracle.truffle.js.nodes.cast.JSToNumericNode;
import com.oracle.truffle.js.nodes.cast.JSToUInt32Node;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.SafeInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=JSUnsignedRightShiftConstantNode.class)
public final class JSUnsignedRightShiftConstantNodeGen
extends JSUnsignedRightShiftConstantNode
implements Introspection.Provider {
    @CompilerDirectives.CompilationFinal
    private volatile int state_;
    @Node.Child
    private JSToUInt32Node double_toUInt32Node_;
    @Node.Child
    private JSToNumericNode generic_leftToNumeric_;
    @Node.Child
    private JSUnsignedRightShiftConstantNode generic_innerShiftNode_;

    private JSUnsignedRightShiftConstantNodeGen(JavaScriptNode operand, int shiftValue, int rightValue) {
        super(operand, shiftValue, rightValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue, Object operandNodeValue) {
        int state = this.state_;
        if ((state & 1) != 0 && operandNodeValue instanceof Integer) {
            int operandNodeValue_ = (Integer)operandNodeValue;
            return this.doInteger(operandNodeValue_);
        }
        if ((state & 2) != 0 && operandNodeValue instanceof SafeInteger) {
            SafeInteger operandNodeValue_ = (SafeInteger)operandNodeValue;
            return this.doSafeInteger(operandNodeValue_);
        }
        if ((state & 4) != 0 && JSTypesGen.isImplicitDouble((state & 0x1E0) >>> 5, operandNodeValue)) {
            double operandNodeValue_ = JSTypesGen.asImplicitDouble((state & 0x1E0) >>> 5, operandNodeValue);
            return this.doDouble(operandNodeValue_, this.double_toUInt32Node_);
        }
        if ((state & 8) != 0 && operandNodeValue instanceof BigInt) {
            BigInt operandNodeValue_ = (BigInt)operandNodeValue;
            return this.doBigInt(operandNodeValue_);
        }
        if ((state & 0x10) != 0 && !JSUnsignedRightShiftConstantNode.isHandled(operandNodeValue)) {
            return this.doGeneric(operandNodeValue, this.generic_leftToNumeric_, this.generic_innerShiftNode_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(operandNodeValue);
    }

    @Override
    public int executeInt(Object operandNodeValue) {
        int state = this.state_;
        if ((state & 1) != 0 && operandNodeValue instanceof Integer) {
            int operandNodeValue_ = (Integer)operandNodeValue;
            return this.doInteger(operandNodeValue_);
        }
        if ((state & 2) != 0 && operandNodeValue instanceof SafeInteger) {
            SafeInteger operandNodeValue_ = (SafeInteger)operandNodeValue;
            return this.doSafeInteger(operandNodeValue_);
        }
        if ((state & 4) != 0 && JSTypesGen.isImplicitDouble((state & 0x1E0) >>> 5, operandNodeValue)) {
            double operandNodeValue_ = JSTypesGen.asImplicitDouble((state & 0x1E0) >>> 5, operandNodeValue);
            return this.doDouble(operandNodeValue_, this.double_toUInt32Node_);
        }
        if ((state & 8) != 0 && operandNodeValue instanceof BigInt) {
            BigInt operandNodeValue_ = (BigInt)operandNodeValue;
            return this.doBigInt(operandNodeValue_);
        }
        if ((state & 0x10) != 0 && !JSUnsignedRightShiftConstantNode.isHandled(operandNodeValue)) {
            return this.doGeneric(operandNodeValue, this.generic_leftToNumeric_, this.generic_innerShiftNode_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(operandNodeValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        int state = this.state_;
        if ((state & 0x1E) == 0 && (state & 0x1F) != 0) {
            return this.execute_int0(frameValue, state);
        }
        if ((state & 0x1B) == 0 && (state & 0x1F) != 0) {
            return this.execute_double1(frameValue, state);
        }
        return this.execute_generic2(frameValue, state);
    }

    private Object execute_int0(VirtualFrame frameValue, int state) {
        int operandNodeValue_;
        try {
            operandNodeValue_ = this.operandNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(ex.getResult());
        }
        assert ((state & 1) != 0);
        return this.doInteger(operandNodeValue_);
    }

    private Object execute_double1(VirtualFrame frameValue, int state) {
        double operandNodeValue_;
        int operandNodeValue_int = 0;
        long operandNodeValue_long = 0L;
        try {
            if ((state & 0x1C0) == 0 && (state & 0x1F) != 0) {
                operandNodeValue_long = this.operandNode.executeLong(frameValue);
                operandNodeValue_ = JSTypes.longToDouble(operandNodeValue_long);
            } else if ((state & 0x1A0) == 0 && (state & 0x1F) != 0) {
                operandNodeValue_int = this.operandNode.executeInt(frameValue);
                operandNodeValue_ = JSTypes.intToDouble(operandNodeValue_int);
            } else if ((state & 0x160) == 0 && (state & 0x1F) != 0) {
                operandNodeValue_ = this.operandNode.executeDouble(frameValue);
            } else {
                Object operandNodeValue__ = this.operandNode.execute(frameValue);
                operandNodeValue_ = JSTypesGen.expectImplicitDouble((state & 0x1E0) >>> 5, operandNodeValue__);
            }
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(ex.getResult());
        }
        assert ((state & 4) != 0);
        return this.doDouble(operandNodeValue_, this.double_toUInt32Node_);
    }

    private Object execute_generic2(VirtualFrame frameValue, int state) {
        Object operandNodeValue_ = this.operandNode.execute(frameValue);
        if ((state & 1) != 0 && operandNodeValue_ instanceof Integer) {
            int operandNodeValue__ = (Integer)operandNodeValue_;
            return this.doInteger(operandNodeValue__);
        }
        if ((state & 2) != 0 && operandNodeValue_ instanceof SafeInteger) {
            SafeInteger operandNodeValue__ = (SafeInteger)operandNodeValue_;
            return this.doSafeInteger(operandNodeValue__);
        }
        if ((state & 4) != 0 && JSTypesGen.isImplicitDouble((state & 0x1E0) >>> 5, operandNodeValue_)) {
            double operandNodeValue__ = JSTypesGen.asImplicitDouble((state & 0x1E0) >>> 5, operandNodeValue_);
            return this.doDouble(operandNodeValue__, this.double_toUInt32Node_);
        }
        if ((state & 8) != 0 && operandNodeValue_ instanceof BigInt) {
            BigInt operandNodeValue__ = (BigInt)operandNodeValue_;
            return this.doBigInt(operandNodeValue__);
        }
        if ((state & 0x10) != 0 && !JSUnsignedRightShiftConstantNode.isHandled(operandNodeValue_)) {
            return this.doGeneric(operandNodeValue_, this.generic_leftToNumeric_, this.generic_innerShiftNode_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(operandNodeValue_);
    }

    @Override
    public int executeInt(VirtualFrame frameValue) {
        int state = this.state_;
        if ((state & 0x1E) == 0 && (state & 0x1F) != 0) {
            return this.executeInt_int3(frameValue, state);
        }
        if ((state & 0x1B) == 0 && (state & 0x1F) != 0) {
            return this.executeInt_double4(frameValue, state);
        }
        return this.executeInt_generic5(frameValue, state);
    }

    private int executeInt_int3(VirtualFrame frameValue, int state) {
        int operandNodeValue_;
        try {
            operandNodeValue_ = this.operandNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(ex.getResult());
        }
        assert ((state & 1) != 0);
        return this.doInteger(operandNodeValue_);
    }

    private int executeInt_double4(VirtualFrame frameValue, int state) {
        double operandNodeValue_;
        int operandNodeValue_int = 0;
        long operandNodeValue_long = 0L;
        try {
            if ((state & 0x1C0) == 0 && (state & 0x1F) != 0) {
                operandNodeValue_long = this.operandNode.executeLong(frameValue);
                operandNodeValue_ = JSTypes.longToDouble(operandNodeValue_long);
            } else if ((state & 0x1A0) == 0 && (state & 0x1F) != 0) {
                operandNodeValue_int = this.operandNode.executeInt(frameValue);
                operandNodeValue_ = JSTypes.intToDouble(operandNodeValue_int);
            } else if ((state & 0x160) == 0 && (state & 0x1F) != 0) {
                operandNodeValue_ = this.operandNode.executeDouble(frameValue);
            } else {
                Object operandNodeValue__ = this.operandNode.execute(frameValue);
                operandNodeValue_ = JSTypesGen.expectImplicitDouble((state & 0x1E0) >>> 5, operandNodeValue__);
            }
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(ex.getResult());
        }
        assert ((state & 4) != 0);
        return this.doDouble(operandNodeValue_, this.double_toUInt32Node_);
    }

    private int executeInt_generic5(VirtualFrame frameValue, int state) {
        Object operandNodeValue_ = this.operandNode.execute(frameValue);
        if ((state & 1) != 0 && operandNodeValue_ instanceof Integer) {
            int operandNodeValue__ = (Integer)operandNodeValue_;
            return this.doInteger(operandNodeValue__);
        }
        if ((state & 2) != 0 && operandNodeValue_ instanceof SafeInteger) {
            SafeInteger operandNodeValue__ = (SafeInteger)operandNodeValue_;
            return this.doSafeInteger(operandNodeValue__);
        }
        if ((state & 4) != 0 && JSTypesGen.isImplicitDouble((state & 0x1E0) >>> 5, operandNodeValue_)) {
            double operandNodeValue__ = JSTypesGen.asImplicitDouble((state & 0x1E0) >>> 5, operandNodeValue_);
            return this.doDouble(operandNodeValue__, this.double_toUInt32Node_);
        }
        if ((state & 8) != 0 && operandNodeValue_ instanceof BigInt) {
            BigInt operandNodeValue__ = (BigInt)operandNodeValue_;
            return this.doBigInt(operandNodeValue__);
        }
        if ((state & 0x10) != 0 && !JSUnsignedRightShiftConstantNode.isHandled(operandNodeValue_)) {
            return this.doGeneric(operandNodeValue_, this.generic_leftToNumeric_, this.generic_innerShiftNode_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(operandNodeValue_);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.executeInt(frameValue);
    }

    private int executeAndSpecialize(Object operandNodeValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        try {
            if (operandNodeValue instanceof Integer) {
                int operandNodeValue_ = (Integer)operandNodeValue;
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                int n = this.doInteger(operandNodeValue_);
                return n;
            }
            if (operandNodeValue instanceof SafeInteger) {
                SafeInteger operandNodeValue_ = (SafeInteger)operandNodeValue;
                this.state_ = state |= 2;
                lock.unlock();
                hasLock = false;
                int n = this.doSafeInteger(operandNodeValue_);
                return n;
            }
            int doubleCast0 = JSTypesGen.specializeImplicitDouble(operandNodeValue);
            if (doubleCast0 != 0) {
                double operandNodeValue_ = JSTypesGen.asImplicitDouble(doubleCast0, operandNodeValue);
                this.double_toUInt32Node_ = (JSToUInt32Node)super.insert((Node)JSToUInt32Node.create());
                state |= doubleCast0 << 5;
                this.state_ = state |= 4;
                lock.unlock();
                hasLock = false;
                int n = this.doDouble(operandNodeValue_, this.double_toUInt32Node_);
                return n;
            }
            if (operandNodeValue instanceof BigInt) {
                BigInt operandNodeValue_ = (BigInt)operandNodeValue;
                this.state_ = state |= 8;
                lock.unlock();
                hasLock = false;
                int n = this.doBigInt(operandNodeValue_);
                return n;
            }
            if (!JSUnsignedRightShiftConstantNode.isHandled(operandNodeValue)) {
                this.generic_leftToNumeric_ = (JSToNumericNode)super.insert((Node)JSToNumericNode.create());
                this.generic_innerShiftNode_ = (JSUnsignedRightShiftConstantNode)super.insert((Node)this.createInner());
                this.state_ = state |= 0x10;
                lock.unlock();
                hasLock = false;
                int n = this.doGeneric(operandNodeValue, this.generic_leftToNumeric_, this.generic_innerShiftNode_);
                return n;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.operandNode}, new Object[]{operandNodeValue});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if ((state & 0x1F) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & 0x1F & (state & 0x1F) - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public Introspection getIntrospectionData() {
        ArrayList<List<JavaScriptBaseNode>> cached;
        Object[] data = new Object[6];
        data[0] = 0;
        int state = this.state_;
        Object[] s = new Object[3];
        s[0] = "doInteger";
        s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[1] = s;
        s = new Object[3];
        s[0] = "doSafeInteger";
        s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[2] = s;
        s = new Object[3];
        s[0] = "doDouble";
        if ((state & 4) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList<List<JavaScriptBaseNode>>();
            cached.add(Arrays.asList(this.double_toUInt32Node_));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[3] = s;
        s = new Object[3];
        s[0] = "doBigInt";
        s[1] = (state & 8) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[4] = s;
        s = new Object[3];
        s[0] = "doGeneric";
        if ((state & 0x10) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(new JavaScriptBaseNode[]{this.generic_leftToNumeric_, this.generic_innerShiftNode_}));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[5] = s;
        return Introspection.Provider.create((Object[])data);
    }

    public static JSUnsignedRightShiftConstantNode create(JavaScriptNode operand, int shiftValue, int rightValue) {
        return new JSUnsignedRightShiftConstantNodeGen(operand, shiftValue, rightValue);
    }
}

