/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.welcome.content;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.welcome.content.Constants;
import org.netbeans.modules.welcome.content.Utils;

public class ContentSection
extends JPanel
implements Constants {
    private static final int PANEL_MAX_WIDTH = 800;
    private boolean maxSize;

    public ContentSection(String title, JComponent content, boolean maxSize) {
        this(content, maxSize, 0);
        JLabel lblTitle = new JLabel(title);
        lblTitle.setFont(SECTION_HEADER_FONT);
        lblTitle.setBorder(BorderFactory.createEmptyBorder(0, 0, 20, 0));
        lblTitle.setForeground(Utils.getColor("SectionHeaderColor"));
        this.add((Component)lblTitle, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 0, 0, 0), 0, 0));
    }

    public ContentSection(JComponent titleComponent, JComponent content, boolean maxSize) {
        this(content, maxSize, 8);
        if (null != titleComponent) {
            this.add((Component)titleComponent, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 15, 0), 0, 0));
        }
    }

    public ContentSection(JComponent content, boolean maxSize) {
        this(content, maxSize, 0);
    }

    private ContentSection(JComponent content, boolean maxSize, int leftInsets) {
        super(new GridBagLayout());
        this.setOpaque(false);
        this.maxSize = maxSize;
        this.add((Component)content, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, leftInsets, 0, 0), 0, 0));
        this.setBorder(BorderFactory.createEmptyBorder(22, 35, 15, 35));
    }

    @Override
    public void setSize(Dimension d) {
        if (this.maxSize && d.width > 800) {
            d = new Dimension(d);
            d.width = 800;
        }
        super.setSize(d);
    }

    @Override
    public void setBounds(Rectangle r) {
        if (this.maxSize && r.width > 800) {
            r = new Rectangle(r);
            r.width = 800;
        }
        super.setBounds(r);
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        if (this.maxSize && w > 800) {
            w = 800;
        }
        super.setBounds(x, y, w, h);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        if (this.maxSize && d.width > 800) {
            d = new Dimension(d);
            d.width = 800;
        }
        return d;
    }
}

