/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.welcome;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.prefs.Preferences;
import org.netbeans.modules.welcome.content.Constants;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class WelcomeOptions {
    private static WelcomeOptions theInstance;
    private static final String PROP_SHOW_ON_STARTUP = "showOnStartup";
    private static final String PROP_LAST_ACTIVE_TAB = "lastActiveTab";
    private static final String PROP_START_COUNTER = "startCounter";
    private PropertyChangeSupport propSupport;

    private WelcomeOptions() {
    }

    private Preferences prefs() {
        return NbPreferences.forModule(WelcomeOptions.class);
    }

    public static synchronized WelcomeOptions getDefault() {
        if (null == theInstance) {
            theInstance = new WelcomeOptions();
        }
        return theInstance;
    }

    public void setShowOnStartup(boolean show) {
        boolean oldVal = this.isShowOnStartup();
        if (oldVal == show) {
            return;
        }
        this.prefs().putBoolean(PROP_SHOW_ON_STARTUP, show);
        if (null != this.propSupport) {
            this.propSupport.firePropertyChange(PROP_SHOW_ON_STARTUP, oldVal, show);
        }
        LogRecord rec = new LogRecord(Level.INFO, "USG_SHOW_START_PAGE");
        rec.setParameters(new Object[]{show});
        rec.setLoggerName(Constants.USAGE_LOGGER.getName());
        rec.setResourceBundle(NbBundle.getBundle((String)"org.netbeans.modules.welcome.resources.Bundle"));
        rec.setResourceBundleName("org.netbeans.modules.welcome.resources.Bundle");
        Constants.USAGE_LOGGER.log(rec);
    }

    public boolean isShowOnStartup() {
        return this.prefs().getBoolean(PROP_SHOW_ON_STARTUP, !Boolean.getBoolean("netbeans.full.hack"));
    }

    public void setLastActiveTab(int tabIndex) {
        int oldVal = this.getLastActiveTab();
        this.prefs().putInt(PROP_LAST_ACTIVE_TAB, tabIndex);
        if (null != this.propSupport) {
            this.propSupport.firePropertyChange(PROP_LAST_ACTIVE_TAB, oldVal, tabIndex);
        }
    }

    public int getLastActiveTab() {
        return this.prefs().getInt(PROP_LAST_ACTIVE_TAB, -1);
    }

    public boolean isSecondStart() {
        return this.prefs().getInt(PROP_START_COUNTER, -1) == 2;
    }

    public void incrementStartCounter() {
        int count = this.prefs().getInt(PROP_START_COUNTER, 0) + 1;
        if (count > 3) {
            return;
        }
        this.prefs().putInt(PROP_START_COUNTER, count);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (null == this.propSupport) {
            this.propSupport = new PropertyChangeSupport(this);
        }
        this.propSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (null == this.propSupport) {
            return;
        }
        this.propSupport.removePropertyChangeListener(l);
    }
}

