/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.wizards;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.MutableComboBoxModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.php.project.api.PhpOptions;
import org.netbeans.modules.php.project.connections.ConfigManager;
import org.netbeans.modules.php.project.environment.PhpEnvironment;
import org.netbeans.modules.php.project.runconfigs.RunConfigInternal;
import org.netbeans.modules.php.project.runconfigs.RunConfigLocal;
import org.netbeans.modules.php.project.runconfigs.RunConfigRemote;
import org.netbeans.modules.php.project.runconfigs.validation.BaseRunConfigValidator;
import org.netbeans.modules.php.project.runconfigs.validation.RunConfigInternalValidator;
import org.netbeans.modules.php.project.runconfigs.validation.RunConfigLocalValidator;
import org.netbeans.modules.php.project.runconfigs.validation.RunConfigRemoteValidator;
import org.netbeans.modules.php.project.runconfigs.validation.RunConfigScriptValidator;
import org.netbeans.modules.php.project.ui.LocalServer;
import org.netbeans.modules.php.project.ui.SourcesFolderProvider;
import org.netbeans.modules.php.project.ui.Utils;
import org.netbeans.modules.php.project.ui.customizer.PhpProjectProperties;
import org.netbeans.modules.php.project.ui.customizer.RunAsPanel;
import org.netbeans.modules.php.project.ui.wizards.CancelablePanel;
import org.netbeans.modules.php.project.ui.wizards.ConfigureProjectPanel;
import org.netbeans.modules.php.project.ui.wizards.NewPhpProjectWizardIterator;
import org.netbeans.modules.php.project.ui.wizards.RunAsInternalServer;
import org.netbeans.modules.php.project.ui.wizards.RunAsLocalWeb;
import org.netbeans.modules.php.project.ui.wizards.RunAsRemoteWeb;
import org.netbeans.modules.php.project.ui.wizards.RunAsScript;
import org.netbeans.modules.php.project.ui.wizards.RunConfigurationPanelVisual;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class RunConfigurationPanel
implements WizardDescriptor.Panel<WizardDescriptor>,
WizardDescriptor.FinishablePanel<WizardDescriptor>,
ChangeListener,
CancelablePanel {
    static final String VALID = "RunConfigurationPanel.valid";
    static final String RUN_AS = "run.as";
    static final String URL = "url";
    static final String INDEX_FILE = "indexFile";
    static final String DEFAULT_INDEX_FILE = "index.php";
    static final String COPY_SRC_FILES = "copySrcFiles";
    static final String COPY_SRC_TARGET = "copySrcTarget";
    static final String COPY_SRC_TARGETS = "copySrcTargets";
    static final String COPY_SRC_ON_OPEN = "copySrcOnOpen";
    static final String REMOTE_CONNECTION = "remoteConnection";
    static final String REMOTE_DIRECTORY = "remoteDirectory";
    static final String REMOTE_UPLOAD = "remoteUpload";
    static final String HOSTNAME = "hostname";
    static final String PORT = "port";
    static final String ROUTER = "router";
    static final String[] CFG_PROPS = new String[]{"run.as", "url", "indexFile", "remoteConnection", "remoteDirectory", "remoteUpload", "hostname", "port", "router"};
    private final String[] steps;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private final SourcesFolderProvider sourcesFolderProvider;
    private final NewPhpProjectWizardIterator.WizardType wizardType;
    private WizardDescriptor descriptor = null;
    private PropertyChangeListener phpInterpreterListener;
    private ConfigManager configManager;
    private RunConfigurationPanelVisual runConfigurationPanelVisual = null;
    private RunAsLocalWeb runAsLocalWeb = null;
    private RunAsRemoteWeb runAsRemoteWeb = null;
    private RunAsScript runAsScript = null;
    private RunAsInternalServer runAsInternalServer = null;
    private String defaultLocalUrl = null;
    private String originalProjectName = null;
    private volatile boolean readingDocumentRoots = false;
    private volatile boolean canceled;

    public RunConfigurationPanel(String[] steps, SourcesFolderProvider sourcesFolderProvider, NewPhpProjectWizardIterator.WizardType wizardType) {
        this.sourcesFolderProvider = sourcesFolderProvider;
        this.steps = (String[])steps.clone();
        this.wizardType = wizardType;
    }

    String[] getSteps() {
        return this.steps;
    }

    public Component getComponent() {
        if (this.runConfigurationPanelVisual == null) {
            this.configManager = new ConfigManager(new WizardConfigProvider());
            this.runAsLocalWeb = new RunAsLocalWeb(this.configManager, this.sourcesFolderProvider);
            this.runAsRemoteWeb = new RunAsRemoteWeb(this.configManager, this.sourcesFolderProvider);
            this.runAsScript = new RunAsScript(this.configManager, this.sourcesFolderProvider);
            this.runAsInternalServer = new RunAsInternalServer(this.configManager, this.sourcesFolderProvider);
            switch (this.wizardType) {
                case NEW: {
                    this.runAsLocalWeb.setIndexFile(DEFAULT_INDEX_FILE);
                    this.runAsRemoteWeb.setIndexFile(DEFAULT_INDEX_FILE);
                    this.runAsScript.setIndexFile(DEFAULT_INDEX_FILE);
                    this.runAsLocalWeb.hideIndexFile();
                    this.runAsRemoteWeb.hideIndexFile();
                    this.runAsScript.hideIndexFile();
                    this.runAsInternalServer.hideRouter();
                    break;
                }
                case REMOTE: {
                    this.runAsRemoteWeb.setIndexFile(DEFAULT_INDEX_FILE);
                    this.runAsRemoteWeb.setUploadFiles(PhpProjectProperties.UploadFiles.ON_SAVE);
                    this.runAsRemoteWeb.hideRunAs();
                    this.runAsRemoteWeb.hideIndexFile();
                    this.runAsRemoteWeb.hideUploadFiles();
                    break;
                }
                case EXISTING: {
                    break;
                }
                default: {
                    assert (false) : "Unknown wizard type: " + (Object)((Object)this.wizardType);
                    break;
                }
            }
            RunAsPanel.InsidePanel[] insidePanels = null;
            switch (this.wizardType) {
                case NEW: 
                case EXISTING: {
                    insidePanels = new RunAsPanel.InsidePanel[]{this.runAsLocalWeb, this.runAsRemoteWeb, this.runAsScript, this.runAsInternalServer};
                    break;
                }
                case REMOTE: {
                    insidePanels = new RunAsPanel.InsidePanel[]{this.runAsRemoteWeb};
                    break;
                }
                default: {
                    assert (false) : "Unknown wizard type: " + (Object)((Object)this.wizardType);
                    break;
                }
            }
            this.runConfigurationPanelVisual = new RunConfigurationPanelVisual(this, this.sourcesFolderProvider, this.configManager, insidePanels);
            this.phpInterpreterListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("propPhpInterpreter".equals(evt.getPropertyName())) {
                        RunConfigurationPanel.this.runAsScript.loadPhpInterpreter();
                    }
                }
            };
            PhpOptions phpOptions = PhpOptions.getInstance();
            phpOptions.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.phpInterpreterListener, (Object)phpOptions));
            this.addListeners();
        }
        return this.runConfigurationPanelVisual;
    }

    public HelpCtx getHelp() {
        return new HelpCtx(RunConfigurationPanel.class.getName() + "." + (Object)((Object)this.wizardType));
    }

    public void readSettings(WizardDescriptor settings) {
        this.getComponent();
        this.descriptor = settings;
        switch (this.wizardType) {
            case EXISTING: {
                this.findIndexFile();
                break;
            }
            case REMOTE: {
                this.setUrl();
                break;
            }
            case NEW: {
                break;
            }
            default: {
                assert (false) : "Unknown wizard type: " + (Object)((Object)this.wizardType);
                break;
            }
        }
        MutableComboBoxModel<LocalServer> localServerModel = this.getLocalServerModel();
        if (localServerModel != null) {
            this.runAsLocalWeb.setLocalServerModel(localServerModel);
        } else {
            this.runAsLocalWeb.setLocalServerModel(new LocalServer.ComboBoxModel(LocalServer.PENDING_LOCAL_SERVER));
            this.readingDocumentRoots = true;
            this.runAsLocalWeb.setCopyFilesState(false);
            this.canceled = false;
            PhpEnvironment.get().readDocumentRoots(new PhpEnvironment.ReadDocumentRootsNotifier(){

                @Override
                public void finished(final List<PhpEnvironment.DocumentRoot> documentRoots) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            RunConfigurationPanel.this.initLocalServerModel(documentRoots);
                        }
                    });
                }
            });
        }
        this.runAsLocalWeb.setCopyFiles(this.getCopyFiles());
        this.runAsLocalWeb.setCopyFilesOnOpen(this.getCopyFilesOnOpen());
        this.runAsRemoteWeb.setUploadDirectory(this.getUploadDirectory());
        this.runAsInternalServer.setHostname(this.getHostname());
        this.runAsInternalServer.setPort(this.getPort());
    }

    public void storeSettings(WizardDescriptor settings) {
        this.getComponent();
        for (String s : CFG_PROPS) {
            settings.putProperty(s, null);
        }
        PhpProjectProperties.RunAsType runAs = this.getRunAsType();
        settings.putProperty(RUN_AS, (Object)runAs);
        settings.putProperty(COPY_SRC_FILES, (Object)this.runAsLocalWeb.isCopyFiles());
        settings.putProperty(COPY_SRC_TARGET, (Object)this.runAsLocalWeb.getLocalServer());
        settings.putProperty(COPY_SRC_TARGETS, this.runAsLocalWeb.getLocalServerModel());
        settings.putProperty(COPY_SRC_ON_OPEN, (Object)this.runAsLocalWeb.isCopyFilesOnOpen());
        switch (runAs) {
            case LOCAL: {
                this.storeRunAsLocalWeb(settings);
                break;
            }
            case REMOTE: {
                this.storeRunAsRemoteWeb(settings);
                break;
            }
            case SCRIPT: {
                this.storeRunAsScript(settings);
                break;
            }
            case INTERNAL: {
                this.storeRunAsInternalServer(settings);
                break;
            }
            default: {
                assert (false) : "Unhandled RunAsType type: " + (Object)((Object)runAs);
                break;
            }
        }
    }

    private MutableComboBoxModel<LocalServer> getLocalServerModel() {
        return (MutableComboBoxModel)this.descriptor.getProperty(COPY_SRC_TARGETS);
    }

    void initLocalServerModel(List<PhpEnvironment.DocumentRoot> documentRoots) {
        if (this.canceled) {
            return;
        }
        int size = documentRoots.size();
        ArrayList<LocalServer> localServers = new ArrayList<LocalServer>(size);
        LocalServer selected = null;
        for (PhpEnvironment.DocumentRoot root : documentRoots) {
            String srcRoot = new File(root.getDocumentRoot(), this.sourcesFolderProvider.getSourcesFolderName()).getAbsolutePath();
            LocalServer ls = new LocalServer(null, root.getUrl(), root.getDocumentRoot(), srcRoot, true);
            localServers.add(ls);
            if (selected != null) continue;
            selected = ls;
        }
        LocalServer.ComboBoxModel model = new LocalServer.ComboBoxModel(localServers.toArray(new LocalServer[localServers.size()]));
        if (selected != null) {
            model.setSelectedItem(selected);
            this.descriptor.putProperty(COPY_SRC_TARGET, selected);
        }
        this.descriptor.putProperty(COPY_SRC_TARGETS, (Object)model);
        this.runAsLocalWeb.setLocalServerModel(model);
        this.runAsLocalWeb.setCopyFilesState(true);
        this.readingDocumentRoots = false;
        this.fireChangeEvent();
    }

    private boolean getCopyFiles() {
        Boolean copyFiles = (Boolean)this.descriptor.getProperty(COPY_SRC_FILES);
        if (copyFiles != null) {
            return copyFiles;
        }
        return false;
    }

    private boolean getCopyFilesOnOpen() {
        Boolean copyFilesOnOpen = (Boolean)this.descriptor.getProperty(COPY_SRC_ON_OPEN);
        if (copyFilesOnOpen != null) {
            return copyFilesOnOpen;
        }
        return false;
    }

    private String getUploadDirectory() {
        String uploadDirectory = (String)this.descriptor.getProperty(REMOTE_DIRECTORY);
        if (uploadDirectory != null) {
            return uploadDirectory;
        }
        return "/" + this.getProjectName();
    }

    private String getHostname() {
        String hostname = (String)this.descriptor.getProperty(HOSTNAME);
        if (hostname != null) {
            return hostname;
        }
        return "localhost";
    }

    private String getPort() {
        String port = (String)this.descriptor.getProperty(PORT);
        if (port != null) {
            return port;
        }
        return String.valueOf(8000);
    }

    private void findIndexFile() {
        FileObject fo;
        String indexFile = (String)this.descriptor.getProperty(INDEX_FILE);
        if ((indexFile == null || indexFile.length() == 0) && (fo = FileUtil.toFileObject((File)this.sourcesFolderProvider.getSourcesFolder()).getFileObject(DEFAULT_INDEX_FILE)) != null && fo.isValid()) {
            this.runAsLocalWeb.setIndexFile(DEFAULT_INDEX_FILE);
            this.runAsRemoteWeb.setIndexFile(DEFAULT_INDEX_FILE);
            this.runAsScript.setIndexFile(DEFAULT_INDEX_FILE);
        }
    }

    private void storeRunAsLocalWeb(WizardDescriptor settings) {
        RunConfigLocal config = this.runAsLocalWeb.createRunConfig();
        settings.putProperty(URL, (Object)config.getUrl());
        settings.putProperty(INDEX_FILE, (Object)config.getIndexRelativePath());
    }

    private void storeRunAsRemoteWeb(WizardDescriptor settings) {
        RunConfigRemote config = this.runAsRemoteWeb.createRunConfig();
        settings.putProperty(URL, (Object)config.getUrl());
        settings.putProperty(INDEX_FILE, (Object)config.getIndexRelativePath());
        settings.putProperty(REMOTE_CONNECTION, (Object)config.getRemoteConfiguration());
        settings.putProperty(REMOTE_DIRECTORY, (Object)config.getSanitizedUploadDirectory());
        settings.putProperty(REMOTE_UPLOAD, (Object)config.getUploadFilesType());
    }

    private void storeRunAsScript(WizardDescriptor settings) {
        settings.putProperty(INDEX_FILE, (Object)this.runAsScript.createRunConfig().getIndexRelativePath());
    }

    private void storeRunAsInternalServer(WizardDescriptor settings) {
        RunConfigInternal config = this.runAsInternalServer.createRunConfig();
        settings.putProperty(URL, (Object)config.getUrlHint());
        settings.putProperty(HOSTNAME, (Object)config.getHostname());
        settings.putProperty(PORT, (Object)config.getPort());
        settings.putProperty(ROUTER, (Object)config.getRouterRelativePath());
    }

    public boolean isValid() {
        this.getComponent();
        this.descriptor.putProperty("WizardPanel_errorMessage", (Object)" ");
        String error = null;
        String indexFile = null;
        switch (this.getRunAsType()) {
            case LOCAL: {
                if (this.readingDocumentRoots) {
                    this.descriptor.putProperty(VALID, (Object)false);
                    return false;
                }
                error = this.validateRunAsLocalWeb();
                indexFile = this.runAsLocalWeb.createRunConfig().getIndexRelativePath();
                break;
            }
            case REMOTE: {
                error = this.validateRunAsRemoteWeb();
                indexFile = this.runAsRemoteWeb.createRunConfig().getIndexRelativePath();
                break;
            }
            case SCRIPT: {
                error = this.validateRunAsScript();
                indexFile = this.runAsScript.createRunConfig().getIndexRelativePath();
                break;
            }
            case INTERNAL: {
                error = this.validateRunAsInternalServer();
                indexFile = null;
                break;
            }
            default: {
                assert (false) : "Unhandled RunAsType type: " + (Object)((Object)this.getRunAsType());
                break;
            }
        }
        if (error != null) {
            this.descriptor.putProperty("WizardPanel_errorMessage", (Object)error);
            this.descriptor.putProperty(VALID, (Object)false);
            return false;
        }
        String warning = null;
        if (indexFile != null) {
            warning = BaseRunConfigValidator.validateIndexFile(this.sourcesFolderProvider.getSourcesFolder(), indexFile);
        }
        if (this.wizardType == NewPhpProjectWizardIterator.WizardType.EXISTING && warning != null) {
            this.descriptor.putProperty("WizardPanel_warningMessage", (Object)warning);
        } else {
            this.validateAsciiTexts();
        }
        this.descriptor.putProperty(VALID, (Object)true);
        return true;
    }

    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    public boolean isFinishPanel() {
        switch (this.wizardType) {
            case REMOTE: {
                return false;
            }
        }
        return NewPhpProjectWizardIterator.areAllStepsValid(this.descriptor);
    }

    final void fireChangeEvent() {
        this.changeSupport.fireChange();
    }

    private void addListeners() {
        this.runAsLocalWeb.addRunAsLocalWebListener(this);
        this.runAsRemoteWeb.addRunAsRemoteWebListener(this);
        this.runAsScript.addRunAsScriptListener(this);
        this.runAsInternalServer.addRunAsInternalServerListener(this);
    }

    private PhpProjectProperties.RunAsType getRunAsType() {
        String runAs = this.configManager.currentConfiguration().getValue(RUN_AS);
        if (runAs == null) {
            switch (this.wizardType) {
                case REMOTE: {
                    return PhpProjectProperties.RunAsType.REMOTE;
                }
            }
            return PhpProjectProperties.RunAsType.LOCAL;
        }
        return PhpProjectProperties.RunAsType.valueOf(runAs);
    }

    private String validateRunAsLocalWeb() {
        String error = RunConfigLocalValidator.validateNewProject(this.runAsLocalWeb.createRunConfig());
        if (error != null) {
            return error;
        }
        error = this.validateServerLocation();
        if (error != null) {
            return error;
        }
        return null;
    }

    private String validateRunAsRemoteWeb() {
        return RunConfigRemoteValidator.validateNewProject(this.runAsRemoteWeb.createRunConfig());
    }

    private String validateRunAsScript() {
        return RunConfigScriptValidator.validateNewProject(this.runAsScript.createRunConfig());
    }

    private String validateRunAsInternalServer() {
        return RunConfigInternalValidator.validateNewProject(this.runAsInternalServer.createRunConfig());
    }

    private String validateServerLocation() {
        if (!this.runAsLocalWeb.isCopyFiles()) {
            return null;
        }
        LocalServer copyTarget = this.runAsLocalWeb.getLocalServer();
        String sourcesLocation = copyTarget.getSrcRoot();
        File sources = FileUtil.normalizeFile((File)new File(sourcesLocation));
        if (!Utils.isValidFileName(sources)) {
            return NbBundle.getMessage(RunConfigurationPanel.class, (String)"MSG_IllegalFolderName");
        }
        String err = Utils.validateProjectDirectory(sourcesLocation, "Folder", false, true);
        if (err != null) {
            return err;
        }
        err = this.validateSourcesAndCopyTarget();
        if (err != null) {
            return err;
        }
        String url = this.runAsLocalWeb.createRunConfig().getUrl();
        String warning = NbBundle.getMessage(RunConfigurationPanel.class, (String)"MSG_TargetFolderVisible", (Object)url);
        this.descriptor.putProperty("WizardPanel_errorMessage", (Object)warning);
        return null;
    }

    private String validateSourcesAndCopyTarget() {
        LocalServer sources = (LocalServer)this.descriptor.getProperty("sourcesFolder");
        assert (sources != null);
        String sourcesSrcRoot = sources.getSrcRoot();
        File normalized = FileUtil.normalizeFile((File)new File(this.runAsLocalWeb.getLocalServer().getSrcRoot()));
        String copyTarget = normalized.getAbsolutePath();
        return Utils.validateSourcesAndCopyTarget(sourcesSrcRoot, copyTarget);
    }

    private void validateAsciiTexts() {
        String url = null;
        String indexFile = null;
        switch (this.getRunAsType()) {
            case LOCAL: {
                RunConfigLocal configLocal = this.runAsLocalWeb.createRunConfig();
                url = configLocal.getUrl();
                indexFile = configLocal.getIndexRelativePath();
                break;
            }
            case REMOTE: {
                RunConfigRemote configRemote = this.runAsRemoteWeb.createRunConfig();
                url = configRemote.getUrl();
                indexFile = configRemote.getIndexRelativePath();
                break;
            }
            case SCRIPT: {
                return;
            }
            case INTERNAL: {
                RunConfigInternal configInternal = this.runAsInternalServer.createRunConfig();
                url = configInternal.getUrlHint();
            }
        }
        String warning = Utils.validateAsciiText(url, NbBundle.getMessage(ConfigureProjectPanel.class, (String)"LBL_ProjectUrlPure"));
        if (warning != null) {
            this.descriptor.putProperty("WizardPanel_warningMessage", (Object)warning);
            return;
        }
        warning = Utils.validateAsciiText(indexFile, NbBundle.getMessage(ConfigureProjectPanel.class, (String)"LBL_IndexFilePure"));
        if (warning != null) {
            this.descriptor.putProperty("WizardPanel_warningMessage", (Object)warning);
            return;
        }
    }

    private void adjustUrl() {
        String currentUrl = this.runAsLocalWeb.createRunConfig().getUrl();
        if (this.defaultLocalUrl == null) {
            this.defaultLocalUrl = currentUrl;
        }
        if (!this.defaultLocalUrl.equals(currentUrl)) {
            return;
        }
        String url = null;
        if (this.runAsLocalWeb.isCopyFiles()) {
            LocalServer ls = this.runAsLocalWeb.getLocalServer();
            String documentRoot = ls.getDocumentRoot();
            assert (documentRoot != null);
            String srcRoot = ls.getSrcRoot();
            String urlSuffix = RunConfigurationPanel.getUrlSuffix(documentRoot, srcRoot);
            if (urlSuffix == null) {
                urlSuffix = new File(srcRoot).getName();
            }
            String urlPrefix = ls.getUrl() != null ? ls.getUrl() : "http://localhost/";
            url = urlPrefix + urlSuffix;
        } else {
            url = RunConfigurationPanel.getUrlForSources(this.wizardType, this.descriptor);
        }
        if (url != null && !url.endsWith("/")) {
            url = url + "/";
        }
        if (url != null && !this.defaultLocalUrl.equals(url)) {
            this.defaultLocalUrl = url;
            this.runAsLocalWeb.setUrl(url);
        }
    }

    static String getUrlForSources(NewPhpProjectWizardIterator.WizardType wizardType, WizardDescriptor descriptor) {
        String url = null;
        LocalServer sources = (LocalServer)descriptor.getProperty("sourcesFolder");
        assert (sources != null);
        String srcRoot = sources.getSrcRoot();
        block0 : switch (wizardType) {
            case NEW: {
                List srcRoots = (List)descriptor.getProperty("roots");
                assert (srcRoots != null);
                for (PhpEnvironment.DocumentRoot root : srcRoots) {
                    String urlSuffix = RunConfigurationPanel.getUrlSuffix(root.getDocumentRoot(), srcRoot);
                    if (urlSuffix == null) continue;
                    url = root.getUrl() + urlSuffix;
                    break block0;
                }
                break;
            }
        }
        if (url == null) {
            url = "http://localhost/" + new File(srcRoot).getName();
        }
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        return url;
    }

    private static String getUrlSuffix(String documentRoot, String srcRoot) {
        if (!documentRoot.endsWith(File.separator)) {
            documentRoot = documentRoot + File.separator;
        }
        if (!srcRoot.startsWith(documentRoot)) {
            return null;
        }
        srcRoot = srcRoot.replaceAll(Pattern.quote(File.separator) + "+", "/");
        return srcRoot.substring(documentRoot.length());
    }

    private void adjustUploadDirectoryAndCopyFiles() {
        if (this.originalProjectName == null) {
            this.originalProjectName = this.getProjectName();
            return;
        }
        String newProjectName = this.getProjectName();
        if (newProjectName.equals(this.originalProjectName)) {
            return;
        }
        this.adjustUploadDirectory(this.originalProjectName, newProjectName);
        this.adjustCopyFiles(this.originalProjectName, newProjectName);
        this.originalProjectName = newProjectName;
    }

    private String getProjectName() {
        return (String)this.descriptor.getProperty("projectName");
    }

    private void adjustUploadDirectory(String originalProjectName, String newProjectName) {
        String uploadDirectory = this.runAsRemoteWeb.createRunConfig().getUploadDirectory();
        if (!uploadDirectory.equals("/" + originalProjectName)) {
            return;
        }
        this.runAsRemoteWeb.setUploadDirectory("/" + newProjectName);
    }

    private void adjustCopyFiles(String originalProjectName, String projectName) {
        LocalServer.ComboBoxModel model = (LocalServer.ComboBoxModel)this.runAsLocalWeb.getLocalServerModel();
        boolean fire = false;
        for (int i = 0; i < model.getSize(); ++i) {
            LocalServer ls = model.getElementAt(i);
            File src = new File(ls.getSrcRoot());
            if (!originalProjectName.equals(src.getName())) continue;
            File newSrc = new File(src.getParentFile(), projectName);
            ls.setSrcRoot(newSrc.getAbsolutePath());
            fire = true;
        }
        if (fire) {
            model.fireContentsChanged();
            this.runAsLocalWeb.setCopyFiles(this.runAsLocalWeb.isCopyFiles());
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        switch (this.getRunAsType()) {
            case LOCAL: {
                this.adjustUrl();
                this.adjustUploadDirectoryAndCopyFiles();
                break;
            }
            case REMOTE: {
                this.adjustUploadDirectoryAndCopyFiles();
                break;
            }
            case SCRIPT: 
            case INTERNAL: {
                break;
            }
            default: {
                assert (false) : "Unknown run type: " + (Object)((Object)this.getRunAsType());
                break;
            }
        }
        this.fireChangeEvent();
    }

    @Override
    public void cancel() {
        this.canceled = true;
    }

    private void setUrl() {
        assert (this.wizardType == NewPhpProjectWizardIterator.WizardType.REMOTE);
        if (this.descriptor.getProperty(URL) == null) {
            this.runAsRemoteWeb.setUrl("http://");
        }
    }

    private static final class WizardConfigProvider
    implements ConfigManager.ConfigProvider {
        final Map<String, Map<String, String>> configs = ConfigManager.createEmptyConfigs();

        public WizardConfigProvider() {
            this.configs.put(null, new HashMap());
        }

        @Override
        public String[] getConfigProperties() {
            return CFG_PROPS;
        }

        @Override
        public Map<String, Map<String, String>> getConfigs() {
            return this.configs;
        }
    }
}

