/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.project.Bundle;
import org.netbeans.modules.php.project.UpdateHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public final class SourceRoots {
    public static final String PROP_ROOTS = SourceRoots.class.getName() + ".roots";
    private final UpdateHelper helper;
    private final PropertyEvaluator evaluator;
    private final String displayName;
    private final String propertyNumericPrefix;
    private final PropertyChangeSupport support;
    private final ProjectMetadataListener listener;
    private final boolean tests;
    private final AtomicLong firedChanges = new AtomicLong();
    private List<FileObject> sourceRoots;
    private List<URL> sourceRootUrls;
    private List<String> sourceRootProperties;
    private List<String> pureSourceRootNames;

    private SourceRoots(Builder builder) {
        assert (builder.helper != null);
        assert (builder.evaluator != null);
        assert (builder.displayName != null);
        this.helper = builder.helper;
        this.evaluator = builder.evaluator;
        this.displayName = builder.displayName;
        this.propertyNumericPrefix = builder.propertyNumericPrefix;
        this.tests = builder.tests;
        this.sourceRootProperties = builder.properties;
        this.support = new PropertyChangeSupport(this);
        this.listener = new ProjectMetadataListener();
    }

    static SourceRoots create(Builder builder) {
        SourceRoots roots = new SourceRoots(builder);
        roots.evaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)roots.listener, (Object)roots.evaluator));
        return roots;
    }

    public String[] getRootNames() {
        String[] pureRootNames = this.getPureRootNames();
        if (pureRootNames.length == 0) {
            return new String[0];
        }
        String[] names = new String[pureRootNames.length];
        for (int i = 0; i < names.length; ++i) {
            String pureName = pureRootNames[i];
            String name = StringUtils.hasText((String)pureName) ? Bundle.SourceRoots_displayName(this.displayName, pureName) : this.displayName;
            names[i] = name;
        }
        return names;
    }

    public synchronized String[] getPureRootNames() {
        return (String[])ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<String[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public String[] run() {
                SourceRoots sourceRoots = SourceRoots.this;
                synchronized (sourceRoots) {
                    assert (Thread.holdsLock(SourceRoots.this));
                    if (SourceRoots.this.pureSourceRootNames == null) {
                        ArrayList<String> dirPaths = new ArrayList<String>();
                        for (String property : SourceRoots.this.getRootProperties()) {
                            String path = SourceRoots.this.evaluator.getProperty(property);
                            if (path == null) {
                                dirPaths.add(null);
                                continue;
                            }
                            dirPaths.add(SourceRoots.this.helper.getAntProjectHelper().resolvePath(path));
                        }
                        SourceRoots.this.pureSourceRootNames = SourceRoots.getPureSourceRootsNames(dirPaths);
                    }
                    return SourceRoots.this.pureSourceRootNames.toArray(new String[SourceRoots.this.pureSourceRootNames.size()]);
                }
            }
        });
    }

    public String[] getRootProperties() {
        return (String[])ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<String[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public String[] run() {
                SourceRoots sourceRoots = SourceRoots.this;
                synchronized (sourceRoots) {
                    assert (Thread.holdsLock(SourceRoots.this));
                    if (SourceRoots.this.sourceRootProperties == null) {
                        assert (SourceRoots.this.propertyNumericPrefix != null) : SourceRoots.access$600(SourceRoots.this);
                        SourceRoots.this.sourceRootProperties = new ArrayList();
                        EditableProperties projectProperties = SourceRoots.this.helper.getProperties("nbproject/project.properties");
                        if (projectProperties.containsKey((Object)SourceRoots.this.propertyNumericPrefix)) {
                            SourceRoots.this.sourceRootProperties.add(SourceRoots.this.propertyNumericPrefix);
                        }
                        int i = 1;
                        while (true) {
                            String key;
                            if (projectProperties.containsKey((Object)(key = SourceRoots.this.propertyNumericPrefix + i))) {
                                SourceRoots.this.sourceRootProperties.add(key);
                            } else if (i > 1) break;
                            ++i;
                        }
                    }
                    return SourceRoots.this.sourceRootProperties.toArray(new String[SourceRoots.this.sourceRootProperties.size()]);
                }
            }
        });
    }

    public FileObject[] getRoots() {
        return (FileObject[])ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<FileObject[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public FileObject[] run() {
                SourceRoots sourceRoots = SourceRoots.this;
                synchronized (sourceRoots) {
                    assert (Thread.holdsLock(SourceRoots.this));
                    if (SourceRoots.this.sourceRoots == null) {
                        String[] srcProps = SourceRoots.this.getRootProperties();
                        ArrayList<FileObject> result = new ArrayList<FileObject>();
                        for (String p : srcProps) {
                            FileObject f;
                            String prop = SourceRoots.this.evaluator.getProperty(p);
                            if (prop == null || (f = SourceRoots.this.helper.getAntProjectHelper().resolveFileObject(prop)) == null) continue;
                            if (FileUtil.isArchiveFile((FileObject)f)) {
                                f = FileUtil.getArchiveRoot((FileObject)f);
                            }
                            result.add(f);
                        }
                        SourceRoots.this.sourceRoots = Collections.unmodifiableList(result);
                    }
                    return SourceRoots.this.sourceRoots.toArray(new FileObject[SourceRoots.this.sourceRoots.size()]);
                }
            }
        });
    }

    public URL[] getRootURLs() {
        return (URL[])ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<URL[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public URL[] run() {
                SourceRoots sourceRoots = SourceRoots.this;
                synchronized (sourceRoots) {
                    assert (Thread.holdsLock(SourceRoots.this));
                    if (SourceRoots.this.sourceRootUrls == null) {
                        ArrayList<URL> result = new ArrayList<URL>();
                        for (String srcProp : SourceRoots.this.getRootProperties()) {
                            String prop = SourceRoots.this.evaluator.getProperty(srcProp);
                            if (prop == null) continue;
                            File f = FileUtil.normalizeFile((File)SourceRoots.this.helper.getAntProjectHelper().resolveFile(prop));
                            try {
                                URL url = Utilities.toURI((File)f).toURL();
                                if (!f.exists()) {
                                    url = new URL(url.toExternalForm() + "/");
                                } else if (f.isFile()) continue;
                                assert (url.toExternalForm().endsWith("/")) : "#90639 violation for " + url + "; " + f + " exists? " + f.exists() + " dir? " + f.isDirectory() + " file? " + f.isFile();
                                result.add(url);
                            }
                            catch (MalformedURLException e) {
                                Exceptions.printStackTrace((Throwable)e);
                            }
                        }
                        SourceRoots.this.sourceRootUrls = Collections.unmodifiableList(result);
                    }
                    return SourceRoots.this.sourceRootUrls.toArray(new URL[SourceRoots.this.sourceRootUrls.size()]);
                }
            }
        });
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public String getRootDisplayName(String rootName, String propName) {
        assert (StringUtils.hasText((String)rootName)) : "No name for " + propName;
        return rootName;
    }

    public boolean isTest() {
        return this.tests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetCache(String propName) {
        boolean fire = false;
        SourceRoots sourceRoots = this;
        synchronized (sourceRoots) {
            assert (Thread.holdsLock(this));
            if (propName == null || this.sourceRootProperties != null && this.sourceRootProperties.contains(propName) || this.propertyNumericPrefix != null && propName.startsWith(this.propertyNumericPrefix)) {
                this.sourceRoots = null;
                this.sourceRootUrls = null;
                if (this.propertyNumericPrefix != null) {
                    this.sourceRootProperties = null;
                }
                this.pureSourceRootNames = null;
                fire = true;
            }
        }
        if (fire) {
            this.firedChanges.incrementAndGet();
            this.support.firePropertyChange(PROP_ROOTS, null, null);
        }
    }

    public void refresh() {
        this.resetCache(null);
    }

    public long getFiredChanges() {
        return this.firedChanges.get();
    }

    static List<String> getPureSourceRootsNames(List<String> dirPaths) {
        if (dirPaths.isEmpty()) {
            return Collections.emptyList();
        }
        if (dirPaths.size() == 1) {
            return Collections.singletonList("");
        }
        if (SourceRoots.checkIncorrectValues(dirPaths)) {
            ArrayList<String> names = new ArrayList<String>(dirPaths.size());
            for (String path : dirPaths) {
                if (path == null) {
                    names.add("");
                    continue;
                }
                names.add(path);
            }
            return names;
        }
        String[] names = new String[dirPaths.size()];
        int lastIndex = 0;
        ArrayList<Integer> duplicated = new ArrayList<Integer>(dirPaths.size());
        while (true) {
            duplicated.clear();
            for (int i = 0; i < dirPaths.size(); ++i) {
                if (names[i] != null) continue;
                String path = dirPaths.get(i);
                if (path == null) {
                    names[i] = "";
                    continue;
                }
                List segments = StringUtils.explode((String)path, (String)File.separator);
                int index = segments.size() - 1 - lastIndex;
                if (index < 0) {
                    index = 0;
                }
                String name = index >= segments.size() ? "???" : (String)segments.get(index);
                int indexOf = Arrays.asList(names).indexOf(name);
                if (indexOf != -1 && indexOf != i) {
                    duplicated.add(indexOf);
                    continue;
                }
                names[i] = name;
            }
            for (Integer index : duplicated) {
                names[index.intValue()] = null;
            }
            boolean finished = true;
            for (String name : names) {
                if (name != null) continue;
                finished = false;
                break;
            }
            if (finished) break;
            ++lastIndex;
        }
        return Arrays.asList(names);
    }

    private static boolean checkIncorrectValues(List<String> dirPaths) {
        ArrayList<String> copy = new ArrayList<String>(dirPaths);
        copy.removeAll(Collections.singleton(null));
        return new HashSet<String>(copy).size() != copy.size();
    }

    static /* synthetic */ String access$600(SourceRoots x0) {
        return x0.displayName;
    }

    private final class ProjectMetadataListener
    implements PropertyChangeListener {
        private ProjectMetadataListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            SourceRoots.this.resetCache(evt.getPropertyName());
        }
    }

    public static final class Builder {
        final UpdateHelper helper;
        final PropertyEvaluator evaluator;
        final String displayName;
        List<String> properties;
        String propertyNumericPrefix;
        boolean tests;

        Builder(UpdateHelper helper, PropertyEvaluator evaluator, String displayName) {
            this.helper = helper;
            this.evaluator = evaluator;
            this.displayName = displayName;
        }

        public Builder setProperties(List<String> properties) {
            this.properties = properties;
            return this;
        }

        public Builder setProperties(String ... properties) {
            this.properties = Arrays.asList(properties);
            return this;
        }

        public Builder setPropertyNumericPrefix(String propertyNumericPrefix) {
            this.propertyNumericPrefix = propertyNumericPrefix;
            return this;
        }

        public Builder setTests(boolean tests) {
            this.tests = tests;
            return this;
        }

        public SourceRoots build() {
            assert (this.properties != null || this.propertyNumericPrefix != null);
            return SourceRoots.create(this);
        }

        public static Builder create(UpdateHelper helper, PropertyEvaluator evaluator, String displayName) {
            assert (helper != null);
            assert (evaluator != null);
            return new Builder(helper, evaluator, displayName);
        }
    }
}

