/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.installer.ui;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.prefs.Preferences;
import javax.swing.JToggleButton;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.apisupport.installer.ui.LicenseComboBoxModel;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class SuiteInstallerProjectProperties {
    public static final String GENERATE_FOR_WINDOWS = "os-windows";
    public static final String GENERATE_FOR_LINUX = "os-linux";
    public static final String GENERATE_FOR_SOLARIS = "os-solaris";
    public static final String GENERATE_FOR_MAC = "os-macosx";
    public static final String LICENSE_TYPE = "license-type";
    public static final String LICENSE_TYPE_NO = "no";
    public static final String LICENSE_TYPE_FILE = "file";
    public static final String LICENSE_TYPE_CUSTOM = "custom";
    public static final String LICENSE_FILE = "license-file";
    private final Project suiteProject;
    final JToggleButton.ToggleButtonModel windowsModel;
    final JToggleButton.ToggleButtonModel linuxModel;
    final JToggleButton.ToggleButtonModel solarisModel;
    final JToggleButton.ToggleButtonModel macModel;
    final LicenseComboBoxModel licenseModel;

    public SuiteInstallerProjectProperties(Project suiteProject) {
        int index;
        this.suiteProject = suiteProject;
        Preferences prefs = SuiteInstallerProjectProperties.prefs(suiteProject);
        this.windowsModel = new JToggleButton.ToggleButtonModel();
        this.windowsModel.setSelected(prefs.getBoolean(GENERATE_FOR_WINDOWS, Utilities.isWindows()));
        this.linuxModel = new JToggleButton.ToggleButtonModel();
        this.linuxModel.setSelected(prefs.getBoolean(GENERATE_FOR_LINUX, Utilities.getOperatingSystem() == 16));
        this.solarisModel = new JToggleButton.ToggleButtonModel();
        this.solarisModel.setSelected(prefs.getBoolean(GENERATE_FOR_SOLARIS, Utilities.getOperatingSystem() == 8));
        this.macModel = new JToggleButton.ToggleButtonModel();
        this.macModel.setSelected(prefs.getBoolean(GENERATE_FOR_MAC, Utilities.isMac()));
        ResourceBundle rb = NbBundle.getBundle(SuiteInstallerProjectProperties.class);
        Enumeration<String> keys = rb.getKeys();
        String prefix = "SuiteInstallerProjectProperties.license.type.";
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<String> types = new ArrayList<String>();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            if (!key.startsWith(prefix)) continue;
            String type = key.substring(prefix.length());
            String value = NbBundle.getMessage(SuiteInstallerProjectProperties.class, (String)key);
            if (type.equals(LICENSE_TYPE_NO)) {
                names.add(0, value);
                types.add(0, type);
                continue;
            }
            names.add(value);
            types.add(type);
        }
        this.licenseModel = new LicenseComboBoxModel(suiteProject, names, types);
        String licenseFileName = prefs.get(LICENSE_FILE, null);
        String licenseType = prefs.get(LICENSE_TYPE, null);
        if (licenseFileName != null) {
            File licenseFile = new File(licenseFileName);
            if (!licenseFile.isAbsolute()) {
                licenseFile = PropertyUtils.resolveFile((File)FileUtil.toFile((FileObject)suiteProject.getProjectDirectory()), (String)licenseFileName);
            }
            this.licenseModel.getNames().add(licenseFile.getAbsolutePath());
            this.licenseModel.getTypes().add(LICENSE_TYPE_FILE);
            String name = this.licenseModel.getNames().get(this.licenseModel.getNames().size() - 1);
            this.licenseModel.setSelectedItem(name);
        } else if (licenseType != null && (index = this.licenseModel.getTypes().indexOf(licenseType)) != -1) {
            this.licenseModel.setSelectedItem(this.licenseModel.getNames().get(index));
        }
    }

    public void store() throws IOException {
        int index;
        Preferences prefs = SuiteInstallerProjectProperties.prefs(this.suiteProject);
        prefs.putBoolean(GENERATE_FOR_WINDOWS, this.windowsModel.isSelected());
        prefs.putBoolean(GENERATE_FOR_LINUX, this.linuxModel.isSelected());
        prefs.putBoolean(GENERATE_FOR_SOLARIS, this.solarisModel.isSelected());
        prefs.putBoolean(GENERATE_FOR_MAC, this.macModel.isSelected());
        String licenseName = (String)this.licenseModel.getSelectedItem();
        if (licenseName != null && (index = this.licenseModel.getNames().indexOf(licenseName)) != -1) {
            String type = this.licenseModel.getTypes().get(index);
            if (type.equals(LICENSE_TYPE_FILE)) {
                File f;
                File suiteLocation = FileUtil.toFile((FileObject)this.suiteProject.getProjectDirectory());
                String rel = PropertyUtils.relativizeFile((File)suiteLocation, (File)(f = PropertyUtils.resolveFile((File)suiteLocation, (String)licenseName)));
                if (rel != null) {
                    prefs.put(LICENSE_FILE, rel);
                } else {
                    prefs.put(LICENSE_FILE, f.getAbsolutePath());
                }
                prefs.remove(LICENSE_TYPE);
            } else {
                prefs.put(LICENSE_TYPE, type);
                prefs.remove(LICENSE_FILE);
            }
        }
    }

    public static Preferences prefs(Project suiteProject) {
        return ProjectUtils.getPreferences((Project)suiteProject, SuiteInstallerProjectProperties.class, (boolean)true);
    }
}

