/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.smarty.editor.completion;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Action;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.php.smarty.editor.completion.CodeCompletionUtils;
import org.netbeans.modules.php.smarty.editor.completion.TplCompletionItem;
import org.netbeans.modules.php.smarty.editor.completion.TplCompletionQuery;
import org.netbeans.spi.editor.completion.CompletionDocumentation;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.openide.util.Exceptions;

public class TplCompletionProvider
implements CompletionProvider {
    public int getAutoQueryTypes(JTextComponent component, String typedText) {
        return 0;
    }

    public CompletionTask createTask(int queryType, JTextComponent component) {
        AsyncCompletionTask task = null;
        if ((queryType & 1 & 9) != 0) {
            task = new AsyncCompletionTask((AsyncCompletionQuery)new Query(), component);
        }
        return task;
    }

    private static void checkHideCompletion(final BaseDocument doc, final int caretOffset) {
        doc.render(new Runnable(){

            @Override
            public void run() {
                TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)doc);
                TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
                tokenSequence.move(caretOffset == 0 ? 0 : caretOffset - 1);
                if (!tokenSequence.moveNext()) {
                    return;
                }
            }
        });
    }

    private static class DocItem
    implements CompletionDocumentation {
        TplCompletionItem item;

        public DocItem(TplCompletionItem tci) {
            this.item = tci;
        }

        public String getText() {
            return this.item.getHelp();
        }

        public URL getURL() {
            return this.item.getHelpURL();
        }

        public CompletionDocumentation resolveLink(String link) {
            return null;
        }

        public Action getGotoSourceAction() {
            return null;
        }
    }

    private static abstract class AbstractQuery
    extends AsyncCompletionQuery {
        private AbstractQuery() {
        }

        protected void preQueryUpdate(JTextComponent component) {
            TplCompletionProvider.checkHideCompletion((BaseDocument)component.getDocument(), component.getCaretPosition());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void query(CompletionResultSet resultSet, Document doc, int caretOffset) {
            try {
                this.doQuery(resultSet, doc, caretOffset);
            }
            finally {
                resultSet.finish();
            }
        }

        abstract void doQuery(CompletionResultSet var1, Document var2, int var3);
    }

    public static class DocQuery
    extends AbstractQuery {
        private CompletionItem item;

        public DocQuery(TplCompletionItem item) {
            this.item = item;
        }

        @Override
        protected void doQuery(CompletionResultSet resultSet, Document doc, int caretOffset) {
            TplCompletionItem tplItem;
            if (this.item == null) {
                try {
                    TplCompletionQuery.CompletionResult result = new TplCompletionQuery(doc).query();
                    if (result != null && result.getFunctions().size() > 0) {
                        this.item = result.getFunctions().iterator().next();
                    }
                }
                catch (ParseException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            if ((tplItem = (TplCompletionItem)this.item) != null && tplItem.getHelp() != null) {
                resultSet.setDocumentation((CompletionDocumentation)new DocItem(tplItem));
            }
        }
    }

    private static class Query
    extends AbstractQuery {
        private volatile Set<TplCompletionItem> items = new HashSet<TplCompletionItem>();
        private JTextComponent component;

        private Query() {
        }

        protected void prepareQuery(JTextComponent component) {
            this.component = component;
        }

        @Override
        protected void doQuery(CompletionResultSet resultSet, final Document doc, final int caretOffset) {
            try {
                final TplCompletionQuery.CompletionResult result = new TplCompletionQuery(doc).query();
                if (result != null) {
                    doc.render(new Runnable(){

                        @Override
                        public void run() {
                            items = this.getItems(result, doc, caretOffset);
                        }
                    });
                } else {
                    this.items = Collections.emptySet();
                }
                resultSet.addAllItems(this.items);
            }
            catch (ParseException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        private Set<TplCompletionItem> getItems(TplCompletionQuery.CompletionResult result, Document doc, int offset) {
            HashSet<TplCompletionItem> entries = new HashSet<TplCompletionItem>();
            boolean inSmarty = false;
            if (CodeCompletionUtils.insideSmartyCode(doc, offset)) {
                ArrayList<String> commands;
                if (CodeCompletionUtils.inVariableModifiers(doc, offset)) {
                    entries.addAll(result.getVariableModifiers());
                    inSmarty = true;
                }
                if (!(commands = CodeCompletionUtils.afterSmartyCommand(doc, offset)).isEmpty()) {
                    entries.addAll(result.getParamsForCommand(commands));
                    inSmarty = true;
                }
                if (!inSmarty && result != null) {
                    entries.addAll(result.getFunctions());
                }
            }
            return entries;
        }

        protected boolean canFilter(JTextComponent component) {
            try {
                if (component.getText(component.getCaretPosition() - 1, 1).toString().equals("|")) {
                    return false;
                }
            }
            catch (BadLocationException ex) {
                return false;
            }
            String prefix = CodeCompletionUtils.getTextPrefix(component.getDocument(), component.getCaretPosition());
            for (CompletionItem completionItem : this.items) {
                if (!CodeCompletionUtils.startsWithIgnoreCase(((TplCompletionItem)completionItem).getItemText(), prefix)) continue;
                return true;
            }
            return false;
        }

        protected void filter(CompletionResultSet resultSet) {
            String prefix = CodeCompletionUtils.getTextPrefix(this.component.getDocument(), this.component.getCaretPosition());
            for (CompletionItem completionItem : this.items) {
                if (!CodeCompletionUtils.startsWithIgnoreCase(((TplCompletionItem)completionItem).getItemText(), prefix)) continue;
                resultSet.addItem(completionItem);
            }
            resultSet.finish();
        }
    }
}

