/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

public class URLUtil {
    public static URL resolve(String s) throws MalformedURLException {
        URL resolve = null;
        if (s.indexOf("://") > -1 || s.indexOf("file:") > -1) {
            resolve = new URL(s);
        } else if (s.startsWith(File.separator) || s.startsWith("/") || s.length() >= 2 && Character.isLetter(s.charAt(0)) && s.charAt(1) == ':') {
            String fName = s;
            try {
                fName = new File(s).getCanonicalPath();
            }
            catch (NullPointerException npe) {
            }
            catch (IOException npe) {
                // empty catch block
            }
            resolve = new URL("file", "", fName);
        } else {
            String path = System.getProperty("user.dir") + File.separator + s;
            resolve = new URL("file", "", path);
        }
        if (!resolve.getProtocol().equalsIgnoreCase("war") && resolve.getFile().toLowerCase().endsWith(".war")) {
            URL u;
            resolve = u = new URL("war:" + resolve.toString());
        }
        resolve = new URL(URLUtil.trim(resolve.toString(), ".", ".."));
        resolve = new URL(URLUtil.trim(resolve.toString(), "./"));
        return resolve;
    }

    private static String trim(String s, String t) {
        return URLUtil.trim(s, t, null);
    }

    private static String trim(String s, String r, String t) {
        while (s.endsWith(r) && (t == null ? true : !s.endsWith(t))) {
            int i = s.length() - r.length();
            s = s.substring(0, i);
        }
        return s;
    }

    public static String removeLast(String s) {
        int i = s.lastIndexOf("/");
        s = i > 0 ? s.substring(0, i) : (i == 0 && !s.equals("/") ? "/" : "");
        return s;
    }

    public static String getFirst(String path) {
        int i;
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if ((i = path.indexOf("/")) > -1) {
            path = path.substring(0, i);
        }
        return "/" + path;
    }

    public static String getExtension(String path) {
        int i = path.lastIndexOf(".");
        int j = path.lastIndexOf("/");
        if (i > 0 && i > j) {
            return path.substring(i);
        }
        return null;
    }

    public static boolean hasEscape(String url) {
        boolean hasEscape = false;
        int pctindex = -1;
        boolean index = false;
        while ((pctindex = url.indexOf(37, pctindex + 1)) >= 0) {
            try {
                String escape = url.substring(pctindex + 1, pctindex + 3);
                int code = Integer.parseInt(escape, 16);
                hasEscape = true;
                break;
            }
            catch (IndexOutOfBoundsException e) {
                break;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return hasEscape;
    }

    public static String normalizeURI(String URI2) {
        int start = 0;
        int end = URI2.length();
        char[] buff = new char[URI2.length()];
        URI2.getChars(0, URI2.length(), buff, 0);
        int i = 0;
        int j = 0;
        i = start;
        j = start;
        while (i < end - 1) {
            if (buff[i] == '/' && buff[i + 1] == '/') {
                while (buff[i + 1] == '/') {
                    ++i;
                }
            }
            buff[j++] = buff[i];
            ++i;
        }
        if (i != j) {
            buff[j++] = buff[end - 1];
            end = j;
        }
        i = start;
        j = start;
        while (i < end - 1) {
            if (buff[i] == '.' && buff[i + 1] == '/' && (i == 0 || buff[i - 1] == '/')) {
                if (++i == end - 1) {
                    --j;
                }
            } else {
                buff[j++] = buff[i];
            }
            ++i;
        }
        if (i != j) {
            buff[j++] = buff[end - 1];
            end = j;
        }
        j = end;
        if (end == start + 1 && buff[start] == '.') {
            --end;
        } else if (end > start + 1 && buff[end - 1] == '.' && buff[end - 2] == '/') {
            end -= 2;
        }
        i = start;
        j = start;
        while (i < end - 2) {
            if (buff[i] == '.' && buff[i + 1] == '.' && buff[i + 2] == '/' && (i == 0 || buff[i - 1] == '/')) {
                ++i;
                j -= 2;
                while (j > 0 && buff[j] != '/') {
                    --j;
                }
            } else {
                buff[j++] = buff[i];
            }
            ++i;
        }
        if (i != j) {
            buff[j++] = buff[end - 2];
            buff[j++] = buff[end - 1];
            end = j;
        }
        j = end;
        if (end > start + 3 && buff[end - 1] == '.' && buff[end - 2] == '.' && buff[end - 3] == '/') {
            end -= 4;
            while (end > 0 && buff[end] != '/') {
                --end;
            }
        }
        String result = new String(buff, 0, end);
        return result;
    }
}

