/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.refactoring;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.apisupport.project.api.EditableManifest;
import org.netbeans.modules.apisupport.project.api.LayerHandle;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.netbeans.modules.apisupport.refactoring.AbstractRefactoringElement;
import org.netbeans.modules.apisupport.refactoring.AbstractRefactoringPlugin;
import org.netbeans.modules.apisupport.refactoring.Utility;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.SafeDeleteRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class NbSafeDeleteRefactoringPlugin
extends AbstractRefactoringPlugin {
    private static ThreadLocal semafor = new ThreadLocal();
    private Logger LOG = Logger.getLogger(NbSafeDeleteRefactoringPlugin.class.getName());

    public NbSafeDeleteRefactoringPlugin(AbstractRefactoring refactoring) {
        super(refactoring);
    }

    public void cancelRequest() {
    }

    public Problem fastCheckParameters() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Problem prepare(RefactoringElementsBag refactoringElements) {
        if (semafor.get() != null) {
            return null;
        }
        semafor.set(new Object());
        try {
            SafeDeleteRefactoring delete = (SafeDeleteRefactoring)this.refactoring;
            Problem problem = null;
            Lookup lkp = delete.getRefactoringSource();
            AbstractRefactoringPlugin.InfoHolder infoholder = this.examineLookup(lkp);
            TreePathHandle handle = (TreePathHandle)lkp.lookup(TreePathHandle.class);
            Project project = FileOwnerQuery.getOwner((FileObject)handle.getFileObject());
            if (project == null || project.getLookup().lookup(NbModuleProvider.class) == null) {
                Problem problem2 = null;
                return problem2;
            }
            if (infoholder.isClass) {
                this.checkManifest(project, infoholder.fullName, refactoringElements);
                this.checkLayer(project, infoholder.fullName, refactoringElements);
            }
            if (infoholder.isMethod) {
                this.checkMethodLayer(infoholder, handle.getFileObject(), refactoringElements);
            }
            if (infoholder.isConstructor) {
                this.checkConstructorLayer(infoholder, handle.getFileObject(), refactoringElements);
            }
            this.LOG.log(Level.FINE, "returning problem: {0}", problem);
            Problem problem3 = problem;
            return problem3;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            Problem problem = null;
            return problem;
        }
        finally {
            semafor.set(null);
        }
    }

    @Override
    protected RefactoringElementImplementation createManifestRefactoring(String fqname, FileObject manifestFile, String attributeKey, String attributeValue, String section) {
        return new ManifestSafeDeleteRefactoringElement(manifestFile, attributeValue, attributeKey, section);
    }

    @Override
    protected RefactoringElementImplementation createConstructorLayerRefactoring(String constructor, String fqname, LayerHandle handle, FileObject layerFileObject, String layerAttribute) {
        return handle.getLayerFile() != null ? new LayerSafeDeleteRefactoringElement(constructor, handle, layerFileObject) : null;
    }

    @Override
    protected RefactoringElementImplementation createLayerRefactoring(String fqname, LayerHandle handle, FileObject layerFileObject, String layerAttribute) {
        return handle.getLayerFile() != null ? new LayerSafeDeleteRefactoringElement(fqname, handle, layerFileObject, layerAttribute) : null;
    }

    @Override
    protected RefactoringElementImplementation createMethodLayerRefactoring(String method, String fqname, LayerHandle handle, FileObject layerFileObject, String layerAttribute) {
        return handle.getLayerFile() != null ? new LayerSafeDeleteRefactoringElement(method, handle, layerFileObject) : null;
    }

    public final class LayerSafeDeleteRefactoringElement
    extends AbstractRefactoringElement {
        private FileObject layerFO;
        private LayerHandle handle;
        private String attribute;

        public LayerSafeDeleteRefactoringElement(String name, LayerHandle handle, FileObject layerFO, String attr) {
            this(name, handle, layerFO);
            this.attribute = attr;
        }

        public LayerSafeDeleteRefactoringElement(String name, LayerHandle handle, FileObject layerFO) {
            super(handle.getLayerFile());
            this.name = name;
            this.handle = handle;
            this.layerFO = layerFO;
        }

        public String getDisplayText() {
            return NbBundle.getMessage(NbSafeDeleteRefactoringPlugin.class, (String)"TXT_LayerDelete", (Object)this.layerFO.getNameExt());
        }

        @Override
        public void performChange() {
            boolean on = this.handle.isAutosave();
            if (!on) {
                this.handle.setAutosave(true);
            }
            try {
                if (this.attribute != null) {
                    this.layerFO.setAttribute(this.attribute, null);
                    if ("originalFile".equals(this.attribute)) {
                        this.layerFO.delete();
                    }
                } else {
                    this.layerFO.delete();
                }
                this.deleteEmptyParent(this.layerFO.getParent());
            }
            catch (IOException exc) {
                ErrorManager.getDefault().notify((Throwable)exc);
            }
            if (!on) {
                this.handle.setAutosave(false);
            }
        }

        private void deleteEmptyParent(FileObject parent) throws IOException {
            if (parent != null && !parent.getChildren(true).hasMoreElements() && !parent.getAttributes().hasMoreElements()) {
                FileObject parentToDel = parent.getParent();
                parent.delete();
                this.deleteEmptyParent(parentToDel);
            }
        }

        @Override
        public void undoChange() {
        }
    }

    public final class ManifestSafeDeleteRefactoringElement
    extends AbstractRefactoringElement {
        private String attrName;
        private String sectionName;
        private String oldContent;

        public ManifestSafeDeleteRefactoringElement(FileObject parentFile, String attributeValue, String attributeName) {
            super(parentFile);
            this.sectionName = null;
            this.name = attributeValue;
            this.attrName = attributeName;
            this.oldContent = Utility.readFileIntoString(parentFile);
        }

        public ManifestSafeDeleteRefactoringElement(FileObject parentFile, String attributeValue, String attributeName, String secName) {
            this(parentFile, attributeValue, attributeName);
            this.sectionName = secName;
        }

        public String getDisplayText() {
            if (this.sectionName != null) {
                return NbBundle.getMessage(NbSafeDeleteRefactoringPlugin.class, (String)"TXT_ManifestSectionDelete", (Object)this.name, (Object)this.sectionName);
            }
            return NbBundle.getMessage(NbSafeDeleteRefactoringPlugin.class, (String)"TXT_ManifestDelete", (Object)this.name, (Object)this.attrName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void performChange() {
            OutputStream stream = null;
            InputStream instream = null;
            try {
                instream = this.parentFile.getInputStream();
                EditableManifest manifest = new EditableManifest(instream);
                instream.close();
                instream = null;
                if (this.sectionName != null) {
                    manifest.removeSection(this.name);
                } else {
                    manifest.removeAttribute(this.attrName, null);
                }
                stream = this.parentFile.getOutputStream();
                manifest.write(stream);
            }
            catch (FileNotFoundException ex) {
                NbSafeDeleteRefactoringPlugin.this.LOG.log(Level.WARNING, "Exception during refactoring", ex);
            }
            catch (IOException exc) {
                NbSafeDeleteRefactoringPlugin.this.LOG.log(Level.WARNING, "Exception during refactoring", exc);
            }
            catch (IllegalArgumentException exc) {
                NbSafeDeleteRefactoringPlugin.this.LOG.log(Level.INFO, "IllegalArgumentException thrown from removeSection/Attribute, entry probably already deleted");
            }
            finally {
                if (instream != null) {
                    try {
                        instream.close();
                    }
                    catch (IOException ex) {
                        NbSafeDeleteRefactoringPlugin.this.LOG.log(Level.WARNING, "Exception during refactoring", ex);
                    }
                }
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException ex) {
                        NbSafeDeleteRefactoringPlugin.this.LOG.log(Level.WARNING, "Exception during refactoring", ex);
                    }
                }
            }
        }

        @Override
        public void undoChange() {
            if (this.oldContent != null) {
                Utility.writeFileFromString(this.parentFile, this.oldContent);
            }
        }
    }
}

