/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.lib.properties;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.netbeans.modules.css.lib.api.properties.GrammarElement;
import org.netbeans.modules.css.lib.api.properties.GrammarResolverListener;
import org.netbeans.modules.css.lib.api.properties.GroupGrammarElement;
import org.netbeans.modules.css.lib.api.properties.Node;
import org.netbeans.modules.css.lib.api.properties.ResolvedToken;
import org.netbeans.modules.css.lib.api.properties.ValueGrammarElement;

public class GrammarParseTreeBuilder
implements GrammarResolverListener {
    private Node root;
    private Stack<Entry> stack = new Stack();
    private boolean parsingFinished;
    public static boolean DEBUG = false;
    private int indent = 0;

    public Node getParseTree() {
        if (!this.parsingFinished) {
            throw new IllegalStateException("Parsing not finished!");
        }
        return this.root;
    }

    private void out(GrammarElement element, boolean accepted) {
        if (DEBUG) {
            --this.indent;
            System.out.println(String.format("%s%s %s", this.getIndent(), accepted ? "*" : "-", element));
        }
        Entry pop = this.stack.pop();
        Node.AbstractNode node = pop.node;
        if (this.stack.isEmpty()) {
            return;
        }
        if (accepted) {
            Entry peek = this.stack.peek();
            Node.GroupNodeImpl gnode = (Node.GroupNodeImpl)peek.node;
            peek.childrenMap.put(pop.grammarElement, node);
            gnode.addChild(node);
        }
    }

    @Override
    public void entering(GroupGrammarElement group) {
        if (DEBUG) {
            System.out.println(String.format("%s%s", this.getIndent(), group));
            ++this.indent;
        }
        Node.GroupNodeImpl node = new Node.GroupNodeImpl(group);
        if (this.root == null) {
            if (DEBUG) {
                System.out.println(String.format("Root node set to element %s", group));
            }
            this.root = node;
        }
        Entry e = new Entry(group, node);
        this.stack.push(e);
    }

    @Override
    public void accepted(GroupGrammarElement group) {
        this.out(group, true);
    }

    @Override
    public void rejected(GroupGrammarElement group) {
        this.out(group, false);
    }

    @Override
    public void entering(ValueGrammarElement element) {
        Node.ResolvedTokenNode node = new Node.ResolvedTokenNode();
        if (this.root == null) {
            this.root = node;
        }
        Entry e = new Entry(element, node);
        this.stack.push(e);
    }

    @Override
    public void accepted(ValueGrammarElement value, ResolvedToken resolvedToken) {
        if (DEBUG) {
            System.out.println(String.format("%s * '%s' value token accepted", this.getIndent(), value));
        }
        Entry pop = this.stack.pop();
        Node.ResolvedTokenNode node = (Node.ResolvedTokenNode)pop.node;
        node.setResolvedToken(resolvedToken);
        Entry peek = this.stack.peek();
        Node.GroupNodeImpl gnode = (Node.GroupNodeImpl)peek.node;
        peek.childrenMap.put(pop.grammarElement, node);
        gnode.addChild(node);
    }

    @Override
    public void rejected(ValueGrammarElement value) {
        this.stack.pop();
    }

    @Override
    public void ruleChoosen(GroupGrammarElement base, GrammarElement element) {
        Entry peek = this.stack.peek();
        if (DEBUG) {
            System.out.println(String.format("%s group %s: choosen branch %s", this.getIndent(), base, element));
            System.out.println(String.format("(in group %s)", peek.grammarElement));
        }
        Node.GroupNodeImpl group = (Node.GroupNodeImpl)peek.node;
        peek.choosenBranches.add(element);
        for (GrammarElement key : peek.childrenMap.keySet()) {
            Node.AbstractNode node = peek.childrenMap.get(key);
            if (peek.choosenBranches.contains(key)) continue;
            group.removeChild(node);
        }
        peek.childrenMap.clear();
    }

    @Override
    public void starting() {
        if (DEBUG) {
            System.out.println("Parsing is about to start");
        }
    }

    @Override
    public void finished() {
        this.parsingFinished = true;
        if (DEBUG) {
            System.out.println("Parsing finished");
        }
    }

    private CharSequence getIndent() {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < this.indent * 4; ++i) {
            b.append(' ');
        }
        return b;
    }

    private static class Entry {
        public final GrammarElement grammarElement;
        public final Node.AbstractNode node;
        public final Map<GrammarElement, Node.AbstractNode> childrenMap;
        public final Set<GrammarElement> choosenBranches;

        public Entry(GrammarElement grammarElement, Node.AbstractNode node) {
            this.grammarElement = grammarElement;
            this.node = node;
            this.childrenMap = new HashMap<GrammarElement, Node.AbstractNode>();
            this.choosenBranches = new HashSet<GrammarElement>();
        }
    }
}

