/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.common.ui;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.PlatformsCustomizer;
import org.netbeans.modules.payara.common.PayaraInstance;
import org.netbeans.modules.payara.common.ui.JavaPlatformsComboBox;
import org.netbeans.modules.payara.common.utils.JavaUtils;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class VmCustomizer
extends JPanel {
    private static int PORT_MIN = 0;
    private static int PORT_MAX = 65535;
    private final String platformButtonText;
    private final PlatformAction platformButtonAction;
    private final PayaraInstance instance;
    JavaPlatform[] javaPlatforms;
    private JSpinner addressValue;
    private ButtonGroup buttonGroup1;
    private JPanel debugSettingsPanel;
    private JLabel jLabel1;
    private JComboBox javaComboBox;
    private JLabel javaInstallLabel;
    private JPanel pickerPanel;
    private JButton platformButton;
    private JCheckBox useIDEProxyInfo;
    private JRadioButton useSharedMemRB;
    private JRadioButton useSocketRB;
    private JCheckBox useUserDefinedAddress;

    public VmCustomizer(PayaraInstance instance) {
        this.instance = instance;
        this.javaPlatforms = JavaUtils.findSupportedPlatforms(this.instance);
        this.platformButtonText = NbBundle.getMessage(VmCustomizer.class, (String)"VmCustomizer.platformButton");
        this.platformButtonAction = new PlatformAction();
        this.initComponents();
    }

    private void initFields() {
        String address = this.instance.getProperty("debugPort");
        SpinnerNumberModel addressModel = (SpinnerNumberModel)this.addressValue.getModel();
        this.javaPlatforms = JavaUtils.findSupportedPlatforms(this.instance);
        ((JavaPlatformsComboBox)this.javaComboBox).updateModel(this.javaPlatforms);
        this.javaComboBox.setSelectedItem(this.instance.getJavaPlatform());
        if (null == address || "0".equals(address) || "".equals(address)) {
            this.useUserDefinedAddress.setSelected(false);
        } else {
            this.useUserDefinedAddress.setSelected(true);
            this.setAddressValue(address);
        }
        if (Utilities.isWindows() && !this.instance.isRemote()) {
            this.useSharedMemRB.setSelected("true".equals(this.instance.getProperty("use.shared.mem")));
            this.useSocketRB.setSelected(!"true".equals(this.instance.getProperty("use.shared.mem")));
        } else {
            this.useSharedMemRB.setEnabled(false);
            this.useSharedMemRB.setSelected(false);
            this.useSocketRB.setSelected(true);
        }
        this.useIDEProxyInfo.setSelected("true".equals(this.instance.getProperty("useIDEProxyOn")));
        boolean isLocalDomain = this.instance.getProperty("domainsfolder") != null;
        this.javaComboBox.setEnabled(isLocalDomain);
        this.useIDEProxyInfo.setEnabled(isLocalDomain);
        this.useSharedMemRB.setEnabled(isLocalDomain);
    }

    private Number getAddressValue() {
        return ((SpinnerNumberModel)this.addressValue.getModel()).getNumber();
    }

    private void setAddressValue(String number) {
        try {
            this.addressValue.setValue(new Integer(number));
        }
        catch (NumberFormatException nfe) {
            this.addressValue.setValue(new Integer(0));
        }
    }

    private void setAddressValue(Integer number) {
        this.addressValue.setValue(number != null ? number : new Integer(0));
    }

    private void persistFields() {
        Iterator platformIterator;
        JavaPlatform selectedPlatform;
        String selectedJavaHome = null;
        JavaPlatform javaPlatform = selectedPlatform = this.isJavaPlatformDefault() ? null : this.javaPlatform();
        if (selectedPlatform != null && (platformIterator = selectedPlatform.getInstallFolders().iterator()).hasNext()) {
            FileObject javaHomeFO = (FileObject)platformIterator.next();
            selectedJavaHome = javaHomeFO != null ? FileUtil.toFile((FileObject)javaHomeFO).getAbsolutePath() : null;
        }
        this.instance.setJavaHome(selectedJavaHome);
        this.instance.putProperty("use.shared.mem", Boolean.toString(this.useSharedMemRB.isSelected()));
        this.instance.putProperty("useIDEProxyOn", Boolean.toString(this.useIDEProxyInfo.isSelected()));
        this.instance.putProperty("debugPort", this.getAddressValue().toString());
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.initFields();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.persistFields();
    }

    JavaPlatform javaPlatform() {
        JavaPlatformsComboBox.Platform platform = (JavaPlatformsComboBox.Platform)this.javaComboBox.getSelectedItem();
        return platform != null ? platform.getPlatform() : null;
    }

    boolean isJavaPlatformDefault() {
        JavaPlatformsComboBox.Platform platform = (JavaPlatformsComboBox.Platform)this.javaComboBox.getSelectedItem();
        return platform != null ? platform.isDefault() : false;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.debugSettingsPanel = new JPanel();
        this.useSocketRB = new JRadioButton();
        this.useSharedMemRB = new JRadioButton();
        this.useUserDefinedAddress = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.addressValue = new JSpinner();
        this.pickerPanel = new JPanel();
        this.javaInstallLabel = new JLabel();
        this.javaComboBox = new JavaPlatformsComboBox(this.javaPlatforms);
        this.platformButton = new JButton(this.platformButtonAction);
        this.useIDEProxyInfo = new JCheckBox();
        this.setName(NbBundle.getMessage(VmCustomizer.class, (String)"VmCustomizer.name"));
        this.debugSettingsPanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(VmCustomizer.class, (String)"VmCustomizer.debugSettingsPanel.border.title.text")));
        this.buttonGroup1.add(this.useSocketRB);
        Mnemonics.setLocalizedText((AbstractButton)this.useSocketRB, (String)NbBundle.getMessage(VmCustomizer.class, (String)"VmCustomizer.useSocketRB.text"));
        this.buttonGroup1.add(this.useSharedMemRB);
        Mnemonics.setLocalizedText((AbstractButton)this.useSharedMemRB, (String)NbBundle.getMessage(VmCustomizer.class, (String)"VmCustomizer.useSharedMemRB.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.useUserDefinedAddress, (String)NbBundle.getMessage(VmCustomizer.class, (String)"VmCustomizer.useUserDefinedAddress.text", (Object[])new Object[0]));
        this.useUserDefinedAddress.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VmCustomizer.this.toggleAddressUsage(evt);
            }
        });
        this.jLabel1.setLabelFor(this.addressValue);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(VmCustomizer.class, (String)"VmCustomizer.jLabel1.text"));
        this.addressValue.setModel(new SpinnerNumberModel(0, 0, 65535, 1));
        this.addressValue.setEditor(new JSpinner.NumberEditor(this.addressValue, "#####"));
        GroupLayout debugSettingsPanelLayout = new GroupLayout(this.debugSettingsPanel);
        this.debugSettingsPanel.setLayout(debugSettingsPanelLayout);
        debugSettingsPanelLayout.setHorizontalGroup(debugSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(debugSettingsPanelLayout.createSequentialGroup().addContainerGap().addGroup(debugSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(debugSettingsPanelLayout.createSequentialGroup().addComponent(this.useUserDefinedAddress).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addressValue, -2, 99, -2).addGap(0, 136, Short.MAX_VALUE)).addGroup(debugSettingsPanelLayout.createSequentialGroup().addGroup(debugSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.useSharedMemRB).addComponent(this.useSocketRB)).addContainerGap(-1, Short.MAX_VALUE)))));
        debugSettingsPanelLayout.setVerticalGroup(debugSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(debugSettingsPanelLayout.createSequentialGroup().addComponent(this.useSharedMemRB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.useSocketRB).addGap(8, 8, 8).addGroup(debugSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.useUserDefinedAddress).addComponent(this.jLabel1).addComponent(this.addressValue, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.useSocketRB.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(VmCustomizer.class, (String)"A11Y_DESC_UseSockets"));
        this.useSharedMemRB.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(VmCustomizer.class, (String)"A11Y_DESC_SharedMem"));
        this.useUserDefinedAddress.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(VmCustomizer.class, (String)"A11Y_DESC_UseSelectedAddress"));
        this.jLabel1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(VmCustomizer.class, (String)"A11Y_DESC_AddressLabel"));
        Mnemonics.setLocalizedText((JLabel)this.javaInstallLabel, (String)NbBundle.getMessage(VmCustomizer.class, (String)"VmCustomizer.javaInstallLabel.text"));
        this.javaComboBox.setMaximumSize(new Dimension(400, Short.MAX_VALUE));
        this.javaComboBox.setMinimumSize(new Dimension(400, 24));
        this.javaComboBox.setPreferredSize(new Dimension(400, 24));
        this.platformButton.setText(this.platformButtonText);
        GroupLayout pickerPanelLayout = new GroupLayout(this.pickerPanel);
        this.pickerPanel.setLayout(pickerPanelLayout);
        pickerPanelLayout.setHorizontalGroup(pickerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pickerPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.javaInstallLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.javaComboBox, 0, 1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.platformButton).addContainerGap()));
        pickerPanelLayout.setVerticalGroup(pickerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pickerPanelLayout.createSequentialGroup().addContainerGap().addGroup(pickerPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.javaInstallLabel).addComponent(this.javaComboBox, -2, -1, -2).addComponent(this.platformButton)).addContainerGap()));
        this.javaInstallLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(VmCustomizer.class, (String)"A11Y_DESC_JavaLabel"));
        Mnemonics.setLocalizedText((AbstractButton)this.useIDEProxyInfo, (String)NbBundle.getMessage(VmCustomizer.class, (String)"VmCustomizer.useIDEProxyInfo.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pickerPanel, -1, -1, Short.MAX_VALUE).addComponent(this.debugSettingsPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.useIDEProxyInfo, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.pickerPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 8, Short.MAX_VALUE).addComponent(this.debugSettingsPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.useIDEProxyInfo).addGap(19, 19, 19)));
        this.useIDEProxyInfo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(VmCustomizer.class, (String)"A11Y_DESC_UseIdeProxySettings"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(VmCustomizer.class, (String)"A11Y_DESC_JavaPanel"));
    }

    private void toggleAddressUsage(ActionEvent evt) {
        if (this.useUserDefinedAddress.isSelected()) {
            this.addressValue.setEnabled(true);
            int debugPort = 9009;
            try {
                ServerSocket t = new ServerSocket(0);
                debugPort = t.getLocalPort();
                t.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.setAddressValue(new Integer(debugPort));
        } else {
            this.setAddressValue(new Integer(0));
            this.addressValue.setEnabled(false);
        }
    }

    private class PlatformAction
    extends AbstractAction {
        private PlatformAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PlatformsCustomizer.showCustomizer((JavaPlatform)VmCustomizer.this.javaPlatform());
            VmCustomizer.this.javaPlatforms = JavaUtils.findSupportedPlatforms(VmCustomizer.this.instance);
            ((JavaPlatformsComboBox)VmCustomizer.this.javaComboBox).updateModel(VmCustomizer.this.javaPlatforms);
        }
    }
}

