/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.palette;

import java.awt.EventQueue;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.Action;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.form.FormServices;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.palette.PaletteItem;
import org.netbeans.modules.form.project.ClassSource;
import org.netbeans.spi.palette.PaletteActions;
import org.netbeans.spi.palette.PaletteController;
import org.netbeans.spi.palette.PaletteFactory;
import org.netbeans.spi.palette.PaletteFilter;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.WeakSet;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public final class PaletteUtils {
    private static FileObject paletteFolder;
    private static DataFolder paletteDataFolder;
    private static FileObject context;
    private static Map<Project, ProjectPaletteInfo> palettes;

    private PaletteUtils() {
    }

    static String getItemComponentDescription(PaletteItem item) {
        ClassSource classSource = item.getComponentClassSource();
        if (classSource == null || !classSource.hasEntries()) {
            String className = classSource.getClassName();
            if (className != null) {
                if (className.startsWith("javax.") || className.startsWith("java.")) {
                    return PaletteUtils.getBundleString("MSG_StandardJDKComponent");
                }
                if (className.startsWith("org.netbeans.")) {
                    return PaletteUtils.getBundleString("MSG_NetBeansComponent");
                }
            }
            return PaletteUtils.getBundleString("MSG_UnspecifiedComponent");
        }
        return NbBundle.getMessage(PaletteUtils.class, (String)"FMT_ComponentFrom", (Object)classSource.getEntries().iterator().next().getDisplayName());
    }

    public static FileObject getPaletteFolder() {
        if (paletteFolder != null) {
            return paletteFolder;
        }
        try {
            paletteFolder = FileUtil.getConfigFile((String)"FormDesignerPalette");
            if (paletteFolder == null) {
                paletteFolder = FileUtil.getConfigRoot().createFolder("FormDesignerPalette");
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException("Palette folder not found and cannot be created.");
        }
        return paletteFolder;
    }

    public static Node getPaletteNode() {
        return PaletteUtils.getPaletteDataFolder().getNodeDelegate();
    }

    public static void showPaletteManager() {
        try {
            PaletteFactory.createPalette((String)"FormDesignerPalette", (PaletteActions)PaletteUtils.createPaletteActions(), (PaletteFilter)new ClassPathFilter(null), null).showCustomizer();
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
    }

    private static PaletteActions createPaletteActions() {
        FormServices services = (FormServices)Lookup.getDefault().lookup(FormServices.class);
        return services.createPaletteActions();
    }

    public static void setContext(FileObject fileInProject) {
        context = fileInProject;
    }

    public static synchronized void addPaletteListener(PropertyChangeListener listener, FileObject context) {
        ProjectPaletteInfo pInfo = PaletteUtils.preparePalette(context);
        if (pInfo != null) {
            if (pInfo.paletteListeners == null) {
                pInfo.paletteListeners = new LinkedList<PropertyChangeListener>();
            }
            pInfo.paletteListeners.add(listener);
            pInfo.getPalette().addPropertyChangeListener(listener);
        }
    }

    public static synchronized void removePaletteListener(PropertyChangeListener listener, FileObject context) {
        Project project = FileOwnerQuery.getOwner((FileObject)context);
        ProjectPaletteInfo pInfo = palettes.get(project);
        if (pInfo != null && pInfo.paletteListeners != null) {
            pInfo.paletteListeners.remove(listener);
            pInfo.getPalette().removePropertyChangeListener(listener);
        }
    }

    public static Lookup getPaletteLookup(FileObject context) {
        ProjectPaletteInfo pInfo = PaletteUtils.preparePalette(context);
        return pInfo != null ? pInfo.paletteLookup : Lookup.EMPTY;
    }

    private static PaletteController getPalette() {
        ProjectPaletteInfo pInfo = PaletteUtils.preparePalette(context);
        return pInfo != null ? pInfo.getPalette() : null;
    }

    private static ClassPathFilter getPaletteFilter() {
        ProjectPaletteInfo pInfo;
        Project project;
        if (context != null && (project = FileOwnerQuery.getOwner((FileObject)context)) != null && (pInfo = palettes.get(project)) != null) {
            return pInfo.paletteFilter;
        }
        return null;
    }

    private static ProjectPaletteInfo preparePalette(FileObject context) {
        if (context == null) {
            return null;
        }
        final Project project = FileOwnerQuery.getOwner((FileObject)context);
        ProjectPaletteInfo pInfo = palettes.get(project);
        if (pInfo == null) {
            ClassPathFilter filter;
            if (project != null) {
                ClassPath classPath = ClassPath.getClassPath((FileObject)context, (String)"classpath/boot");
                classPath.addPropertyChangeListener((PropertyChangeListener)new ClassPathListener(classPath, project));
                filter = new ClassPathFilter(classPath);
            } else {
                filter = null;
            }
            PaletteLookup lookup = new PaletteLookup();
            lookup.setPalette(EventQueue.isDispatchThread() ? PaletteUtils.createDummyPalette() : PaletteUtils.createPalette(filter));
            pInfo = new ProjectPaletteInfo();
            pInfo.paletteLookup = lookup;
            pInfo.paletteFilter = filter;
            palettes.put(project, pInfo);
            if (EventQueue.isDispatchThread()) {
                FormUtils.getRequestProcessor().post(new Runnable(){

                    @Override
                    public void run() {
                        PaletteController palette = PaletteUtils.createPalette(filter);
                        Lookup rootLookup = palette.getRoot();
                        Node root = (Node)rootLookup.lookup(Node.class);
                        for (Node category : root.getChildren().getNodes(true)) {
                            category.getDisplayName();
                            category.getIcon(1);
                            category.getIcon(2);
                            for (Node item : category.getChildren().getNodes(true)) {
                                item.getDisplayName();
                                item.getIcon(1);
                                item.getIcon(2);
                            }
                        }
                        ProjectPaletteInfo pInfo = (ProjectPaletteInfo)palettes.get(project);
                        if (pInfo != null) {
                            PaletteLookup lookup = pInfo.paletteLookup;
                            PaletteController oldPalette = pInfo.getPalette();
                            if (pInfo.paletteListeners != null) {
                                for (PropertyChangeListener l : pInfo.paletteListeners) {
                                    oldPalette.removePropertyChangeListener(l);
                                    palette.addPropertyChangeListener(l);
                                }
                            }
                            lookup.setPalette(palette);
                        }
                    }
                });
            }
        }
        return pInfo;
    }

    private static PaletteController createDummyPalette() {
        AbstractNode loadingNode = new AbstractNode(Children.LEAF);
        loadingNode.setDisplayName(PaletteUtils.getBundleString("MSG_DummyPaletteLoading"));
        Children.Array rootChildren = new Children.Array();
        rootChildren.add(new Node[]{loadingNode});
        AbstractNode root = new AbstractNode((Children)rootChildren);
        return PaletteFactory.createPalette((Node)root, (PaletteActions)new PaletteActions(){

            public Action[] getImportActions() {
                return new Action[0];
            }

            public Action[] getCustomPaletteActions() {
                return new Action[0];
            }

            public Action[] getCustomCategoryActions(Lookup category) {
                return new Action[0];
            }

            public Action[] getCustomItemActions(Lookup item) {
                return new Action[0];
            }

            public Action getPreferredAction(Lookup item) {
                return null;
            }
        });
    }

    private static PaletteController createPalette(ClassPathFilter filter) {
        try {
            return PaletteFactory.createPalette((String)"FormDesignerPalette", (PaletteActions)PaletteUtils.createPaletteActions(), (PaletteFilter)filter, null);
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
            return null;
        }
    }

    private static synchronized void bootClassPathChanged(Project p, ClassPath cp) {
        ProjectPaletteInfo pInfo = palettes.get(p);
        if (pInfo != null) {
            PaletteLookup lookup = pInfo.paletteLookup;
            PaletteController oldPalette = pInfo.getPalette();
            oldPalette.clearSelection();
            ClassPathFilter newFilter = new ClassPathFilter(cp);
            PaletteController newPalette = PaletteUtils.createPalette(newFilter);
            if (pInfo.paletteListeners != null) {
                for (PropertyChangeListener l : pInfo.paletteListeners) {
                    oldPalette.removePropertyChangeListener(l);
                    newPalette.addPropertyChangeListener(l);
                }
            }
            lookup.setPalette(newPalette);
            pInfo.paletteFilter = newFilter;
        }
    }

    static DataFolder getPaletteDataFolder() {
        if (paletteDataFolder == null) {
            paletteDataFolder = DataFolder.findFolder((FileObject)PaletteUtils.getPaletteFolder());
        }
        return paletteDataFolder;
    }

    public static void clearPaletteSelection() {
        PaletteController palette = PaletteUtils.getPalette();
        if (palette != null) {
            palette.clearSelection();
        }
    }

    public static PaletteItem getSelectedItem() {
        PaletteController palette = PaletteUtils.getPalette();
        if (palette == null) {
            return null;
        }
        Lookup lkp = palette.getSelectedItem();
        return (PaletteItem)lkp.lookup(PaletteItem.class);
    }

    public static void selectItem(PaletteItem item) {
        if (null == item) {
            PaletteUtils.clearPaletteSelection();
        } else {
            Node paletteNode = (Node)PaletteUtils.getPalette().getRoot().lookup(Node.class);
            Node[] categories = PaletteUtils.getCategoryNodes(paletteNode, true, true, true, true);
            for (int i = 0; i < categories.length; ++i) {
                Node[] items = PaletteUtils.getItemNodes(categories[i], true);
                for (int j = 0; j < items.length; ++j) {
                    PaletteItem formItem = (PaletteItem)items[j].getLookup().lookup(PaletteItem.class);
                    if (!item.equals(formItem)) continue;
                    PaletteUtils.getPalette().setSelectedItem(categories[i].getLookup(), items[j].getLookup());
                }
            }
        }
    }

    public static Image getIconForClass(String className, String classDetails, int type, boolean optimalResult) {
        Image img = null;
        for (PaletteItem item : PaletteUtils.getAllItems(optimalResult)) {
            if ("chooseBean".equals(item.getExplicitComponentType()) || !className.equals(item.getComponentClassName())) continue;
            Node node = item.getNode();
            img = node != null ? node.getIcon(type) : item.getIcon(type);
            if (classDetails == null || classDetails.equals(item.getComponentInitializerId())) break;
        }
        return img;
    }

    public static PaletteItem[] getAllItems() {
        return PaletteUtils.getAllItems(true);
    }

    public static PaletteItem[] getAllItems(boolean optimalResult) {
        HashSet<PaletteItem> uniqueItems = null;
        Node[] categories = PaletteUtils.getCategoryNodes(PaletteUtils.getPaletteNode(), false, true, false, optimalResult);
        for (int i = 0; i < categories.length; ++i) {
            Node[] items = PaletteUtils.getItemNodes(categories[i], true, optimalResult);
            for (int j = 0; j < items.length; ++j) {
                PaletteItem formItem = (PaletteItem)items[j].getLookup().lookup(PaletteItem.class);
                if (null == formItem) continue;
                if (null == uniqueItems) {
                    uniqueItems = new HashSet<PaletteItem>();
                }
                if ("chooseBean".equals(formItem.getExplicitComponentType())) continue;
                uniqueItems.add(formItem);
            }
        }
        PaletteItem[] res = null != uniqueItems ? uniqueItems.toArray(new PaletteItem[uniqueItems.size()]) : new PaletteItem[]{};
        return res;
    }

    public static String getBundleString(String key) {
        return NbBundle.getBundle(PaletteUtils.class).getString(key);
    }

    public static Node[] getItemNodes(Node categoryNode, boolean mustBeValid) {
        return PaletteUtils.getItemNodes(categoryNode, mustBeValid, true);
    }

    private static Node[] getItemNodes(Node categoryNode, boolean mustBeValid, boolean optimalResult) {
        Node[] nodes = categoryNode.getChildren().getNodes(optimalResult);
        if (!mustBeValid) {
            return nodes;
        }
        ClassPathFilter filter = PaletteUtils.getPaletteFilter();
        if (filter == null) {
            return nodes;
        }
        ArrayList<Node> validList = null;
        for (int i = 0; i < nodes.length; ++i) {
            PaletteItem item = (PaletteItem)nodes[i].getCookie(PaletteItem.class);
            if (filter.isValidItem(item)) {
                if (validList == null) continue;
                validList.add(nodes[i]);
                continue;
            }
            if (validList != null) continue;
            validList = new ArrayList<Node>(nodes.length);
            for (int j = 0; j < i; ++j) {
                validList.add(nodes[j]);
            }
        }
        if (validList != null) {
            nodes = validList.toArray(new Node[validList.size()]);
        }
        return nodes;
    }

    public static Node[] getCategoryNodes(Node paletteNode, boolean mustBeVisible) {
        return PaletteUtils.getCategoryNodes(paletteNode, mustBeVisible, mustBeVisible, true, true);
    }

    private static Node[] getCategoryNodes(Node paletteNode, boolean mustBeVisible, boolean mustBeValid, boolean mustBePaletteCategory, boolean optimalResult) {
        if (mustBeVisible) {
            mustBePaletteCategory = true;
            mustBeValid = true;
        }
        Node[] nodes = paletteNode.getChildren().getNodes(optimalResult);
        ClassPathFilter filter = mustBeValid ? PaletteUtils.getPaletteFilter() : null;
        ArrayList<Node> list = null;
        for (int i = 0; i < nodes.length; ++i) {
            if (!(mustBeVisible && !PaletteUtils.isVisibleCategoryNode(nodes[i]) || mustBeValid && filter != null && !filter.isValidCategory(nodes[i]) || mustBePaletteCategory && !PaletteUtils.representsShowableCategory(nodes[i]))) {
                if (list == null) continue;
                list.add(nodes[i]);
                continue;
            }
            if (list != null) continue;
            list = new ArrayList<Node>(nodes.length);
            for (int j = 0; j < i; ++j) {
                list.add(nodes[j]);
            }
        }
        if (list != null) {
            nodes = new Node[list.size()];
            list.toArray(nodes);
        }
        return nodes;
    }

    private static boolean isVisibleCategoryNode(Node node) {
        DataFolder df = (DataFolder)node.getCookie(DataFolder.class);
        if (df != null) {
            Object value = node.getValue("psa_isVisible");
            if (null == value || "null".equals(value)) {
                value = df.getPrimaryFile().getAttribute("isVisible");
            }
            if (value == null) {
                value = Boolean.TRUE;
            }
            return Boolean.valueOf(value.toString());
        }
        return false;
    }

    private static boolean representsShowableCategory(Node node) {
        DataFolder df = (DataFolder)node.getCookie(DataFolder.class);
        return df != null && !Boolean.TRUE.equals(df.getPrimaryFile().getAttribute("isNoPaletteCategory"));
    }

    static {
        palettes = new WeakHashMap<Project, ProjectPaletteInfo>();
    }

    private static class PaletteLookup
    extends AbstractLookup {
        private InstanceContent content;

        PaletteLookup() {
            this(new InstanceContent());
        }

        private PaletteLookup(InstanceContent content) {
            super((AbstractLookup.Content)content);
            this.content = content;
        }

        void setPalette(PaletteController palette) {
            this.content.set(Arrays.asList(palette), null);
        }
    }

    private static class ClassPathListener
    implements PropertyChangeListener {
        private ClassPath classPath;
        private WeakReference<Project> projRef;

        ClassPathListener(ClassPath cp, Project p) {
            this.classPath = cp;
            this.projRef = new WeakReference<Project>(p);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("roots".equals(evt.getPropertyName())) {
                final Project p = (Project)this.projRef.get();
                if (p != null) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PaletteUtils.bootClassPathChanged(p, classPath);
                        }
                    });
                } else {
                    this.classPath.removePropertyChangeListener((PropertyChangeListener)this);
                }
            }
        }
    }

    private static class ClassPathFilter
    extends PaletteFilter {
        private ClassPath classPath;
        private Set<PaletteItem> validItems;
        private Set<PaletteItem> invalidItems;

        ClassPathFilter(ClassPath cp) {
            if (cp != null) {
                this.validItems = new WeakSet();
                this.invalidItems = new WeakSet();
            }
            this.classPath = cp;
        }

        public boolean isValidCategory(Lookup lkp) {
            Node categoryNode = (Node)lkp.lookup(Node.class);
            if (!PaletteUtils.representsShowableCategory(categoryNode)) {
                return false;
            }
            return this.isValidCategory(categoryNode);
        }

        boolean isValidCategory(Node node) {
            if (this.classPath == null) {
                return true;
            }
            DataFolder folder = (DataFolder)node.getCookie(DataFolder.class);
            if (folder == null) {
                return false;
            }
            DataObject[] dobjs = folder.getChildren();
            for (int i = 0; i < dobjs.length; ++i) {
                PaletteItem item = (PaletteItem)dobjs[i].getCookie(PaletteItem.class);
                if (item != null && !this.isValidItem(item)) continue;
                return true;
            }
            return dobjs.length == 0;
        }

        public boolean isValidItem(Lookup lkp) {
            return this.isValidItem((PaletteItem)lkp.lookup(PaletteItem.class));
        }

        boolean isValidItem(PaletteItem item) {
            if (this.classPath == null) {
                return true;
            }
            if (item == null) {
                return false;
            }
            if (item.getComponentClassSource().hasEntries() || "chooseBean".equals(item.getExplicitComponentType()) || "org.netbeans.modules.form.layoutsupport.delegates.NullLayoutSupport".equals(item.getComponentClassName())) {
                return true;
            }
            if (this.validItems.contains(item)) {
                return true;
            }
            if (this.invalidItems.contains(item)) {
                return false;
            }
            String resName = item.getComponentClassName().replace('.', '/').concat(".class");
            if (this.classPath.findResource(resName) != null) {
                this.validItems.add(item);
                return true;
            }
            this.invalidItems.add(item);
            return false;
        }
    }

    private static class ProjectPaletteInfo {
        PaletteLookup paletteLookup;
        ClassPathFilter paletteFilter;
        List<PropertyChangeListener> paletteListeners;

        private ProjectPaletteInfo() {
        }

        PaletteController getPalette() {
            return (PaletteController)this.paletteLookup.lookup(PaletteController.class);
        }
    }
}

