/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutsupport.delegates;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.Customizer;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.MatteBorder;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import org.netbeans.modules.form.FormDesigner;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormModelEvent;
import org.netbeans.modules.form.FormModelListener;
import org.netbeans.modules.form.RADVisualComponent;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.layoutsupport.LayoutSupportManager;
import org.netbeans.modules.form.layoutsupport.delegates.GridBagControlCenter;
import org.netbeans.modules.form.layoutsupport.delegates.GridBagLayoutSupport;
import org.openide.explorer.propertysheet.PropertySheet;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Utilities;
import org.openide.windows.WindowManager;

public final class GridBagCustomizer
extends JPanel
implements Customizer {
    PropertyChangeSupport propertySupport = new PropertyChangeSupport(this);
    static final int TOP = 1;
    static final int BOTTOM = 2;
    static final int LEFT = 4;
    static final int RIGHT = 8;
    static final int HORIZONTAL = 12;
    static final int VERTICAL = 3;
    static final int PLUS = 1;
    static final int MINUS = -1;
    private static final ImageIcon REMAINDER_ICON = new ImageIcon(GridBagCustomizer.class.getResource("/org/netbeans/modules/form/layoutsupport/resources/remainder.gif"));
    private GridBagLayoutSupport layoutSupport;
    private FormModel formModel;
    private FormModelListener formListener;
    private RADVisualContainer radContainer;
    private RADVisualComponent[] radComponents;
    private GBComponentProxy[] gbcProxies;
    private JSplitPane splitPane;
    private JPanel designPanel;
    private GridBagControlCenter controlCenter;
    private GBContainerProxy containerProxy;
    private PropertySheet propertySheet;
    private JScrollPane designScrollPane;
    private JLayeredPane designLayeredPane;
    private GBComponentProxy.DragLabel dragLabel = null;
    private boolean firstPaint = false;
    static final long serialVersionUID = -632768048562391785L;

    public GridBagCustomizer() {
        this.initComponents();
    }

    private void initialize() {
        this.radContainer = ((LayoutSupportManager)this.layoutSupport.getLayoutSupportHack()).getMetaContainer();
        this.formModel = this.radContainer.getFormModel();
        this.radComponents = this.radContainer.getSubComponents();
        this.gbcProxies = new GBComponentProxy[this.radComponents.length];
        for (int i = 0; i < this.radComponents.length; ++i) {
            this.gbcProxies[i] = new GBComponentProxy(this.radComponents[i], this.containerProxy);
        }
        this.containerProxy.removeAll();
        FormDesigner designer = FormEditor.getFormDesigner(this.formModel);
        if (!designer.isInDesigner(this.radContainer)) {
            designer.setTopDesignComponent(this.radContainer, true);
            this.invokeLater(2, new Runnable(){

                @Override
                public void run() {
                    GridBagCustomizer.this.containerProxy.addAllProxies();
                }
            });
        } else {
            this.containerProxy.addAllProxies();
        }
        this.formListener = new FormListener();
        this.formModel.addFormModelListener(this.formListener);
    }

    void customizerClosed() {
        this.formModel.removeFormModelListener(this.formListener);
    }

    private void initComponents() {
        this.setBorder(new EmptyBorder(4, 0, 8, 0));
        this.setLayout(new BorderLayout());
        this.propertySheet = new PropertySheet();
        try {
            this.propertySheet.setSortingMode(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.propertySheet.setPreferredSize(new Dimension(300, 380));
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.propertySheet, "Center");
        this.controlCenter = new GridBagControlCenter(this);
        panel.add((Component)this.controlCenter, "South");
        this.designScrollPane = new JScrollPane();
        this.designPanel = new JPanel(){

            @Override
            public Dimension getPreferredSize() {
                return GridBagCustomizer.this.containerProxy.getPreferredSize();
            }
        };
        this.designPanel.setLayout(new GridBagLayout());
        Color bgColor = UIManager.getColor(Utilities.isMac() ? "Desktop.background" : "desktop");
        this.designPanel.setBackground(bgColor);
        GridBagConstraints con = new GridBagConstraints();
        con.anchor = 10;
        con.fill = 0;
        this.containerProxy = new GBContainerProxy();
        this.designPanel.add((Component)this.containerProxy, con);
        this.designLayeredPane = new JLayeredPane(){

            @Override
            public Dimension getPreferredSize() {
                Dimension dpd = GridBagCustomizer.this.designPanel.getPreferredSize();
                Dimension spd = GridBagCustomizer.this.designScrollPane.getViewport().getExtentSize();
                int width = Math.max(dpd.width + 40, spd.width);
                int height = Math.max(dpd.height + 40, spd.height);
                return new Dimension(Math.max(500, width), Math.max(300, height));
            }
        };
        this.designLayeredPane.add((Component)this.designPanel, JLayeredPane.DEFAULT_LAYER);
        this.designPanel.setBounds(20, 20, this.designPanel.getPreferredSize().width, this.designPanel.getPreferredSize().height);
        this.designLayeredPane.setOpaque(true);
        this.designLayeredPane.setBackground(bgColor);
        this.designScrollPane.setViewportView(this.designLayeredPane);
        this.splitPane = new JSplitPane(1);
        this.splitPane.setLeftComponent(panel);
        this.splitPane.setRightComponent(this.designScrollPane);
        this.splitPane.setUI(new BasicSplitPaneUI());
        this.splitPane.setBorder(BorderFactory.createEmptyBorder());
        this.splitPane.setContinuousLayout(true);
        this.add((Component)this.splitPane, "Center");
        this.getAccessibleContext().setAccessibleDescription(GridBagLayoutSupport.getBundleHack().getString("ACSD_GridBagCustomizer"));
        HelpCtx.setHelpIDString((JComponent)this, (String)"gui.layouts.gbcustomizer");
    }

    void setAnchor(int anchor) {
        List<GBComponentProxy> selected = this.containerProxy.getSelectedProxies();
        Iterator<GBComponentProxy> it = selected.iterator();
        while (it.hasNext()) {
            this.setProperty(it.next(), "anchor", new Integer(anchor));
        }
    }

    void setFill(int fill) {
        List<GBComponentProxy> selected = this.containerProxy.getSelectedProxies();
        Iterator<GBComponentProxy> it = selected.iterator();
        while (it.hasNext()) {
            this.setProperty(it.next(), "fill", new Integer(fill));
        }
    }

    void modifyIPad(int action, int what) {
        List<GBComponentProxy> selected = this.containerProxy.getSelectedProxies();
        for (GBComponentProxy p : selected) {
            int value;
            int n = value = what == 12 ? p.getRealConstraints().ipadx : p.getRealConstraints().ipady;
            if ((value += action) < 0) continue;
            this.setProperty(p, what == 12 ? "ipadx" : "ipady", new Integer(value));
        }
    }

    void modifyInsets(int action, int what) {
        List<GBComponentProxy> selected = this.containerProxy.getSelectedProxies();
        for (GBComponentProxy p : selected) {
            Insets old_insets = p.getRealConstraints().insets;
            Insets new_insets = (Insets)old_insets.clone();
            if ((what & 1) != 0) {
                new_insets.top += action;
                if (new_insets.top < 0) {
                    new_insets.top = 0;
                }
            }
            if ((what & 2) != 0) {
                new_insets.bottom += action;
                if (new_insets.bottom < 0) {
                    new_insets.bottom = 0;
                }
            }
            if ((what & 4) != 0) {
                new_insets.left += action;
                if (new_insets.left < 0) {
                    new_insets.left = 0;
                }
            }
            if ((what & 8) != 0) {
                new_insets.right += action;
                if (new_insets.right < 0) {
                    new_insets.right = 0;
                }
            }
            this.setProperty(p, "insets", new_insets);
        }
    }

    void modifyGridSize(int action, int what) {
        List<GBComponentProxy> selected = this.containerProxy.getSelectedProxies();
        for (GBComponentProxy p : selected) {
            int value;
            int n = value = what == 12 ? p.getRealConstraints().gridwidth : p.getRealConstraints().gridheight;
            if (action == 0) {
                value = value == 0 ? 1 : 0;
            } else if ((value += action) < 1) {
                value = 1;
            }
            this.setProperty(p, what == 12 ? "gridwidth" : "gridheight", new Integer(value));
        }
    }

    private void setProperty(GBComponentProxy p, String name, Object value) {
        Node.Property prop = p.getComponent().getPropertyByName("GridBagLayoutConstraints " + name);
        if (prop != null) {
            try {
                prop.setValue(value);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void setObject(Object bean) {
        this.layoutSupport = (GridBagLayoutSupport)bean;
        this.initialize();
        this.firstPaint = true;
    }

    void waitForDesignerUpdate(int count) {
        try {
            while (count > 0) {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                    }
                });
                --count;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void invokeLater(final int count, final Runnable task) {
        if (count == 0) {
            task.run();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GridBagCustomizer.this.invokeLater(count - 1, task);
                }
            });
        }
    }

    void innerLayoutChanged() {
        this.containerProxy.widenEmpty();
        this.designPanel.setBounds(20, 20, this.designPanel.getPreferredSize().width, this.designPanel.getPreferredSize().height);
        this.containerProxy.revalidate();
        this.designLayeredPane.revalidate();
    }

    public static class Window
    extends JDialog
    implements Customizer,
    ActionListener {
        private final GridBagCustomizer customizerPanel;
        private boolean packCalled;

        public Window() {
            super(WindowManager.getDefault().getMainWindow());
            ResourceBundle bundle = GridBagLayoutSupport.getBundleHack();
            this.setTitle(bundle.getString("CTL_CustomizerTitle"));
            this.getContentPane().setLayout(new BorderLayout(0, 0));
            this.customizerPanel = new GridBagCustomizer();
            this.getContentPane().add((Component)this.customizerPanel, "Center");
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new FlowLayout(2, 6, 6));
            JButton closeButton = new JButton();
            closeButton.setText(bundle.getString("CTL_CloseButton"));
            closeButton.setActionCommand("close");
            closeButton.addActionListener(this);
            buttonPanel.add(closeButton);
            JButton helpButton = new JButton();
            helpButton.setText(bundle.getString("CTL_HelpButton"));
            helpButton.setActionCommand("help");
            helpButton.addActionListener(this);
            buttonPanel.add(helpButton);
            this.getContentPane().add((Component)buttonPanel, "South");
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    customizerPanel.customizerClosed();
                }
            });
            this.setDefaultCloseOperation(2);
        }

        @Override
        public void pack() {
            if (this.packCalled) {
                return;
            }
            this.packCalled = true;
            super.pack();
            Dimension size = this.getSize();
            Rectangle screenBounds = Utilities.getUsableScreenBounds();
            if (size.width > screenBounds.width - 80) {
                size.width = screenBounds.width * 4 / 5;
            }
            if (size.height > screenBounds.height - 80) {
                size.height = screenBounds.height * 4 / 5;
            }
            this.setBounds(Utilities.findCenterBounds((Dimension)size));
        }

        @Override
        public void setObject(Object bean) {
            this.customizerPanel.setObject(bean);
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            if (ev.getActionCommand().equals("close")) {
                this.dispose();
            } else if (ev.getActionCommand().equals("help")) {
                KeyEvent event = new KeyEvent(this, 401, System.currentTimeMillis(), 0, 112, 'p');
                Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(event);
            }
        }
    }

    class GBContainerProxy
    extends JPanel {
        private GridBagLayout layout = new GridBagLayout();
        private boolean[][] empties;
        static final long serialVersionUID = 5113122235848232590L;

        GBContainerProxy() {
            this.setLayout(this.layout);
            this.setBorder(new BevelBorder(0));
            this.setOpaque(true);
        }

        void addAllProxies() {
            for (int i = 0; i < GridBagCustomizer.this.gbcProxies.length; ++i) {
                this.add((Component)GridBagCustomizer.this.gbcProxies[i], GridBagCustomizer.this.gbcProxies[i].getProxyConstraints());
            }
            this.invalidate();
            this.validate();
            GridBagCustomizer.this.innerLayoutChanged();
            this.widenEmpty();
            if (GridBagCustomizer.this.gbcProxies.length > 0) {
                this.select(GridBagCustomizer.this.gbcProxies[0]);
            }
        }

        void widenEmpty() {
            this.layout.columnWidths = null;
            this.layout.rowHeights = null;
            this.layout.layoutContainer(this);
            this.validate();
            int[][] dims = this.layout.getLayoutDimensions();
            this.empties = new boolean[2][];
            int[] widths = new int[dims[0].length];
            this.empties[0] = new boolean[dims[0].length];
            for (int i = 0; i < widths.length; ++i) {
                widths[i] = 25;
                this.empties[0][i] = dims[0][i] == 0;
            }
            this.layout.columnWidths = widths;
            int[] heights = new int[dims[1].length];
            this.empties[1] = new boolean[dims[1].length];
            for (int i = 0; i < heights.length; ++i) {
                heights[i] = 25;
                this.empties[1][i] = dims[1][i] == 0;
            }
            this.layout.rowHeights = heights;
        }

        @Override
        public void paint(Graphics g) {
            if (GridBagCustomizer.this.firstPaint) {
                GridBagCustomizer.this.innerLayoutChanged();
                GridBagCustomizer.this.firstPaint = false;
            }
            super.paint(g);
            if (GridBagCustomizer.this.gbcProxies.length > 0) {
                int i;
                Color emptyColor = new Color(255, 173, 173);
                Point origin = this.layout.getLayoutOrigin();
                int[][] dims = this.layout.getLayoutDimensions();
                int width = 0;
                for (int i2 = 0; i2 < dims[0].length; ++i2) {
                    width += dims[0][i2];
                }
                int height = 0;
                for (int i3 = 0; i3 < dims[1].length; ++i3) {
                    height += dims[1][i3];
                }
                int yCoord = origin.y;
                g.setColor(emptyColor);
                for (int i4 = 0; i4 < dims[1].length; ++i4) {
                    if (this.empties[1][i4]) {
                        g.setColor(emptyColor);
                        g.fillRect(origin.x, yCoord, width, dims[1][i4]);
                    }
                    yCoord += dims[1][i4];
                }
                int xCoord = origin.x;
                for (i = 0; i < dims[0].length; ++i) {
                    if (this.empties[0][i]) {
                        g.setColor(emptyColor);
                        g.fillRect(xCoord, origin.y, dims[0][i], height);
                    }
                    xCoord += dims[0][i];
                }
                g.setColor(Color.black);
                yCoord = dims[1][0] + origin.y - 1;
                for (i = 1; i < dims[1].length; ++i) {
                    g.drawLine(origin.x, yCoord, origin.x + width - 1, yCoord);
                    g.drawLine(origin.x, yCoord + 1, origin.x + width - 1, yCoord + 1);
                    yCoord += dims[1][i];
                }
                xCoord = dims[0][0] + origin.x - 1;
                for (i = 1; i < dims[0].length; ++i) {
                    g.drawLine(xCoord, origin.y, xCoord, origin.y + height - 1);
                    g.drawLine(xCoord + 1, origin.y, xCoord + 1, origin.y + height - 1);
                    xCoord += dims[0][i];
                }
            }
            this.paintChildren(g);
        }

        Point getLayoutLocation(Point p) {
            return this.layout.location(p.x, p.y);
        }

        void updateAllProxies() {
            for (int i = 0; i < GridBagCustomizer.this.gbcProxies.length; ++i) {
                this.updateProxy(GridBagCustomizer.this.gbcProxies[i]);
            }
            GridBagCustomizer.this.innerLayoutChanged();
            GridBagCustomizer.this.controlCenter.newSelection(this.getSelectedProxies());
        }

        void updateProxy(GBComponentProxy p) {
            p.updateByComponent();
            p.getProxyConstraints();
            this.layout.setConstraints(p, p.getProxyConstraints());
            p.invalidate();
            p.validate();
        }

        void invalidateAllProxies() {
            for (int i = 0; i < GridBagCustomizer.this.gbcProxies.length; ++i) {
                GridBagCustomizer.this.gbcProxies[i].invalidate();
            }
            this.doLayout();
        }

        List<GBComponentProxy> getSelectedProxies() {
            ArrayList<GBComponentProxy> selected = new ArrayList<GBComponentProxy>(GridBagCustomizer.this.gbcProxies.length);
            for (int i = 0; i < GridBagCustomizer.this.gbcProxies.length; ++i) {
                if (!GridBagCustomizer.this.gbcProxies[i].isSelected) continue;
                selected.add(GridBagCustomizer.this.gbcProxies[i]);
            }
            return selected;
        }

        Node[] getSelectedNodes() {
            List<GBComponentProxy> selected = this.getSelectedProxies();
            Node[] result = new Node[selected.size()];
            Iterator<GBComponentProxy> it = selected.iterator();
            int i = 0;
            while (it.hasNext()) {
                result[i] = it.next().getNode();
                ++i;
            }
            return result;
        }

        void select(GBComponentProxy p) {
            this.select(p, false);
        }

        void shiftSelect(GBComponentProxy p) {
            this.select(p, true);
        }

        void select(GBComponentProxy p, boolean shift) {
            List<GBComponentProxy> selected = this.getSelectedProxies();
            if (p.isSelected()) {
                if (selected.size() == 1) {
                    return;
                }
                if (shift) {
                    p.setSelected(false);
                } else {
                    Iterator<GBComponentProxy> it = selected.iterator();
                    while (it.hasNext()) {
                        it.next().setSelected(false);
                    }
                    p.setSelected(true);
                }
            } else {
                if (!shift) {
                    Iterator<GBComponentProxy> it = selected.iterator();
                    while (it.hasNext()) {
                        it.next().setSelected(false);
                    }
                }
                p.setSelected(true);
            }
            GridBagCustomizer.this.propertySheet.setNodes(this.getSelectedNodes());
            GridBagCustomizer.this.controlCenter.newSelection(this.getSelectedProxies());
        }
    }

    static class ComponentProxyNode
    extends FilterNode {
        ComponentProxyNode(Node original) {
            super(original);
        }

        public Node.PropertySet[] getPropertySets() {
            Node.PropertySet[] sets = super.getPropertySets();
            for (int i = 0; i < sets.length; ++i) {
                if (!"layout".equals(sets[i].getName())) continue;
                return new Node.PropertySet[]{sets[i]};
            }
            return new Node.PropertySet[0];
        }
    }

    class GBComponentProxy
    extends JPanel {
        private GBContainerProxy parentProxy;
        private RADVisualComponent component;
        private ComponentProxyNode node;
        private CompoundBorder compoundBorder;
        private MatteBorder insetsBorder;
        private MatteBorder remainderBorder;
        private JLabel componentLabel;
        private GridBagLayout layout;
        private Color INSETS_COLOR = new Color(255, 255, 204);
        private Color CELL_COLOR = new Color(153, 153, 255);
        private boolean isSelected = false;
        static final long serialVersionUID = -6552012922564179923L;

        GBComponentProxy(final RADVisualComponent component, GBContainerProxy parentProxy) {
            this.component = component;
            this.parentProxy = parentProxy;
            this.componentLabel = new JLabel(){

                @Override
                public void paint(Graphics g) {
                    int borderSize = 5;
                    Color borderColor = Color.blue;
                    super.paint(g);
                    if (GBComponentProxy.this.isSelected()) {
                        Dimension size = this.getSize();
                        g.setColor(borderColor);
                        g.fillRect(0, 0, borderSize, borderSize);
                        g.fillRect(size.width - borderSize, 0, borderSize, borderSize);
                        g.fillRect(0, size.height - borderSize, borderSize, borderSize);
                        g.fillRect(size.width - borderSize, size.height - borderSize, borderSize, borderSize);
                    }
                }

                @Override
                public Dimension getPreferredSize() {
                    Dimension size;
                    FormDesigner designer = FormEditor.getFormDesigner(GridBagCustomizer.this.formModel);
                    Component comp = (Component)designer.getComponent(component);
                    if (comp == null) {
                        comp = (Component)component.getBeanInstance();
                        size = comp.getPreferredSize();
                    } else if (comp.isShowing()) {
                        size = comp.getSize();
                        if (size.width > 4096) {
                            size.width = comp.getPreferredSize().width;
                        }
                    } else {
                        size = comp.getPreferredSize();
                    }
                    size = new Dimension(size);
                    if (comp instanceof JComponent && !(comp instanceof JPanel)) {
                        Border b;
                        Insets thisIns = this.getInsets();
                        if (comp instanceof JComponent && (b = ((JComponent)comp).getBorder()) != null) {
                            Insets ins = b.getBorderInsets(comp);
                            thisIns.top -= ins.top;
                            thisIns.left -= ins.left;
                            thisIns.bottom -= ins.bottom;
                            thisIns.right -= ins.right;
                        }
                        if (thisIns.top > 0) {
                            size.height += thisIns.top;
                        }
                        if (thisIns.bottom > 0) {
                            size.height += thisIns.bottom;
                        }
                        if (thisIns.left > 0) {
                            size.width += thisIns.left;
                        }
                        if (thisIns.right > 0) {
                            size.width += thisIns.right;
                        }
                    }
                    if (size.width < 6) {
                        size.width = 6;
                    }
                    if (size.height < 6) {
                        size.height = 6;
                    }
                    return size;
                }

                @Override
                public Dimension getMinimumSize() {
                    Component comp = (Component)FormEditor.getFormDesigner(GridBagCustomizer.this.formModel).getComponent(component);
                    if (comp == null) {
                        comp = (Component)component.getBeanInstance();
                    }
                    return comp.getMinimumSize();
                }

                @Override
                public Dimension getMaximumSize() {
                    Component comp = (Component)FormEditor.getFormDesigner(GridBagCustomizer.this.formModel).getComponent(component);
                    if (comp == null) {
                        comp = (Component)component.getBeanInstance();
                    }
                    return comp.getMaximumSize();
                }
            };
            this.componentLabel.setOpaque(true);
            this.componentLabel.setBorder(new EtchedBorder());
            this.componentLabel.setText(component.getName());
            this.componentLabel.setHorizontalAlignment(0);
            this.componentLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    GBComponentProxy.this.mouseClicked(evt);
                }

                @Override
                public void mousePressed(MouseEvent evt) {
                    GBComponentProxy.this.mousePressed(evt);
                }

                @Override
                public void mouseReleased(MouseEvent evt) {
                    GBComponentProxy.this.mouseReleased(evt);
                }
            });
            this.componentLabel.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseDragged(MouseEvent evt) {
                    GBComponentProxy.this.mouseDragged(evt);
                }
            });
            this.layout = new GridBagLayout();
            this.setLayout(this.layout);
            this.setBackground(this.CELL_COLOR);
            this.setOpaque(true);
            this.updateByComponent();
            this.add((Component)this.componentLabel, this.getInnerComponentConstraints());
            this.node = new ComponentProxyNode((Node)component.getNodeReference());
        }

        RADVisualComponent getComponent() {
            return this.component;
        }

        GridBagConstraints getRealConstraints() {
            return (GridBagConstraints)this.component.getParentContainer().getLayoutSupport().getConstraints(this.component).getConstraintsObject();
        }

        ComponentProxyNode getNode() {
            return this.node;
        }

        void updateByComponent() {
            this.layout.setConstraints(this.componentLabel, this.getInnerComponentConstraints());
        }

        GridBagConstraints getInnerComponentConstraints() {
            GridBagConstraints con = new GridBagConstraints();
            con.anchor = this.getRealConstraints().anchor;
            con.fill = this.getRealConstraints().fill;
            con.gridheight = 1;
            con.gridwidth = 1;
            con.gridx = 0;
            con.gridy = 0;
            con.ipadx = this.getRealConstraints().ipadx;
            con.ipady = this.getRealConstraints().ipady;
            con.weightx = 1.0;
            con.weighty = 1.0;
            return con;
        }

        GridBagConstraints getProxyConstraints() {
            GridBagConstraints con = new GridBagConstraints();
            con.anchor = 10;
            con.fill = 1;
            con.gridheight = this.getRealConstraints().gridheight;
            con.gridwidth = this.getRealConstraints().gridwidth;
            con.gridx = this.getRealConstraints().gridx;
            con.gridy = this.getRealConstraints().gridy;
            con.insets = new Insets(3, 3, 3, 3);
            con.ipadx = 0;
            con.ipady = 0;
            con.weightx = 1.0;
            con.weighty = 1.0;
            Insets in = this.getRealConstraints().insets;
            this.insetsBorder = new MatteBorder(in.top, in.left, in.bottom, in.right, this.INSETS_COLOR);
            this.remainderBorder = new MatteBorder(0, 0, con.gridheight == 0 ? 4 : 0, con.gridwidth == 0 ? 4 : 0, REMAINDER_ICON);
            this.compoundBorder = new CompoundBorder(this.remainderBorder, this.insetsBorder);
            this.setBorder(this.compoundBorder);
            return con;
        }

        boolean isSelected() {
            return this.isSelected;
        }

        void setSelected(boolean isSelected) {
            if (this.isSelected == isSelected) {
                return;
            }
            this.isSelected = isSelected;
            this.componentLabel.repaint();
        }

        void mouseClicked(MouseEvent evt) {
        }

        void mousePressed(MouseEvent evt) {
            if (evt.isControlDown()) {
                this.parentProxy.shiftSelect(this);
            } else {
                this.parentProxy.select(this);
            }
        }

        void mouseReleased(MouseEvent evt) {
            if (GridBagCustomizer.this.dragLabel != null) {
                if (!GridBagCustomizer.this.dragLabel.getLastIndex().equals(GridBagCustomizer.this.dragLabel.getOriginalIndex())) {
                    GridBagCustomizer.this.setProperty(this, "gridx", new Integer(((GridBagCustomizer)GridBagCustomizer.this).dragLabel.getLastIndex().x));
                    GridBagCustomizer.this.setProperty(this, "gridy", new Integer(((GridBagCustomizer)GridBagCustomizer.this).dragLabel.getLastIndex().y));
                }
                GridBagCustomizer.this.designLayeredPane.remove(GridBagCustomizer.this.dragLabel);
                GridBagCustomizer.this.dragLabel = null;
                this.componentLabel.setCursor(Cursor.getDefaultCursor());
                GridBagCustomizer.this.designLayeredPane.repaint();
            }
        }

        void mouseDragged(MouseEvent evt) {
            if (GridBagCustomizer.this.dragLabel == null) {
                if (this.isSelected()) {
                    GridBagCustomizer.this.dragLabel = new DragLabel();
                    GridBagCustomizer.this.dragLabel.setHotSpot(evt.getPoint());
                    GridBagCustomizer.this.dragLabel.resolveOrigin();
                    GridBagCustomizer.this.dragLabel.setLastIndex(GridBagCustomizer.this.dragLabel.getIndex(evt.getPoint()));
                    GridBagCustomizer.this.dragLabel.setOriginalIndex(GridBagCustomizer.this.dragLabel.getIndex(evt.getPoint()));
                    GridBagCustomizer.this.designLayeredPane.setLayer(GridBagCustomizer.this.dragLabel, JLayeredPane.DRAG_LAYER);
                    GridBagCustomizer.this.designLayeredPane.add((Component)GridBagCustomizer.this.dragLabel, "Center");
                    GridBagCustomizer.this.dragLabel.setBounds(evt.getPoint().x, evt.getPoint().y);
                    this.componentLabel.setCursor(Cursor.getPredefinedCursor(13));
                }
            } else {
                Point newLoc = GridBagCustomizer.this.dragLabel.getIndex(evt.getPoint());
                if (!GridBagCustomizer.this.dragLabel.getLastIndex().equals(newLoc)) {
                    Point converted = SwingUtilities.convertPoint(GridBagCustomizer.this.dragLabel, evt.getPoint(), GridBagCustomizer.this.designLayeredPane);
                    GridBagConstraints con = this.getProxyConstraints();
                    con.gridx = newLoc.x;
                    con.gridy = newLoc.y;
                    this.parentProxy.layout.setConstraints(this, con);
                    GridBagCustomizer.this.dragLabel.resolveOrigin();
                    SwingUtilities.convertPoint(GridBagCustomizer.this.designLayeredPane, converted, GridBagCustomizer.this.dragLabel);
                    Rectangle r = GridBagCustomizer.this.dragLabel.getBounds();
                    Point loc = r.getLocation();
                    loc.x += r.width + 20;
                    loc.y += r.height + 20;
                    GridBagCustomizer.this.innerLayoutChanged();
                    GridBagCustomizer.this.dragLabel.repaint();
                    GridBagCustomizer.this.dragLabel.setLastIndex(newLoc);
                } else {
                    GridBagCustomizer.this.dragLabel.setBounds(evt.getPoint().x, evt.getPoint().y);
                }
            }
        }

        class DragLabel
        extends JLabel {
            Point origin;
            Point hotSpot;
            Point lastIndex;
            Point originalIndex;
            private Dimension preferredSize;
            static final long serialVersionUID = 992490305277357953L;

            DragLabel() {
                this.setOpaque(false);
                this.setEnabled(false);
                this.setBorder(new EtchedBorder());
                this.setText(GBComponentProxy.this.component.getName());
                this.setHorizontalAlignment(0);
                this.preferredSize = (Dimension)GBComponentProxy.this.componentLabel.getPreferredSize().clone();
            }

            @Override
            public Dimension getPreferredSize() {
                this.preferredSize.height = ((GBComponentProxy)GBComponentProxy.this).componentLabel.getPreferredSize().height + GBComponentProxy.this.getRealConstraints().ipady;
                this.preferredSize.width = ((GBComponentProxy)GBComponentProxy.this).componentLabel.getPreferredSize().width + GBComponentProxy.this.getRealConstraints().ipadx;
                return this.preferredSize;
            }

            @Override
            public Dimension getMinimumSize() {
                return GBComponentProxy.this.componentLabel.getMinimumSize();
            }

            @Override
            public Dimension getMaximumSize() {
                return GBComponentProxy.this.componentLabel.getMaximumSize();
            }

            void setHotSpot(Point hotSpot) {
                this.hotSpot = hotSpot;
            }

            void resolveOrigin() {
                this.origin = SwingUtilities.convertPoint(GBComponentProxy.this.componentLabel, 0, 0, GridBagCustomizer.this.designLayeredPane);
            }

            Point getLastIndex() {
                return this.lastIndex;
            }

            void setLastIndex(Point lastIndex) {
                this.lastIndex = lastIndex;
            }

            Point getOriginalIndex() {
                return this.originalIndex;
            }

            void setOriginalIndex(Point originalIndex) {
                this.originalIndex = originalIndex;
            }

            Point getIndex(Point p) {
                return GBComponentProxy.this.parentProxy.getLayoutLocation(SwingUtilities.convertPoint(GBComponentProxy.this.componentLabel, p, GBComponentProxy.this.parentProxy));
            }

            public void setBounds(int x, int y) {
                this.resolveOrigin();
                super.setBounds(this.origin.x + x - this.hotSpot.x, this.origin.y + y - this.hotSpot.y, this.getPreferredSize().width, this.getPreferredSize().height);
            }
        }
    }

    class FormListener
    implements FormModelListener {
        FormListener() {
        }

        @Override
        public void formChanged(FormModelEvent[] events) {
            if (events != null && GridBagCustomizer.this.isShowing()) {
                boolean modifying = false;
                for (int i = 0; i < events.length; ++i) {
                    if (!events[i].isModifying()) continue;
                    modifying = true;
                    break;
                }
                if (!modifying) {
                    return;
                }
                GridBagCustomizer.this.invokeLater(3, new Runnable(){

                    @Override
                    public void run() {
                        GridBagCustomizer.this.containerProxy.updateAllProxies();
                    }
                });
            }
        }
    }
}

