/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutdesign.support;

import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.form.layoutdesign.LayoutComponent;
import org.netbeans.modules.form.layoutdesign.LayoutConstants;
import org.netbeans.modules.form.layoutdesign.LayoutInterval;
import org.netbeans.modules.form.layoutdesign.LayoutModel;
import org.netbeans.modules.form.layoutdesign.support.SwingLayoutUtils;

public class SwingLayoutCodeGenerator {
    private static final String LAYOUT_VAR_NAME = "layout";
    private String layoutVarName;
    private boolean useLayoutLibrary;
    private Map<String, ComponentInfo> componentIDMap = new HashMap<String, ComponentInfo>();
    private Set<LayoutInterval> unsupportedContResGaps;

    public SwingLayoutCodeGenerator(LayoutModel layoutModel) {
    }

    public void generateContainerLayout(Writer writer, LayoutComponent container, String contExprStr, String contVarName, ComponentInfo[] infos, boolean useLibrary) throws IOException {
        LayoutInterval[][] extraRoots;
        this.useLayoutLibrary = useLibrary;
        this.layoutVarName = contVarName == null ? LAYOUT_VAR_NAME : contVarName + Character.toUpperCase(LAYOUT_VAR_NAME.charAt(0)) + LAYOUT_VAR_NAME.substring(1);
        this.unsupportedContResGaps = null;
        this.fillMap(infos);
        this.generateInstantiation(writer, contExprStr);
        int rootCount = container.getLayoutRootCount();
        if (rootCount > 1) {
            extraRoots = new LayoutInterval[2][rootCount - 1];
            for (int i = 1; i < rootCount; ++i) {
                for (int dim = 0; dim < 2; ++dim) {
                    extraRoots[dim][i - 1] = container.getLayoutRoot(i, dim);
                    assert (extraRoots[dim][i - 1].isParallel());
                }
            }
        } else {
            extraRoots = null;
        }
        for (int dim = 0; dim < 2; ++dim) {
            StringBuilder sb = new StringBuilder();
            this.composeGroup(sb, container.getLayoutRoot(0, dim), extraRoots != null ? extraRoots[dim] : null, true, true);
            writer.write(this.layoutVarName + (dim == 0 ? ".setHorizontalGroup(\n" : ".setVerticalGroup(\n") + sb.toString() + "\n);\n");
            sb = new StringBuilder();
            this.composeLinks(sb, container, this.layoutVarName, dim);
            writer.write(sb.toString());
        }
        this.unsupportedContResGaps = null;
    }

    private void fillMap(ComponentInfo[] infos) {
        for (int counter = 0; counter < infos.length; ++counter) {
            this.componentIDMap.put(infos[counter].id, infos[counter]);
        }
    }

    private void generateInstantiation(Writer writer, String contExprStr) throws IOException {
        writer.write(this.getLayoutName() + " " + this.layoutVarName + " ");
        writer.write("= new " + this.getLayoutName() + "(" + contExprStr + ");\n");
        writer.write(contExprStr + ".setLayout(" + this.layoutVarName + ");\n");
    }

    private void composeGroup(StringBuilder layout, LayoutInterval group, LayoutInterval[] extraGroups, boolean first, boolean last) throws IOException {
        int groupAlignment = group.getGroupAlignment();
        if (group.isParallel()) {
            boolean notResizable = group.getMaximumSize() == -2;
            String alignmentStr = this.convertAlignment(groupAlignment);
            layout.append(this.layoutVarName).append(".createParallelGroup(");
            layout.append(alignmentStr);
            if (notResizable) {
                layout.append(", false");
            }
            layout.append(")");
        } else {
            layout.append(this.layoutVarName).append(".createSequentialGroup()");
        }
        Iterator<LayoutInterval> subIntervals = group.getSubIntervals();
        while (subIntervals.hasNext()) {
            layout.append("\n");
            LayoutInterval subInterval = subIntervals.next();
            this.fillGroup(layout, subInterval, first, last && (!group.isSequential() || !subIntervals.hasNext() && extraGroups == null), groupAlignment);
            if (!first || !group.isSequential()) continue;
            first = false;
        }
        if (extraGroups != null) {
            for (LayoutInterval g : extraGroups) {
                layout.append("\n");
                this.fillGroup(layout, g, first, last, groupAlignment);
            }
        }
    }

    private void fillGroup(StringBuilder layout, LayoutInterval interval, boolean first, boolean last, int groupAlignment) throws IOException {
        if (interval.isGroup()) {
            LayoutInterval contResGap;
            layout.append(this.getAddGroupStr());
            int alignment = interval.getAlignment();
            if (interval.isSequential() && last && (contResGap = SwingLayoutUtils.getUnsupportedResizingContainerGap(interval)) != null) {
                this.addUnsupportedContResGap(contResGap);
                alignment = 0;
            }
            if (alignment != -1 && interval.getParent().isParallel() && alignment != groupAlignment && alignment != 3 && groupAlignment != 3) {
                String alignmentStr = this.convertAlignment(alignment);
                layout.append(alignmentStr).append(", ");
            }
            this.composeGroup(layout, interval, null, first, last);
        } else {
            int min = interval.getMinimumSize();
            int pref = interval.getPreferredSize();
            int max = interval.getMaximumSize();
            if (interval.isComponent()) {
                boolean horizontal;
                layout.append(this.getAddComponentStr());
                int alignment = interval.getAlignment();
                LayoutComponent layoutComp = interval.getComponent();
                ComponentInfo info = this.componentIDMap.get(layoutComp.getId());
                boolean bl = horizontal = layoutComp.getLayoutInterval(0) == interval;
                if (min == -1) {
                    if (horizontal && info.component.getClass().getName().equals("javax.swing.JComboBox")) {
                        min = 0;
                    } else if (pref >= 0) {
                        int compMin;
                        Dimension minSize = info.component.getMinimumSize();
                        int n = compMin = horizontal ? minSize.width : minSize.height;
                        if (compMin > pref) {
                            min = -2;
                        }
                    }
                }
                if (pref == 0 && max >= Short.MAX_VALUE && horizontal && layoutComp.getLayoutInterval(1).getAlignment() == 3) {
                    pref = 1;
                }
                assert (info.variableName != null);
                if (interval.getParent().isSequential() || alignment == -1 || alignment == groupAlignment || alignment == 3 || groupAlignment == 3) {
                    layout.append(info.variableName);
                } else {
                    String alignmentStr = this.convertAlignment(alignment);
                    if (this.useLayoutLibrary()) {
                        layout.append(alignmentStr).append(", ").append(info.variableName);
                    } else {
                        layout.append(info.variableName).append(", ").append(alignmentStr);
                    }
                }
                int status = SwingLayoutUtils.getResizableStatus(info.component);
                if (pref != -1 || min != -1 && (min != -2 || info.sizingChanged || status != 0) || max != -1 && (max != -2 || info.sizingChanged || status != 0) && (max != Short.MAX_VALUE || info.sizingChanged || status != 1)) {
                    layout.append(", ");
                    this.generateSizeParams(layout, min, pref, max);
                }
            } else if (interval.isEmptySpace()) {
                boolean preferredGap;
                LayoutConstants.PaddingType gapType = interval.getPaddingType();
                if (interval.isDefaultPadding()) {
                    if (gapType != null && gapType == LayoutConstants.PaddingType.SEPARATE) {
                        preferredGap = false;
                        if (min == -1) {
                            min = 18;
                        }
                        if (pref == -1) {
                            pref = 18;
                        }
                    } else {
                        preferredGap = true;
                    }
                } else {
                    preferredGap = false;
                }
                if (preferredGap) {
                    if (first || last) {
                        layout.append(this.getAddContainerGapStr());
                    } else {
                        layout.append(this.getAddPreferredGapStr());
                        if (gapType == LayoutConstants.PaddingType.INDENT) {
                            max = -1;
                            pref = -1;
                        }
                        layout.append(this.getPaddingTypeStr(gapType));
                    }
                    if (pref != -1 || max != -1 && max != -2 && (!last || !this.isUnsupportedContResGap(interval))) {
                        if (!first && !last) {
                            layout.append(',').append(' ');
                        }
                        layout.append(this.convertSize(pref)).append(", ");
                        layout.append(this.convertSize(max));
                    }
                } else {
                    if (min == -2) {
                        min = pref;
                    }
                    if (max == -2) {
                        max = pref;
                    }
                    layout.append(this.getAddGapStr());
                    if (min < 0) {
                        min = pref;
                    }
                    min = Math.min(pref, min);
                    max = Math.max(pref, max);
                    this.generateSizeParams(layout, min, pref, max);
                }
            } else assert (false);
        }
        layout.append(")");
    }

    private void generateSizeParams(StringBuilder layout, int min, int pref, int max) {
        layout.append(this.convertSize(min)).append(", ");
        layout.append(this.convertSize(pref)).append(", ");
        layout.append(this.convertSize(max));
    }

    private String convertAlignment(int alignment) {
        String groupAlignment = null;
        switch (alignment) {
            case 0: {
                groupAlignment = "LEADING";
                break;
            }
            case 1: {
                groupAlignment = "TRAILING";
                break;
            }
            case 2: {
                groupAlignment = "CENTER";
                break;
            }
            case 3: {
                groupAlignment = "BASELINE";
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return this.useLayoutLibrary() ? this.getLayoutName() + "." + groupAlignment : this.getLayoutName() + ".Alignment." + groupAlignment;
    }

    private String convertSize(int size) {
        String convertedSize;
        switch (size) {
            case -1: {
                convertedSize = this.getLayoutName() + ".DEFAULT_SIZE";
                break;
            }
            case -2: {
                convertedSize = this.getLayoutName() + ".PREFERRED_SIZE";
                break;
            }
            case 32767: {
                convertedSize = "Short.MAX_VALUE";
                break;
            }
            default: {
                convertedSize = size >= 0 ? Integer.toString(size) : this.getLayoutName() + ".DEFAULT_SIZE";
            }
        }
        return convertedSize;
    }

    private void composeLinks(StringBuilder layout, LayoutComponent containerLC, String layoutVarName, int dimension) throws IOException {
        Map<Integer, List<String>> linkSizeGroups = SwingLayoutUtils.createLinkSizeGroups(containerLC, dimension);
        Collection<List<String>> linkGroups = linkSizeGroups.values();
        for (List<String> l : linkGroups) {
            Collections.sort(l, new Comparator<String>(){

                @Override
                public int compare(String id1, String id2) {
                    ComponentInfo info1 = (ComponentInfo)SwingLayoutCodeGenerator.this.componentIDMap.get(id1);
                    ComponentInfo info2 = (ComponentInfo)SwingLayoutCodeGenerator.this.componentIDMap.get(id2);
                    return info1.variableName.compareTo(info2.variableName);
                }
            });
            if (l.size() <= 1) continue;
            layout.append("\n\n").append(layoutVarName).append(".linkSize(");
            if (!this.useLayoutLibrary()) {
                layout.append("javax.swing.SwingConstants");
                layout.append(dimension == 0 ? ".HORIZONTAL, " : ".VERTICAL, ");
            }
            layout.append("new java.awt.Component[] {");
            Iterator<String> i = l.iterator();
            boolean first = true;
            while (i.hasNext()) {
                String cid = i.next();
                ComponentInfo info = this.componentIDMap.get(cid);
                if (first) {
                    first = false;
                    layout.append(info.variableName);
                    continue;
                }
                layout.append(", ").append(info.variableName);
            }
            layout.append("}");
            if (this.useLayoutLibrary()) {
                layout.append(", ");
                layout.append(this.getLayoutName());
                layout.append(dimension == 0 ? ".HORIZONTAL" : ".VERTICAL");
            }
            layout.append(");\n\n");
        }
    }

    boolean useLayoutLibrary() {
        return this.useLayoutLibrary;
    }

    private String getLayoutName() {
        return this.useLayoutLibrary() ? "org.jdesktop.layout.GroupLayout" : "javax.swing.GroupLayout";
    }

    private String getLayoutStyleName() {
        return this.useLayoutLibrary() ? "org.jdesktop.layout.LayoutStyle" : "javax.swing.LayoutStyle";
    }

    private String getAddComponentStr() {
        return this.useLayoutLibrary() ? ".add(" : ".addComponent(";
    }

    private String getAddGapStr() {
        return this.useLayoutLibrary() ? ".add(" : ".addGap(";
    }

    private String getAddPreferredGapStr() {
        return ".addPreferredGap(";
    }

    private String getAddContainerGapStr() {
        return ".addContainerGap(";
    }

    private String getAddGroupStr() {
        return this.useLayoutLibrary() ? ".add(" : ".addGroup(";
    }

    private String getPaddingTypeStr(LayoutConstants.PaddingType paddingType) {
        String str;
        if (paddingType == null || paddingType == LayoutConstants.PaddingType.RELATED) {
            str = ".RELATED";
        } else if (paddingType == LayoutConstants.PaddingType.UNRELATED) {
            str = ".UNRELATED";
        } else if (paddingType == LayoutConstants.PaddingType.INDENT) {
            str = ".INDENT";
        } else {
            return null;
        }
        return this.getLayoutStyleName() + (this.useLayoutLibrary ? "" : ".ComponentPlacement") + str;
    }

    private void addUnsupportedContResGap(LayoutInterval gap) {
        if (this.unsupportedContResGaps == null) {
            this.unsupportedContResGaps = new HashSet<LayoutInterval>();
        }
        this.unsupportedContResGaps.add(gap);
    }

    private boolean isUnsupportedContResGap(LayoutInterval gap) {
        return this.unsupportedContResGaps != null && this.unsupportedContResGaps.contains(gap);
    }

    public static class ComponentInfo {
        public String id;
        public String variableName;
        public Component component;
        public boolean sizingChanged;
    }
}

